


\begin{tt}
\begin{verbatim}


/*  We provide a number of definitions of the even function.  */

module even0.
export even0(b).

/* A definition with non-stratified negation.  It is implemented using
Ordered Search.  */

even0(0).
even0(X) :- X > 1, Y = X-1, not even0(Y).

end_module.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

module even1.
export even1(b).
@pipelining.

/*  The evaluation method is pipelining, and the semantics for negation
is negation as failure.  In this example, the modular stratified
semantics (which holds in non-pipelined modules) and negation as
failure happen to coincide.  */

even1(0).
even1(X) :- X > 1, not even1(X-1).

end_module.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


module even2.
export even2(b).

/*  The same function defined without negation.  Of course,
not all definitions with negation can be replaced by a 
negation-free definition.  */

even2(0).
even2(Y) :- Y>0, X = Y-2, even2(X).

end_module.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


module even22.
export even22(b).
@ordered_search.

/*  Identical to even2, except for the use of Ordered Search.
The slow-down relative to even2 indicates the overhead of 
doing Ordered Search.  */

even22(0).
even22(Y) :- Y>0, X = Y-2, even22(X).

end_module.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

module even3.
export even3(b).

/*  This module, in conjunction with Module even33, indicates how the 
modularly stratified semantics can be realized for
some programs without using Ordered Search.  The idea is to set up
a chain of inter-module calls, each of which is fully evaluated.  
Of course, a cycle of calls would result in infinite looping.  
In contrast, the Ordered Search mechanism deals with cycles, except 
cycles involving a negated call, in which case the modularly stratified
semantics is itself undefined.  (In this program, it so happens
that every chain of calls includes negated calls.  If it is possible that
there is some cycle of positive calls, but no cycle of negative calls,
this ``call based'' approach to negation would result in an infinite
loop; Ordered Search will still compute the well-founded model, since
the program is  modularly stratified.) 

This program is also less efficient than even0 (which uses Ordered Search)
due to the overhead of inter-module calls.  */

even3(0).
even3(X) :- X>1, Y = X-1, not even33(Y).

end_module.

module even33.
export even33(b).

even33(X) :- even3(X).

end_module.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


\end{verbatim}
\end{tt}


