\begin{tt}
\begin{verbatim}

/*
 * Example of a builtin relation definition that is to be incrementally loaded.
 * This builtin demonstrates the use of Arg * to allow arbitrary CORAL
 * structured arguments to be manipulated by user-defined code.
 */

#include <stdio.h>

/*
 * The builtin sum_list(X, Y) takes a list X as its first argument and 
 * returns the summation of the list in the second argument.
 */

_coral_export int sum_list(Arg *);

int sum_list(Arg *input_list)
{
  int sum = 0;
  Arg *temp;

  /* first check that the input argument is indeed a list */
  if (!input_list || !(is_list(input_list))) {
    fprintf(stderr, "WARNING ! : non-list argument \n");
    return -1;
  }

  /* iterate through the list, summing the elements */
  while (input_list) {

    temp = make_car(input_list);

    /* check that each list element is an integer */
    if (!temp || !is_int(temp)) {
      fprintf(stderr, "WARNING ! : non-integer list member \n");
      return -1;
    }

    sum += make_int(temp);
    input_list = make_cdr(input_list);
  }

  return sum;
}

\end{verbatim}
\end{tt}
