
module pipe1.
@pipelining.

export raise1(b), raise2(b).

% Give everyone in the named department a 10 percent raise.
% To understand this program, it is important to note that builtins 
% (such as insert/delete here) do not succeed repeatedly on backtracking.

% dept(Dname, Ename, Sal) is a base relation to be updated.
% Note that there is no guarantee as to the order of tuples in dept,
% or the location of inserted tuples.  Thus, raise1 may give some
% employee two raises!

raise1(Dept) :-  dept(Dept, Emp, Sal), Newsal = 1.1*Sal,
		delete(dept(Dept, Emp, Sal)),
		insert(dept(Dept, Emp, Newsal)).

% This ensures that each employee receives exactly one raise.

raise2(Dept) :-  find_new_sals(Dept), add(dept, dept2).

find_new_sals(Dept) :-  dept(Dept, Emp, Sal), Newsal = 1.1*Sal,
		delete(dept(Dept, Emp, Sal)),
		insert(dept2(Dept, Emp, Newsal)).

add(dept, dept2) :- dept2(Dept, Emp, Sal), 
		delete(dept2(Dept, Emp, Sal)),
		insert(dept(Dept, Emp, Sal)).

end_module.


% sample data 

dept(toys, sue, 30).
dept(toys, john, 20).
dept(bolts, henry, 30).
dept(nuts, sarah, 40).

