
module declac_eg5a.

export anc(ff).

@allowed_adornments anc[ff].  % keeps the rewritten program simple; the
			      % adorned form anc_bf is not optimized.

/*  This program computes transitive closure.  We use it here to 
illustrate the indexing facilities in CORAL.  Actually, the 
index declarations in this program are not needed, since CORAL automatically 
generates them!  The goal here is to illustrate the syntax.  Inputs 
in declac1a.F and declac1b.F */

@make_index anc[ff] (bf).  % create an index on the first argument 
			   % of the derived predicate anc_ff 
			   % (automatically maintained as tuples are added.)

@make_index anc[ff] (X,Y) (X).	% means the same thing.  even if both 
				% these annotations are specified, 
				% only one copy of the index is created.

@index_deltas +.  	% states that the set of new anc tuples (delta) is to
			% be indexed.  (this is the default.)
			% run ?anc(X,Y) on the data in declac1a.F with
			% @index_deltas+ and @index_deltas- and see the difference!

anc(X,Y) :- parent(X,Y).
anc(X,Z) :- anc(X,Y), anc(Y,Z).

end_module.


module declac_eg5b.
export append(bbf).

/*  This is the familiar program for appending two lists.  By moving 
the structure in the bound argument into the body, we avoid creating
some structures at run-time.  However, append is really a program
best suited for Prolog-style evaluation.  In CORAL, this is
approximated by using pipelining. 

We use this program to illustrate some aspects of indexing in CORAL.  
A sample input set is in declac5.F  */

@index_deltas -.	% in each iteration, just one tuple is generated.
			% clearly, indexing deltas is not a good idea.

@check_subsumption -.   % each tuple (including the magic tuples) is
			% generated precisely once; the overhead of
			% subsumption checks can be avoided.

% The following annotation is not needed; this index is automatically
% created by CORAL.  we have included it for two reasons.  (1) It shows
% the syntax for a PATTERN-FORM index.  (2) It underscores the point
% that CORAL generates indexes on the rewritten program.  (In fact,
% index creation is done by analysing the program after seminaive 
% rewriting!)

% The annotation specifies an index in which each tuple is required to 
% meet the pattern ([X|Y],Z) in the bound arguments; an index on (Y,Z) 
% pairs is created.

@make_index m_append [bbf] ([X|Y],Z) (Y,Z).

append([], X, X).
append(U, Z, [X|W]) :- U=[X|Y], append(Y, Z, W).

end_module.
