
\begin{tt}
\begin{verbatim}

module declad_eg6b.
export spath(bbff).

/*  Illustrates monotonic programs.  Although the 3rd argument value
may not be the least cost between the nodes in the first two arguments
for intermediate spath facts, this is indeed true of all spath facts
when the computation terminates.  (Contrast this with the previous
program.)

Note that this program works even on cyclic graphs as long as there
are no negative cycles.  The reason is that the min operation  in the
aggregate selection retains only the current shortest paths.  

The input for this program is an edge relation; sample inputs are
provided in files declad6.cyc.F and declad6.acyc.F.  */

spath(X,Y,C,[X,Y]) :-  edge(X,Y,C).
spath(X,Y,C,[X|P]) :-  edge(X,Z,C1), spath(Z,Y,C2,P), C=C1+C2.

@aggregate_selection spath(X,Y,C,P) (X,Y) min(C).
@aggregate_selection spath(X,Y,C,P) (X,Y,C) any(P).

% The following annotation ensures that the (current) shortest path is expanded
% at each step.  (This may actually slow down the computation if the overhead
% involved is not offset by the gains for a given data set.)

@prioritize spath(X,Y,C,P) min(C).

end_module.

\end{verbatim}
\end{tt}

