
\begin{tt}
\begin{verbatim}

module decalc_eg4.
export joinans1(), joinans2(), joinans3(), joinans4().

/* This is a collection of simple joins.  It can be used to get
some idea of CORAL performance relative to systems like LDL or
Quintus Prolog on non-recursive Datalog programs.  While comparing 
with Prolog, use @check_subsumption-, since Prolog does not do
any subsumption checks.

Try each of the following annotations to see how they perform.  
@no_rewriting and @pipelining should behave similarly on this program.  
@magic will be a little worse since it creates filters (magic relations)
that provide no restriction.  @sup_magic will be similar to magic
on joinans1 and joinans2, but will be faster on joinans3.
If you examine the file declac4.P.M after compiling this program, you can
understand why.  @sup_magic essentially creates intermediate
relations corresponding to execution points in the body of a rule;
in joinans3, for example, this means that there is a unary relation with
argument X after the first two joins.  Thus, the rest of the rule is
evaluated once per distinct X-value, unlike the other approaches, in
which the rest of the rule is evaluated once per (X,Y,Z)-value.  On
joinans1, however, supplementary magic behaves very like magic due
to an implementation heuristic --- the creation of intermediate 
relations stops when there are no more derived predicates in the 
rule body.  Essentially, the intuition is that it is likely to be 
easier to recompute a join of base predicates than to cache it.  
On this program, with large parent relations, this is a poor 
heuristic.  The program joinans3 indicates how to get around this 
heuristic:  If you want the supplementary optimization, judiciously 
introduce derived predicates that are copies of base relations.  */

%@sup_magic.  	%  The default.
%@sup_magic_indexing.
%@magic.
%@pipelining.
%@no_rewriting.

%@non_ground_facts -.		% This enables the use of intelligent backtracking.
				% In CORAL, IB is implemented in conjunction with
				% rewriting/fixpoint evaluation as well as pipelining.

% joinans1 involves joins on the first column; Quintus Prolog (and LDL)
% automatically index on the first argument.

joinans1 :- parent(X,Y), parent(X,Z), parent(X,W), fail.

% joinans2 involves a join on the first column of parent, but
% introduces an intermediate relation.

joinans2 :- parent1(X,Y), parent1(X,Z), parent1(X,W), fail.

parent1(X,Y) :- parent(X,Y).

% If intelligent backtracking is used, on joinans1 and joinans2 CORAL 
% would detect that the rule could never succeed when it first 
% got to the fail literal, and would not do any further computation; 
% thus it is very fast.  Int. backtracking does not help in joinans3.  
% This program also illustrates the fact that sup_magic can be 
% worse than the other methods.  Since the intermediate relation 
% after the second body literal is now a relation of (X,Y,Z)-values, 
% the only effect of the supplementary rewriting is to cache a 
% lot of intermediate relations.  

joinans3 :- parent1(X,Y), parent1(X,Z), parent1(X,W), fail4(W,X,Y,Z).

% joinans4 joins on the second column, just for some variety.
% Note that the necessary indices are automatically created. Use 
% the list_relations command before and after executing the query 
% ?joinans4 to see what indices are added while evaluating this query.

joinans4 :- parent(Y,X), parent(Z,X), parent(W,X), fail.

end_module.

\end{verbatim}
\end{tt}

