
\begin{tt}
\begin{verbatim}

module declac_eg2.

/*  This program computes transitive closure.  Although existential query 
optimization is not applicable for the query form anc(bf), it is 
applicable for the query form anc1(f).  Look at the module defining 
anc1(f) in file declac2.P.M after consulting this file (declac2.P) 
to see the result of existential query optimization.  

Factoring is applicable for both query forms.  Again, you can see what
effect this has by examining the .P.M file.  (The @factoring annotation
is commented out below; you must include it for factoring to be 
effected.) Using the data sets in declac1a.F and declac1b.F, time the 
query ?anc(1,X) and ?anc1(X) and see the effect of the optimizations.  */

export anc(bf), anc1(f). 

% @factoring+.

anc1(X) :- anc(X,Y).		%  Y can be replaced by _ ("don't care" variable)

anc(X,Y) :- parent(X,Y).
anc(X,Z) :- parent(X,Y), anc(Y,Z).

end_module.

\end{verbatim}
\end{tt}

