
module declad_eg6a.
export mincost(bbf), shortest_path(bbff).

% (This program is discussed in the introduction document.)

/*  This program illustrates the use of aggregation.
The predicate mincost computes the cost of the shortest path between 
two points; shortest_path computes shortest paths between two points.  
Note that this program works even on cyclic graphs as long as there
are no negative cycles.  The reason is that the min operation in the 
aggregate selection retains only the current shortest paths.

The input for this program is an edge relation; sample inputs are
provided in files edge.cyc.F, edge.acyc.F, edge.tree.F, edge.dag.F and
edge.graph.F.  The first two are small sets that can be used to
understand how the algorithm works.  The other files are randomly
generated graphs containing about 100 nodes and 500 edges.  Of course,
the size of the transitive closure for the dag is larger than that for
the tree, and that for the general graph is larger than that for the dag.  */

cost(X,Y,C) :- edge (X,Y,C).
cost(X,Y,C) :- edge(X,Z,C1), cost(Z,Y,C2), C=C1+C2.

@aggregate_selection cost[bbf] (X,Y,C) (X,Y) min(C).

% The grouping in the following rule ensures that mincost contains, 
% for each X,Y pair, the actual least cost of a connecting path (and 
% not just the cost of a currently known least cost path).

mincost(X,Y,min(<C>)) :- cost(X,Y,C).

shortest_path(X,Y,C,[X,Y]) :- mincost(X,Y,C), edge(X,Y,C).
shortest_path(X,Y,C,[X|P]) :- mincost(X,Y,C), edge(X,Z,C1), 
			shortest_path(Z,Y,C2,P), C=C1+C2.

% The following annotation indicates that for a given cost, we only
% want one path between a given pair of points.

@aggregate_selection shortest_path[bbff] (X,Y,C,P) (X,Y,C) any(P).

end_module.

module declad_eg6b.
export spath(bbff).

/*  Illustrates monotonic programs.  Although the 3rd argument value
may not be the least cost between the nodes in the first two arguments
for intermediate spath facts, this is indeed true of all spath facts
when the computation terminates.  (Contrast this with the previous
program.)

Note that this program works even on cyclic graphs as long as there
are no negative cycles.  The reason is that the min operation  in the
aggregate selection retains only the current shortest paths.    */


spath(X,Y,C,[X,Y]) :-  edge(X,Y,C).
spath(X,Y,C,[X|P]) :-  edge(X,Z,C1), spath(Z,Y,C2,P), C=C1+C2.

@aggregate_selection spath(X,Y,C,P) (X,Y) min(C).
@aggregate_selection spath(X,Y,C,P) (X,Y,C) any(P).

% The following annotation ensures that the (current) shortest path is expanded
% at each step.

%@prioritize spath(X,Y,C,P) min(C).

end_module.

