

module declne_eg5.
export working(f).
%@pipelining.	%  works with or without this annotation; 
		%  choice influences speed, and is dependent upon data

%  We can infer that a part is working if it is tested, or if it contains no
%  suspect subpart.  Recursively, a part is defined to be suspect if it
%  contains a subpart that is not known to be working.

working(X) :- tested(X). 
working(X) :- part(X,_), not has_suspect_part(X).
has_suspect_part(X) :- part(X,Y), not working(Y).


end_module.


%  This is a part-subpart hierarchy.

part(a,b).
part(a,c).
part(b,d).
part(b,e).
part(c,f).
part(c,g).

%  These are parts that are known to be ok.

tested(d).
tested(e).
tested(g).
