/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/


/***********************************************************************
	CORAL Software :: U.W.Madison

	pipelined.h : contains definitions for the following classes

      PipelinedExecInfo
	  QFPipelinedModuleData
	  PipelinedDerivedRelation
 ***********************************************************************/

#ifndef CORAL_PIPELINED_H
#define CORAL_PIPELINED_H
#include "interp.h"
#include "apply.h"
#include "derived-rel.h"

class PipelinedExecInfo;

// Backtrack information corresponding to the RuleInfoArray of the
// QFModuleData structure
struct BacktrackInfoArray {
  public :

  int      numRules;
  int   ** firstFailureBacktrackArrays ;   // size of array is numRules
  int   ** nextFailureBacktrackArrays ;   // size of array is numRules
  int   *  successBacktrackPoints ;   // size of array is numRules

  BacktrackInfoArray(RuleInfoArray *, int non_ground);
};

class QFPipelinedModuleData : public QFModuleData {
public :
    // Basically store the kind of information that a Scc stores
    Predicate    **pred_ptrs;  // Array of preds corresponding to the module
    int            numPreds ;  // Number of Preds used in the module
    int          **indices;    // set of indices for each predicate
    int *maxNumVars;           // used for pre-allocation of ArrayBindEnv
    int *maxNumLiterals;       // used for pre-allocation of StackMarks and
                               // tuple-iterators
    int TableSetUp;            // whether Table been set up 

    BacktrackInfoArray backtrackInfo ;

    QFPipelinedModuleData(Table *, RuleInfoArray *, ParserStruct&);
    void clean_cache();
    virtual void Solve(Table *F, TupleIterator *) 
        {this->F = F;} ;
    virtual ModuleKind kindof() { return COR_PIPELINED; } ;
};

class PipelinedExecInfo {
public:
    // The following variables maintain state within a rule
    // Basically all fields used in SemiNaive::evaluate() have to
    // be available to PipelinedExecInfo::Solve()
    int index;
    int current;
    int backtrack_index;

    unsigned int direction : 1;   // direction of current rule evaluation
    unsigned int cut_crossed : 1; // has a cut been crossed in this rule ?

    int successBacktrack;         // backtrack point on success
    int *firstFailureBacktrack;
    int *nextFailureBacktrack;

    RuleInfo *rInfo;
    // int new_iterator;    :: unnecessary
    // int offset;          :: " "

    TupleIterator **tuple_its;
    StackMark stackmark0;
    ArrayBindEnv *env; // BindEnv for the rule currently under consideration
    StackMark *stack_marks;//set of stack marks for the literals on rule rhs
    int *indices; // will point to the indices in the QFPipelinedModuleData

    Tuple **tuples; // set of tuples from literals on rhs of rule
    // and this tells us which rule we were at when we returned

    Clause *curRule;// points to the rule that is currently being examined
    Table *F; // points to the Table in QFPipelinedModuleData
    //PipelinedExecInfo(QFPipelinedModuleData *md,Name name, int arity);
    PipelinedExecInfo(QFPipelinedModuleData *md, int pred_offset);
    ~PipelinedExecInfo();
    int Solve();
    int NextRule(QFPipelinedModuleData *md);
};

class PipelinedDerivedRelation : public DerivedRelation {
public:
    QFPipelinedModuleData *md;
    int   pred_offset;     // offset of this relation
                           // in the pred_ptrs array of the module
    PipelinedDerivedRelation(QFPipelinedModuleData *module,Name name, 
			       int arity);
    virtual BindEnv *get_next(TupleIterator&);
    virtual Tuple  *get_next_tuple(TupleIterator& it) ;
    virtual void release (TupleIterator& it);
    virtual void print_name(FILE *file);	
};

/* function called in interp.C to interpret a QFPipelinedModuleData */
extern void interpretPipelined(QFPipelinedModuleData *, ExportInfo *,
                               ParserStruct&);

#endif

