/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	interface.h : Header file

	Declarations of routines for interfacing CORAL with C++

	Contains the following class/type  declarations	 :

 ***********************************************************************/

#ifndef CORAL_INTERFACE_H
#define CORAL_INTERFACE_H

#include "arg.h"
#include "gennum.h"
#include "term.h"
#include "generic-rel.h"
#include "builtin-syms.h"
#include "hash-rel.h"
#include <stdarg.h>
#include "builtin-rel.h"

extern class ParserStruct;


/*
 * These structures are used in the C++ code created by the
 * CORAL/C++ translator
 */
typedef enum {
  COR_NULL,
  COR_INT,
  COR_SHORT,
  COR_LONG,
  COR_FLOAT,
  COR_DOUB,
  COR_STR,
} parameter_kind;

// represents an arg and the corresponding parameter.
class ParameterStruct {
 public:
  parameter_kind  kind;
  void *value_ptr;
  ParameterStruct() { kind = COR_NULL; value_ptr = NULL;}
};

class ExecutionList {
 public:
  ParserStruct **exec_terms;
  ParameterStruct *parameters;
  int no_of_params;

  int max_no_of_terms;
  int actual_no_of_terms;
  int step_size;
  int initialized;

  void add(ParserStruct *pstruct) ;

  void initialize(int i, int num_params, ParameterStruct *params) {
    exec_terms = new ParserStruct*[i];
    parameters = params;
    no_of_params = num_params;
    max_no_of_terms = i;
    step_size = i;
    actual_no_of_terms = 0;
    initialized = 1;
  }
  int execute();
  int execute(int index, int& param_index);
};


/* 
 * These structures are used to provide C++ users with the facility
 * of scans over CORAL relations
 */
class C_ScanDesc {
  TupleIterator *it;
  ArrayBindEnv *env;
  ArgList *arg_list;
  StackMark *stackmark;
  int tuple_fetched;

  public :

  C_ScanDesc(Relation *rel);
  C_ScanDesc(Relation *rel, Tuple *match_tuple);
  ~C_ScanDesc();
  Tuple *next_tuple();
  int no_match() { return it->no_match();}
};

/* These extern function declarations are used by the translated C++
 * program, with the embedded CORAL code removed
 */

extern char * strip_quotes(char *);
extern "C" int yyparse();
extern int consultFile(char *, char *);
extern void processInputStack();
extern void copy_structs(ParserStruct*, ParserStruct&);
extern int c_module_separator;
extern int in_query_loop;


/* The following functions are defined in interface.C */

/* -------------------------------------------------------------------- */
/* Interface functions for creating arguments of tuples:		*/

extern Arg *make_arg (int i);
extern Arg *make_arg (long l);
extern Arg *make_arg (short s);
extern Arg *make_arg (float f);
extern Arg *make_arg (double n);
extern Arg *make_arg (char *name);
extern Arg *make_arg (Name name);

extern Arg *make_var (int var_num);
extern Arg *make_var (char *print_name, int var_num);
extern Arg *make_var (Name print_name, int var_num);

extern Arg *make_arg (char *func_name, ArgList *args);
extern Arg *make_cons (Arg *a, Arg *b);
extern Arg *make_nil ();

extern ArgList *make_arglist (int len ...);
extern ArgList *make_arglist1 (Arg* a1);
extern ArgList *make_arglist2 (Arg* a1, Arg *a2);
extern ArgList *make_arglist3 (Arg* a1, Arg *a2, Arg *a3);
extern ArgList *make_arglist4 (Arg* a1, Arg *a2, Arg *a3, Arg *a4);
extern ArgList *concat_arglists (ArgList *al1, ArgList *al2);
extern ArgList *make_vararglist (int n);

/** the constructor Tuple::Tuple (ArgList *alist) is in 
	term.[hC] **/

/* -------------------------------------------------------------------- */
/* Interface functions for testing and getting C++ data structures from 
		CORAL data: 						*/

/** int Tuple::arity ();   and 
    Arg *Tuple::arg (int arg_pos);   are in term.[hC]  **/

/** int ArgList::arity ();  and 
    Arg *ArgList::arg (int arg_pos);  are in arg.[hC]  **/


extern int is_int (Arg *a);
extern int is_long(Arg *a);
extern int is_short(Arg *a);
extern int is_float (Arg *a);
extern int is_double (Arg *a);
extern int is_string (Arg *a);
extern int is_num (Arg *a);
extern int is_constant (Arg *a);
extern int is_var (Arg *a);
extern int is_functor (Arg *a);
extern int is_list (Arg *a);

extern int make_int (Arg *a);
extern short make_short(Arg *a);
extern long make_long (Arg *a);
extern float make_float (Arg *a);
extern double make_double (Arg *a);
extern char *make_string (Arg *a);

extern char *functor_name (Arg *a);
extern ArgList *functor_args (Arg *a);
extern Arg *make_car (Arg *a);
extern Arg *make_cdr (Arg *a);

/* -------------------------------------------------------------------- */
/* Interface functions for creating relations:				*/

typedef LinkedRelation UnindexedRelation;
typedef HashSimpleRelation IndexedRelation;

/** the constructors for LinkedRelation and HashSimpleRelation are there
	in linked-rel.[Ch] and hash-index.[Ch]  **/

/* -------------------------------------------------------------------- */
/* Interface functions for finding a database relation:			*/

extern Relation *find_relation (char *db_rel_name, int arity);

/* -------------------------------------------------------------------- */
/* Interface functions for calling the declarative module:		*/

extern int call_coral(char *exp_pred_name, Tuple *query,
		      Relation *&result);
	//
	// The query is a tuple for the relation, and any
	//	facts in the relation that unify with the query tuple are 
	//	answers to the query.
	// For example, (X,Y) is a query that returns all tuples in a binary
	//	relation.
	// Similarly, (1,Y) returns all tuples that have 1 in the first 
	//	column.
	// Adds answer tuples to the relation result
        // If the result parameter is NULL, a new relation is
        // allocated and result points to it.
	// Returns:  Number of answer tuples.  Result < 0 implies error.

extern int call_coral(char *exp_pred_name, Relation *queries,
		      Relation *&result);
	//
	// Relation *queries must contain queries on the relation.
	// Adds answer tuples to the relation result.
        // If the result parameter is NULL, a new relation is
        // allocated and result points to it.
	// Returns:  Number of answer tuples.  Result < 0 implies error.

/* -------------------------------------------------------------------- */
/* Interface functions for stepping through and modifying a relation:	*/

/** FOR_EACH_TUPLE(Tuple *tuple, Relation *rel) **/
#define FOR_EACH_TUPLE(tuple,rel) {\
    StackMark CONCAT_ID2(tuple,_stack_mark);\
	ArrayBindEnv *CONCAT_ID2(tuple,_env) = \
		new ArrayBindEnv((rel)->arity()); \
	ArgList *alist0 = make_vararglist((rel)->arity()); \
	TupleIterator CONCAT_ID2(ITER,tuple) (rel, *alist0, \
		CONCAT_ID2(tuple,_env)); \
	for(;;) {	\
	    * ((Tuple **) &tuple) = CONCAT_ID2(ITER,tuple).get_next_tuple(); \
	    if (CONCAT_ID2(ITER,tuple).no_match()) break;	

#define END_EACH_TUPLE(tuple)  } \
    CONCAT_ID2(tuple,_stack_mark).pop_to();\
    delete CONCAT_ID2(tuple,_env); }

/** FOR_EACH_MATCHING_TUPLE(Tuple *tuple, Relation *rel, Tuple *match_tuple) **/
#define FOR_EACH_MATCHING_TUPLE(tuple,rel,match_tuple) {\
    StackMark CONCAT_ID2(tuple,_stack_mark);\
	ArrayBindEnv *CONCAT_ID2(tuple,_env) = \
		new ArrayBindEnv((rel)->arity()); \
	TupleIterator CONCAT_ID2(ITER,tuple) \
		(rel, (match_tuple)->args(), CONCAT_ID2(tuple,_env)); \
	for(;;) {       \
	    * ((Tuple **) & tuple) = CONCAT_ID2(ITER,tuple).get_next_tuple(); \
	    if (CONCAT_ID2(ITER,tuple).no_match()) break;       

extern Tuple *make_tuple(int arity);
extern Tuple *make_tuple(ArgList *arglist);

extern void update_tuple (Tuple *tuple, int arg_pos, Arg *new_val);
extern void update_tuple (Relation *rel, Tuple *old_tuple, Tuple *new_tuple);
extern void delete_id_tuple (Relation *rel, Tuple *tuple);
extern void delete_tuple (Relation *rel, Tuple *tuple);


extern Relation *make_rel(char *rel_name, int arity);

/** void Relation::insert_tuple (Tuple *tuple)   is in
	generic-rel.[hC]  hash-index.[hC]  linked-rel.[hC]  **/


/* -------------------------------------------------------------------- */
/* Interface functions for printing :					*/

/** Arg::printon(File *file);  and 
    ArgList::printon(File *file);   are in arg.[hC]

    Tuple::printon(File *file);   is in term.[hC]
    Relation::printon(File *file);  is in generic-rel.[hC]

**/

/* -------------------------------------------------------------------- */
/* Interface functions for creating indices for relations:		*/

/* -------------------------------------------------------------------- */
/* Interface functions for calling the imperative module: 		*/

/** The user needs to write a routine with signature
	Relation *pred_solver (Tuple *query);    or
	Tuple *pred_solver (Tuple *query);
    for the predicate `pred', and add a declaration matching the form:
	int add_builtin (char *pred, int arity, UserRelProc pred_solver);  or
	int add_builtin (char *pred, int arity, UserTupleProc pred_solver);
    
    where `arity' is the arity of the relation named by `pred'.
**/

extern int add_builtin (char *pred, int arity, UserRelProc pred_solver);
extern int add_builtin (char *pred, int arity, UserTupleProc pred_solver);
#define BUILTIN_FAIL_RETURN {__CORAL_BUILTIN_FAIL=1;return 0;}
#define VOID_BUILTIN_FAIL_RETURN {__CORAL_BUILTIN_FAIL=1;return;}
				/* must match the definition in hashdefines.h */
#endif /* !CORAL_INTERFACE_H */
