/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	hash.h : Header file

	Copyright Per Bothner 1987. Implements a hash table.

 ***********************************************************************/

#ifndef CORAL_HASH_H
#define CORAL_HASH_H
#include "arg.h"

#define FailedSearch(arg) (arg == 0 || arg == NoValue || False(arg))
#define SymbInTab(s) (_RefCount(s) == RefsInfinity)

extern int StrHash(const char *str, int len);

struct Association {
    ConstPointer arg;
    Pointer val;     // Maybe be missing in ObArray tables for Symbols.
};

struct SymbolTable
{
    unsigned char element_len;
    unsigned char element_len_log;
    unsigned char tab_len_log;
    unsigned char flags;
    struct HashFuncs *f;
    int cur_size;
    int cur_deleted;
    Association *data;
};

typedef struct SymbolTable HashTable;

#define HASH_WORD_LEN 16

#define DoForEachInTab(tab, action)			\
  { register struct SymbolTable *__tab__ = tab;		\
    register Association *__element__ = __tab__->data;	\
    register __i__ = 1<<__tab__->tab_len_log;		\
    for (; __i__ > 0; __i__--,				\
       __element__ = (Association*)((char*)__element__+__tab__->element_len))\
        if (!HashNone(__element__->arg))			\
	  { action(__element__->arg, __element__->val); } }


#define NULLARG (ConstPointer)HashNull

/* flags bits */
#define HashSymbolsOnly 1
#define HashDefaultIsProc 2 /* get default as Apply(arg, default) */
/* *** NOTE when deleting, symbol should remain for faster searching !!! */

typedef Association *(*LookupFunc)(HashTable *, ConstPointer);

struct HashFuncs {
    void *defaultVal;
    LookupFunc lookup;
};

extern struct HashFuncs StdHashFuncs;
extern struct SymbolTable SymbolTab[1];

#define HashNull NULL
#define HashDeleted ((ConstPointer)1)
#define HashNone(x) ((unsigned)(x) <= 1) /*i.e.either HashNull/HashDeleted */

EXTERN Association * SymbolLookup ARGS((HashTable *, ConstPointer));
EXTERN void RehashBigger(register struct SymbolTable *tab);
EXTERN struct SymbolTable* AllocTab ARGS((int init_size, Pointer default_val));
EXTERN void TabInserted ARGS((struct SymbolTable*, Association*));
EXTERN void Insert(HashTable *tab, ConstPointer arg, Pointer val);

#endif /* !CORAL_HASH_H */
