/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	hash-rel.h : Header file

	Declarations that define a hash relation, which is
	a relation implemented as a hash table.
	
	Contains the following class/type  declarations	 :
	  HashRMark
	  HashSimpleRelation

 ***********************************************************************/

#ifndef CORAL_HASH_REL_H
#define CORAL_HASH_REL_H

#include "linked-rel.h"
#include "hash-index.h"

class RelationLink;

class HashRMark : public LinkedRMark {
public:
    HashRMark *prev;
    HashRMark *next;
    RelationLink *rel_p; /* new for purposes of delta_indexing */ 

		/*
		 * Given a startmark and an endmark, we consider each relation
		 * in Relation.delta_relations (which is a RelationList)
		 * starting from (and including) that associated with 
		 * startmark.rel_p, up to (but not including) that associated
		 * with endmark.rel_p
		 */

    HashRMark();
    HashRMark(TupleLink **);
    HashRMark(RelationLink *);
    void init(TupleLink **);
    void init(RelationLink *);

};

/*
 * Tuples which are newer than the oldest RMark are
 * in the "chain" list inherited from LinkedRelation.
 * The others are accessed through the Hash Indexes.
 */

extern class Context;
extern class HeapNode;

class HashSimpleRelation : public LinkedRelation {

public:
    HashRMark headMark;
    HashRMark *free_marks;  // List of free rmarks. Used to reduce calls to new
    
    int there_are_marks();
    void initialize_iterator( TupleIterator& );

    // this inserts a tuple into the hash indices.
    void insert_in_index(Tuple *);

    HashIndexSet index_set; 
    HeapNode *heap;       // For prioritize annotation

    HashSimpleRelation( int arity, int delta = -1, 
		       int buckets = -1);

    virtual void freeMark(RMark *, int hide_em=0);
    virtual void free_allMarks();
    virtual RMark * getMark();


     /******* Indexing related methods *********/
    virtual int add_index(char *s, int buckets = -1);
    virtual int add_index(BitVector *s, int buckets = -1);
    virtual int add_index(ArgList *args, int buckets = -1);

    virtual int add_index(ArgList *pat, int n_var, ArgList *v_nm, 
			int buckets = -1);
    virtual int add_all_indices(Relation *reln, 
			int buckets = -1);
    virtual int add_all_tuples(Relation *reln, int marks_into_account = 0,
			       int check_dupl = 0, int hide_em = 0);
    virtual int add_all_goals (Relation *reln, Context *context,
						Relation *owner_rel);

    virtual int set_delta_indexing(int delta);


     /******* Some priority related methods ********/
     virtual int add_hidden_relation(PrioritizeInfo *info);
                         // The above adds a new hidden relation
     virtual int insert_in_hidden_relation(Tuple *tuple);
     virtual int pop_from_hidden_relation();
                         // Pop a tuple from the hidden relation and add it
                         //    to visible part.
     virtual int pop_all_from_hidden_relation();
                         // Pop all tuples from the hidden relation, and
                         // add them to visible part.


     /******* Insert related methods *********/

    virtual int insert_tuple(Tuple *tuple);
    inline virtual int insert_raw( Tuple *tuple ) {
	insert_in_index(tuple);
	return COR_I_SUCCESS;
    }
    int insert_in_heap(Tuple *tuple);

    virtual Tuple *get_next_tuple( TupleIterator& it) ;
    virtual void release(TupleIterator& it) ;
    virtual BindEnv *get_next( TupleIterator& );
    virtual int is_subsumed(Tuple *tuple, RMark *startmark = NULL,
					RMark *endmark = NULL);

    virtual void free_all();
    virtual void free_indices();
    virtual void free_delta_relations();
    int move_all_entries(Relation *rel); 	
			// Move all tuples/index entries into rel.  
			// Assumes that rel has the same set of indices, 
			// and all corresponding indices and relations are
			// of exactly the same type.

    virtual void empty_relation(int deleteTuples=0);
    virtual void print_name(FILE *outf);

    virtual ~HashSimpleRelation();
};


class HeapNode {
 public:
  
  Tuple *tuple;
  NumArg *val;
  HeapNode *left;
  HeapNode *right;
  int weight;
  
  HeapNode(Tuple *tuple1, NumArg *val1);
};

typedef HeapNode * HeapNodePtr;


#endif /* !CORAL_HASH_REL_H */
