/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	generic-index.h : Header file

	This file contains declarations of generic index types modified
	to include patterns. 

	Contains the following class/type  declarations	 :
	  GenericIndex
	  GenericIndexSet
 ***********************************************************************/

#ifndef CORAL_GENERIC_INDEX_H
#define CORAL_GENERIC_INDEX_H


#include "term.h"
#include "generic-rel.h"
#include "bitvector.h"

#define COR_I_FAIL 0	/* failure for indices */
#define COR_I_SUCCESS 1	/* success for indices */

class GenericIndex;
typedef GenericIndex *GenericIndexPtr ;
typedef enum { COR_HASH_INDEX } IndexType;

class GenericIndex {
  friend class GenericIndexSet;

  protected :
    Relation *relation; // relation that is being indexed

    // for argument form indexing only next field is relevant
    BitVector *argset; 

    // for pattern form indexing only next three fields are relevant
    ArgList *pattern;   // pattern to be used for indexing
    int num_vars_pat;   // number of variables in pattern
    ArgList *var_names; // subset of variables in pattern
                        // that are used for indexing
    

  public: 

    GenericIndex( Relation* rel, BitVector* aset );

    GenericIndex( Relation *rel, ArgList *pat, int n_var, ArgList *v_nm );
    /*
     *  this assumes that ArgList *pat and ArgList *v_nm
     *  have been created with the same variable numbers assigned 
     *  to the same variable names, and that the variable numbers are
     *  sequentially assigned from 0, with no number being skipped 
     *  in between.
     */

    int add_index_to_reln(Relation *reln, int buckets);

    virtual void initialize_iterator( TupleIterator& ) = 0;

    inline int is_argument_form() 
	{ return (argset != NULL); }

    virtual Tuple *get_next_tuple(TupleIterator& ) = 0;
    virtual BindEnv *get_next( TupleIterator& ) = 0;
    int matches(GenericIndex *ind);
    virtual int index_type() = 0;
    virtual int is_subsumed(Tuple *tuple)=0;
	
    virtual void insert_tuple( Tuple *tuple )  = 0;
    virtual void delete_all_tuples();
    virtual void free_all_entries() = 0;
    virtual void move_all_entries(GenericIndex *ind) = 0;
    virtual void reset_index(int buckets) = 0;
		// Empty the index, but do NOT delete tuples (these are shared)
		// Retain the index, for reuse, and reset its size
};


//GArrayDeclare(GenericIndexPtr) ;
// .... Add a GArrayImplement(GenericIndexPtr) somewhere.

extern class Context;

class GenericIndexSet {

protected:
    Relation *rel;
    int num_in_array;
    int max_in_array;
    GenericIndexPtr *Indices;
	
public:
    GenericIndexSet( Relation *reln );

    int add_all_indices(Relation *reln, int buckets = -1);
	/* transfers its indices to reln. */
    virtual int add_all_tuples(Relation *reln, int marks_into_account = 0,
			       int check_dupl = 0, int hide_em = 0);
    virtual int add_all_goals (Relation *_reln, Context *_context,
					Relation *owner_rel);

    int num_indices();
    virtual GenericIndex *find_index( TupleIterator& ) = 0;
	/* This fn. finds the index that best "matches" the given 
	   argument set in the iterator. */ 
    virtual GenericIndex *find_index( Tuple*, int *tryindexp= NULL ) = 0;
    virtual GenericIndex *find_index( ArgList&, BindEnv*, int *tryindexp=NULL) 
								= 0;

    inline GenericIndexPtr& operator[](int i) {return Indices[i];}
    virtual int insert_index( GenericIndex* Index ) = 0;
	/* This fn. adds an index to the set of known indices. */
    virtual void fill_index(GenericIndex* Index) = 0;
	/* This fn. fills in the index using default index in posn. 0 */
    virtual void print_adornments(FILE *outf);
};

/**********************
*  add
*	Relation::add_index(ArgList *pat, int n_var, ArgList *v_nm)
**********************/

#endif /* !CORAL_GENERIC_INDEX_H */
