/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/* This module implements garbage collected storage for C++ programs using
   a generational version of the "mostly-copying" garbage collection algorithm.
   The implementation is compatible with AT&T C++ Language System Release 2.0.

   To compile this version for earlier releases of C++ where one could not
   overload new, compile with the flag -DGC1xx or #define GC1xx to some
   value.
*/

/*
 *              Copyright 1990 Digital Equipment Corporation
 *                         All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation is
 * hereby granted only under the following terms and conditions.  Both the
 * above copyright notice and this permission notice must appear in all copies
 * of the software, derivative works or modified versions, and any portions
 * thereof, and both notices must appear in supporting documentation.
 *
 * Users of this software agree to the terms and conditions set forth herein,
 * and hereby grant back to Digital a non-exclusive, unrestricted, royalty-free
 * right and license under any changes, enhancements or extensions made to the
 * core functions of the software, including but not limited to those affording
 * compatibility with other hardware or software environments, but excluding
 * applications which incorporate this software.  Users further agree to use
 * their best efforts to return to Digital any such changes, enhancements or
 * extensions that they make and inform Digital of noteworthy uses of this
 * software.  Correspondence should be provided to Digital at:
 * 
 *                       Director of Licensing
 *                       Western Research Laboratory
 *                       Digital Equipment Corporation
 *                       100 Hamilton Avenue
 *                       Palo Alto, California  94301  
 * 
 * This software may be distributed (but not offered for sale or transferred
 * for compensation) to third parties, provided such third parties agree to
 * abide by the terms and conditions of this notice.  
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */


#ifndef GCALLOCH
#define GCALLOCH 1

/* Defining garbage collected classes
   ----------------------------------
   Classes allocated in the garbage collected heap are denoted by the GCCLASS
   statement in their declaration.  For example, a class that holds a fixed
   length string, a reference count, and pointers to strings that are greater
   or lesser than it can be defined as follows:

	struct  word  {
		word* lesser;
		word* greater;
		int  count;
		char  symbol[ 12 ];
		word( char* chars );
		GCCLASS( word );
	};

	word::word( char* chars )
	{
		lesser = NULL;
		greater = NULL;
		count = 1;
		strcpy( symbol, chars );
	}

	void  word::GCPointers( )  {
		gcpointer( lesser );
		gcpointer( greater );
	}

   The declaration GCCLASS informs the garbage collector that the type word
   is garbage collected.  Besides overloading new and delete for this type of
   object, it declares the user defined "pointer locator" method.

   The "pointer locator" method, word::GCPointers, is used by the garbage
   collector to identify all pointers in the object.  This is done by
   having the method call gcpointer with each pointer in the object that could
   point to a garbage collected object.  In order to correctly invoke pointer
   location methods for superclasses or class objects contained in the class,
   the following rules must be followed:

	1) for class C:P {}, C::GCPointers must contain P::GCPointers()
	2) for class C { X x; }, C::GCPointers must contain x.GCPointers()
        3) for class C { X* x; }, C::GCPointers must contain gcpointer( x )

   Once the object has been defined, storage is allocated using the normal
   C++ mechanism:

	sp = new word( "dictionary" );

   Using the garbage collector with CC versions 1.x
   ------------------------------------------------

   Some additional information must be supplied when the garbage collector
   is used with earlier versions of C++.  Class constructors must be written
   as:

	word::word( char* chars )
	{
		GCALLOC( word );
		lesser = NULL;
		greater = NULL;
		count = 1;
		strcpy( symbol, chars );
	}

   where storage allocation is done by the call to GCALLOC (which takes the
   type name as its argument) at the start.

   Sometimes a class will be a subclass of a garbage collected object, yet
   add no pointers to the class.  In this case, it need not specify GCCLASS
   in the class declaration, but it must include a constructor method that
   allocates garbage collected storage.  Often this method can be expressed
   as:

	subclass::subclass { GCALLOC( subclasss ); }

   If the subclass does not provide this constructor, then instances of the
   subclass will be allocated from the non-garbage collected heap.  The base
   class may assure that this never happens by including the following test
   in its constructor method:

	if  (gcobject( this ) == 0)  abort();

   None of these conventions need be changed to compile with 2.0 and later
   compilers.

   An earlier version of this garbage collector required the user to differ
   between pointers to the start of objects and pointers into objects.  This
   is no longer required and gcderivedpointer is now a synonym for gcpointer.

   Caveats
   -------
   When the garbage collector is invoked, it searches the processor's
   registers, the stack, and the program's static area for "hints" as to what
   storage is still accessible.  These hints are used to identify objects that
   are the "roots" and are to be left in place.  Objects that the roots point
   to will be moved to compact the heap.  Because of this:

   Objects allocated in the garbage collected heap MAY MOVE.

   Pointers to garbage collected objects MAY BE passed as arguments or stored
   in static storage.

   Pointers to garbage collected objects MAY NOT be stored in dynamically 
   allocated objects that are not garbage collected, UNLESS one has specified
   the GCHEAPROOTS flag in a gcheap declaration, OR declared that region as
   a root via a call to gcroots.

   Pointers to garbage collected objects contained in garbage collected objects
   MUST always point outside the garbage collected heap or to a garbage
   collected object.

   Garbage collected arrays are not supported as arrays are always allocated by
   the global ::operator new() (section 5.3.3, AT&T C++ Language System Release
   2.0).

   Variable size objects
   ---------------------

   Garbage collected objects who's size is computed at runtime have their
   storage allocated by having the class' constructor method have a call to
   GCALLOV as its first statement.  GCALLOV takes two arguments, the name of
   the class and the number of bytes needed.  For example, a variable size
   word might use the constructor:

	word::word( char* chars )
	{
		GCALLOCV( word, <SOME FIXED SIZE>+strlen( chars ) );
		lesser = NULL;
		greater = NULL;
		count = 1;
		strcpy( symbol, chars );
	}

   N.B.  As GCALLOCV relies on the "assignment to this" anachronism, it is
   subject to change in future releases of the compiler.

   Sizing the heap
   ---------------
   In order to make heap allocated storage as painless as possible, the user
   does not have to do anything to configure the heap.  This default is an
   initial heap of 1 megabyte that is expanded in 1 megabyte increments
   whenever the heap is more than 25% full after a total garbage collection.
   Total garbage collections are done when the heap is more than 35% full.

   However, if this is not the desired behavior, then it is possible to "tune"
   the collector by including one or more global gcheap declarations in the
   program.  In order to understand the parameters supplied in a gcheap
   declaration, one needs an overview of the storage allocation and garbage
   collection algorithm.

   Storage is allocated from the heap until 50% of the heap has been allocated.
   All accessible objects allocated since the last collection are retained and
   made a part of the stable set.  If less than <collect all percent> of the
   heap is allocated, then the collection process is finished.  Otherwise, the
   entire heap (including the stable set) is garbage collected.  If the amount
   allocated following the total collection is greater than <increment heap
   percent>, then an attempt is made to expand the heap.

	gcheap  <CC-identifier>( <initial heap size>,
			         <maximum heap size>,
			         <increment size>,
			         <collect all percent>,
			         <increment heap percent>,
			         <heap log> )

   The arguments are defined as follows:

	<CC-identifier>		 a legal C++ identifier.
	<initial heap size>	 initial size of the heap in bytes.
				 DEFAULT: 1048576.
	<maximum heap size>	 maximum heap size in bytes.
				 DEFAULT: 2147483647.
	<increment size>	 # of bytes to add to each heap on each
				 expansion.  DEFAULT: 1048576.
	<collect all percent>	 number between 0 and 50 that is the percent
				 allocated after a partial collection that will
				 force a total collection.  A value of 0 will
				 disable generational collection.  DEFAULT: 35.
	<increment heap percent> number between 0 and 50 that is the percent
				 allocated after a total collection that will
				 force heap expansion.  DEFAULT: 25.
	<flags>			 controls logging on stderr, error checking,
				 and root finding:
				   & GCSTATS =  log collection statistics
				   & GCMEM =  log memory usage statistics
				   & GCROOTLOG = log roots found in the stack,
						 registers, and static area
				   & GCHEAPROOTS = treat non-GC heap as roots
				   & GCHEAPLOG = log possible roots in non-GC
						 heap
				   & GCTSTOBJ = perform object consistency
					        tests
				   & GCGUESSPTRS = guess number of pointers in
						   objects
				   & GCZERO = zero free memory after GC
			 	   & GCDEBUGLOG = log events internal to the
						  garbage collector
			           & GCHEAPMAP = maintain memory allocation
					         map
				 DEFAULT: 0.

   When multiple gcheap declarations occur, the one that specifies the largest
   <maximum heap size> value will control all factors except flags which is
   the inclusive-or of all <flags> values.

   Configured values may be overridden by values supplied from environment
   variables.  The user must set these variables in a consistent manner.  The
   variables and the values they set are:

	GCMINBYTES	<initial heap size>
	GCMAXBYTES	<maximum heap size>
	GCINCBYTES	<increment size>
	GCALLPERCENT	<collect all percent>
	GCINCPERCENT	<increment heap percent>
	GCFLAGS		<flags>

   If any of these variables are supplied, then the actual values used to
   configure the garbage collector are logged on stderr.

   Limits
   ------
   No more than 2046 user defined garbage collected classes.
   Individual objects no larger than 4,193,788 bytes.
*/

       /*******************************************************
 	* C++ Garbage Collected Storage Interface Definitions *
 	*******************************************************/

/* Declarations for objects not directly used by the user of the interface. */

typedef int  *GCP;		/* Pointer to a garbage collected object. */

extern  GCP gcmove( GCP ptr );	/* Objects are moved by this function. */

extern void  gccollect();	/* Invokes the collector. */

typedef void (*GCCALLBACKPROC)( GCP );
				/* Callback procedure type */

extern int  gcregistercallback( GCCALLBACKPROC pointers, char* type );
				/* Registers a callback method */

/* The following define is used to compute the number of words needed for
   an object.  The count includes 1 word for the header.  The defines are
   used inside GCCLASS and GCALLOCV.
*/

#define	GCBYTEStoWORDS( x ) (((x)+7)>>2)	/* Word align */

extern  GCP gcalloc( int words, int callback ); /* Actual space allocator */

/* User defined objects use the following definition to define the class
   as garbage collected.  It defines the pointer method, a static variable
   to hold the index into the garbage collector's table of methods, and storage
   allocation methods.
*/

#ifdef  GC1xx

#define GCCLASS( type )							      \
	void  GCPointers();						      \
	static int  __GCPointers;					      \
	char*  __GCType() { return "type"; }

#define GCALLOC( type )                                                       \
   this = ((this==0) ?                                                        \
           (((__GCPointers==0) ?                                              \
             __GCPointers=                                                    \
                    gcregistercallback( (GCCALLBACKPROC)&type::GCPointers,    \
                                        type::__GCType() ) :                  \
             0),                                                              \
            (type*)gcalloc( GCBYTEStoWORDS( sizeof(type) ), __GCPointers )) : \
           this )

#else

#define GCCLASS( type )							      \
	void* operator new( unsigned int bytes )  {			      \
	   if  (__GCPointers == 0)					      \
	      __GCPointers = 						      \
		    gcregistercallback( (GCCALLBACKPROC)&type::GCPointers,    \
					#type );		   	      \
	   return (void*)gcalloc( GCBYTEStoWORDS( bytes ), __GCPointers );    \
	}								      \
	void operator delete( void* ) {}				      \
	void  GCPointers();       			     		      \
	static int  __GCPointers

#define GCALLOC( type )

#endif

/* GCPointer methods move pointers by calling the procedure gcpointer.  It is
   actually a define enclosing an inline procedure as C++ 2.0 does not
   correctly compile void*& arguments.
*/

#define  gcpointer( x ) _gcpointer( &x )

inline void  _gcpointer( void* ptr ){ *((GCP*)ptr) = gcmove( *((GCP*)ptr) ); }

#define  gcderivedpointer( x )  gcpointer( x )

/* Storage for variable size objects is allocated by the following mechanism
   that depends upon ASSIGNMENT TO THIS, i.e. this feature might not work in
   the future.
*/

#ifdef  GC1xx

#define GCALLOCV( type, bytes )                                               \
   this = ((this==0) ?                                                        \
           (((__GCPointers==0) ?                                              \
             __GCPointers=                                                    \
                    gcregistercallback( (GCCALLBACKPROC)&type::GCPointers,    \
                                        type::__GCType() ) :                  \
             0),                                                              \
            (type*)gcalloc( GCBYTEStoWORDS( bytes ), __GCPointers )) :        \
           this )

#else

#define GCALLOCV( type, bytes ) 					      \
   this = ((this==0) ? 							      \
	   (((__GCPointers==0) ? 					      \
	     __GCPointers= 						      \
		    gcregistercallback( (GCCALLBACKPROC)&type::GCPointers,    \
					#type ) :    			      \
	     0),							      \
	    (type*)gcalloc( GCBYTEStoWORDS( bytes ), __GCPointers )) :        \
	   this )

#endif

/* The following predicate returns 1 if the object is allocated where it will
   be scanned by the garbage collector, otherwise it returns 0.
*/

extern int  gcobject( void* ptr );
 
/* The class gcheap is used to configure the heap as earlier described.  */

class  gcheap {
   public:
	gcheap( int minheapbytes,
		int maxheapbytes,
		int incheapbytes,
		int allpercent,
		int incpercent,
		int flags );
};

const	GCSTATS = 1,		/* Log garbage collector info */
	GCMEM = 2,		/* Log memory usage information */
	GCROOTLOG = 4,		/* Log roots found in registers, stack and
				   static area */
	GCHEAPROOTS = 8,	/* Treat non-GC heap as roots */
	GCHEAPLOG = 16,		/* Log possible non-GC heap roots */
	GCTSTOBJ = 32,		/* Extensively test objects */
	GCGUESSPTRS = 64,	/* Guess pointers in objects */
	GCZERO = 128,		/* Zero free memory after GC */
	GCDEBUGLOG = 256,	/* Log events internal to collector */
	GCHEAPMAP = 512;	/* X-window display showing allocation */

/* Additional roots may be registered with the garbage collector by calling
   the procedure gcroots with a pointer to the area and the size of the area.
*/

extern void  gcroots( void* area, int bytes );

#endif
