/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	arg.h : Header file

	Declarations for arguments of different types. Declarations
	for numeric args are found in gennum.h

	Adding new subclasses of Arg:
 	  if you add a new subclass of Arg, and it is a constant (eg. integer,
	  string etc), make it a subclass of ConstArg!.

	Contains the following class/type  declarations	 :
	  HashVal
	  ArgList
	  Arg (and ConstArg, VarArg, FunctArg, NumArg, Symbol, DontCareArg,
	       Grouping)
	  VarLink
	  TermLink
	  arg_kind
	  numarg_kind
	  
 ***********************************************************************/

#ifndef CORAL_ARG_H
#define CORAL_ARG_H

#include "config.h"
#include <stdio.h>

// check if Garbage Collection is turned on
#ifdef DO_GC
#include "gcalloc.h"
#define RAW_GCCLASS(type) \
	void operator delete( void* ) {}		\
	void  GCPointers();       			\
	static int  __GCPointers
#endif

#define FOR_EACH_ARG(ARG, ARGLIST)	\
  { register Arg **__a__ = (ARGLIST).first();	\
    register int __i__ = (ARGLIST).count();	\
    register Arg *ARG;			  	\
    for ( ; --__i__ >= 0; __a__++) { ARG = *__a__;
#define END_EACH_ARG }}

#define KEYWORD_ASM(name) asm("_KEY$" name)
#define SYM2(x,s) extern struct Symbol x KEYWORD_ASM(#s);
#define DCL_KEYWORD(x,s) extern struct Symbol x KEYWORD_ASM(#s);
/* #define DCL_KEYWORD3(x,s,len) extern Symbol *x = InsertSymbol(s,len);
		   But CFront doesn't allow init. of externs */
#define DCL_KEYWORD2(x,s) extern Symbol *x;

#define SymbolLength(s) (((Symbol*)(s))->_length)
#define SymbolHash(s) (((Symbol*)(s))->_hash)
#define SymbolString(s) (((char*)((Symbol*)(s)))+sizeof(Symbol))
#define SymbolUnsignedString(s) ((unsigned char*)SymbolString(s))

#define S_NoMatch -1

struct VarArg; struct Numeric; class BindEnv;
struct VarLink;
struct NumArg ; struct DontCareArg;
class Tuple;
typedef struct ArgList ArgList;
typedef struct Arg Arg, *ArgPtr;
typedef struct Symbol Symbol;
typedef Symbol *Name;
typedef int Variable;           // This is distinct from VarArg !!
typedef int VarFunc(VarArg* var, void* data);

extern class Term;
extern class BindEnv;
extern class Relation;
extern struct BitVector;
/* Copy and simplify from old_args to new_args. */
// WARNING:  may need to change NULL below to UnusedEnv
extern int CopyArgs(ArgPtr* new_args, ArgPtr *old_args, BindEnv *env,
		    int arity, BindEnv *dont_rename_env,
		    BindEnv *rename_only_env = NULL);

EXTERN void PrintSymbol ARGS((Name sym, FILE *ff));
EXTERN Name EnterSymbol ARGS((const char *));
extern Name InsertSymbol ARGS((const char *, int len));
extern Name DontCareSymbol;
extern DontCareArg TheDontCareArg;



typedef enum {
    COR_VARIABLE,
    COR_DONTCARE,
    COR_FUNCTOR,
    COR_CONST_ARG,      /* A generic constant (ie., w/o variables) type,
                             excluding those below */
    COR_SYMBOL_CONST,   /* A symbolic atom. 'functor' field points to name.*/
    COR_NUM_CONST,	/* A numeric atom. */
    COR_RELATION,	/* A Relation as a (nested) object. */
    COR_GROUPING,       /* Grouping (the <> operator) */
    COR_TUPLE_ARG,
    COR_TUPLE_VAR,
} arg_kind;

typedef enum {
    COR_NOT_A_NUMBER,
    COR_INTEGER,
    COR_DOUBLE,
    COR_ARITH_EXPR
} numarg_kind;



// Hashing and HashConsing constants:
// 	Any hash value other than VarHashValue and UnknownHashValue 
//		is a hash value of a ground term
//	A term whose hash value is VarHashValue is non-ground.
//	A term whose hash value is UnknownHashValue may be ground or non-ground
//		-- its hash value has not been computed.
// 	When hashconsing is used (USE_HASHCONSING is set), FuncArg.hash()
//		is either VarHashValue, or is a pointer to a
//		constant term that is equal to (FuncArg, bindenv) 
//		(the pointer is cast to HashVal). 
//		CAVEAT:  We assume that the pointer cannot be one of 
//			VarHashValue or UnknownHashValue.
//

#define VarHashValue ( (HashVal) -1)

// This value is not generally supported!
#define UnknownHashValue ( (HashVal) -2)

typedef unsigned int HashVal;
inline int isGroundHashValue( HashVal i) {
    return (i != VarHashValue && i != UnknownHashValue);
    }
inline int IntToHash(int i) { return ((HashVal)(-1) >> 1) & i; }


/*
 * An ArgList is an "variable size" array of (Arg*).
 * The first element is not actually an (Arg*),
 * but (after coercion to int) contains the length of the array. 
 * WARNING:  ArgList must remain a struct - do not make it into a class
 * that can contain virtual functions, else a lot of code will crash! 
 * Use ArgList::New() to create a new ArgList
 */
struct ArgList {
    ArgPtr a[1];
    /* ... array of (Arg*) follows */
    inline int count() const { return (int)(*((Arg**)this)); }
    inline int arity() const { return count(); }
    inline void set_count(int i) { *((Arg**)this) = (Arg*)i; }
    inline Arg **first() const { return (Arg**)(this)+1;}

    inline ArgPtr& operator [] (int i) const
	{ return ((Arg**)(this)+1)[i]; }
    inline ArgPtr arg (int i) const
	{ return ((Arg**)(this)+1)[i]; }

    // Returns true if all the arguments are NumArgs or Symbols
    int isConstant();

 /** Tarun **/
    void print_dump(BindEnv *context, FILE *file) const;
    void print(BindEnv *context, FILE *file) const;
    void print(BindEnv *context, FILE *file, char *fmt_str) const;

    void printon(FILE *file) const { print((BindEnv*)0, file); }
    void sprint(char *str, int *pos, BindEnv *context = NULL) const;

    VarLink *var_list(VarLink* rest);
    Variable max_vars();

    HashVal hash( BitVector& bv, BindEnv* env = NULL );
    HashVal hash( BindEnv* env = NULL );

    static ArgList * New(int arg_count); // Allocate new ArgList.

    RAW_GCCLASS(ArgList);

// ???
#define arg_vector(arglist) ((Arg**)(&(arglist) + 1))
};

// Use for making linked lists of Vars.
struct VarLink { 
    VarLink *next;
    VarArg *arg;
    VarLink(VarArg *a, VarLink *n) { arg = a; next = n; }
    int contains(VarArg *a);
};


// TermLink is used by CopyArgs() to re-number VarArgs.
struct TermLink {
    struct TermLink *next;  /* Next TermLink in list. */
    Variable old_var;
    BindEnv  *old_bindenv;
    struct VarArg *new_arg; /* ... and yield this new VarArg instead. */
};

// Generic Arg structure
struct Arg {
    virtual VarLink *var_list(VarLink* rest);
    virtual Variable max_vars();

    virtual void print(BindEnv *context, FILE *file) const;
    virtual void print(BindEnv *context, FILE *file, char *fmt_str) const;
    /** Tarun **/
    virtual void print_dump(BindEnv *context, FILE *file) const
      {print(context, file);};
 
    // sprint is used for printing on a string. The second
    // argument is advanced to the end of the written portion,
    // so that the next sprint can be called.
    virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const =0;
    void printon(FILE *file) const { print((BindEnv*)0, file); }
    virtual void printon(FILE *file, char *fmt_str) const;
    virtual void output() const { print((BindEnv*)0, stderr); }
    // dump: Write 'arg' as a C++ declaration, using a generated label
    // 		based on 'arg_number'.
    virtual void dump(int arg_number, FILE *file) = 0;

    virtual arg_kind kindof() const { return COR_CONST_ARG;}
    virtual int subkind() { return 0;}

    // Returns true if it is a NumArg or Symbol
    virtual int isConstant() = 0;
    virtual int equals(Arg *arg2);

    virtual HashVal hash(BindEnv *context = 0) ;

    virtual Arg* simplify(BindEnv *context, TermLink *&renamed_vars,
			BindEnv *const_env, BindEnv *rename_only_env);

    // For each VarArg* 'v' in 'this', call 'func(v, data)'.
    virtual int scan_vars(void *data, VarFunc *func) ;
    virtual const Numeric * numeric() const ;
};

// ConstArg is a superclass of NumArg and Symbol
struct ConstArg : public Arg {
    virtual int isConstant();
    virtual arg_kind kindof() const = 0;
    virtual int equals(Arg *arg2)=0;

    virtual void print(BindEnv* env, FILE *file) const = 0;
    virtual void print(BindEnv* env, FILE *file, char *fmt_str) const = 0;
    virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const =0;
    virtual void dump(int arg_number, FILE *file) = 0;
};


// All strings belong to this class
struct Symbol : public ConstArg {
    // Each symbol is identified by a hash value and a length
    HashVal _hash;
    int _length;
    /* actually has char data[length]; */

    inline Symbol(HashVal h, int l) { _hash = h; _length = l;}

    inline int Length() const { return (int) _length; }
    inline int length() const { return (int) _length; }
    // inline HashVal& Hash() const { return _hash; }

    inline char *string() const { return (char*)(this+1); }
    unsigned char *ustring() const { return (unsigned char*)(this+1); }
    inline Symbol *sym_name() const { return (Symbol*)this; }

    virtual arg_kind kindof() const ;
    virtual int equals(Arg *arg2);

    virtual void print(BindEnv*, FILE *file) const;
	virtual void print(BindEnv*, FILE *file, char *fmt_str) const;
    virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const;
    virtual void dump(int arg_number, FILE *file);

    virtual HashVal hash(BindEnv *context = 0);
};


struct DontCareArg : public Arg {
    Name _functor;/* functor info if kind==COR_FUNCTOR */
    inline DontCareArg() { _functor = DontCareSymbol; };

    virtual arg_kind kindof() const ;
    virtual int isConstant();
    virtual int equals(Arg *arg2);

    virtual void print(BindEnv*, FILE *file) const;
	virtual void print(BindEnv*, FILE *file, char *fmt_str) const;
    virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const;
    virtual void dump(int arg_number, FILE *file);
};



struct VarArg : public Arg {
    Name     _functor;       /* name of variable */
    int	     var;            /* Index into current context */
    VarArg(Name name, int index) { _functor = name; var = index; }
    inline Name var_name() const { return _functor; }

    virtual void print(BindEnv*, FILE *file) const;
	virtual void print(BindEnv*, FILE *file, char *fmt_str) const;
    virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const;
    virtual void dump(int arg_number, FILE *file);

    inline Term dereference_var(BindEnv* env); // Does a one level dereference
    inline Term dereference(BindEnv* env);  	// Does a full dereference

    virtual arg_kind kindof() const ;
    virtual int isConstant();
    virtual int equals(Arg *arg2);

    virtual VarLink *var_list(VarLink* rest);
    virtual HashVal hash(BindEnv *context = 0);
    virtual int scan_vars(void *data, VarFunc *func);
    virtual Arg* simplify(BindEnv *context, TermLink *&renamed_vars,
			BindEnv *const_env, BindEnv *rename_only_env);
#ifdef DO_GC
    GCCLASS(VarArg);
#endif
};


// Arguments that are functions. eg : f(X,Y) in pred(f(X,Y), Z).
// WARNING : FuncArg is variable size. Use FuncArg::New as constructor
class FuncArg : public Arg {
  protected:
    FuncArg(Name op, int argcount) : _functor(op)
	{ _hash = UnknownHashValue; args.set_count(argcount);}
    HashVal _hash;    
	// The field _hash of a FuncArg must be set to UnknownHashValue if the
	// 	hash value has not been computed.  It must be set to 
	//	VarHashValue if FuncArg is found to have variables in it.
	//  	It must be set to other values if FuncArg is found to be 
	//	variable free.  Thus looking at the _hash value is a 
	// 	quick sufficient test for the FuncArg being constant.
	//
  public:
    Name _functor;                     /* functor info if kind==COR_FUNCTOR */
    ArgList		args;	       /* args of functor */

    static FuncArg * New(Name op, int arg_count);

    virtual arg_kind kindof() const ;
    virtual int isConstant();
    virtual int equals(Arg *arg2);

    int count() const { return args.count(); }
    inline Name functor() const { return _functor; }
    inline int arity() { return args.count(); }

    virtual void print(BindEnv*, FILE *file) const;
	virtual void print(BindEnv*, FILE *file, char *fmt_str) const;
    virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const;
    virtual void dump(int arg_number, FILE *file);

    virtual VarLink *var_list(VarLink* rest);
    virtual HashVal hash(BindEnv *context = 0);
    virtual int scan_vars(void *data, VarFunc *func);
    virtual Arg* simplify(BindEnv *context, TermLink *&renamed_vars,
			BindEnv *const_env, BindEnv *rename_only_env);
    RAW_GCCLASS(FuncArg);
};


// ???
#define FUNC_ARG_MAX 4

struct FuncArg0 : public FuncArg {
    FuncArg0(Symbol *op) : FuncArg(op, 0) { }
};
struct FuncArg1 : public FuncArg { ArgPtr a[1];
    FuncArg1(Symbol *op, Arg *a0) : FuncArg(op, 1) { a[0]=a0; }
};
struct FuncArg2 : public FuncArg { ArgPtr a[2];
    FuncArg2(Symbol*op, Arg*a0, Arg*a1) : FuncArg(op, 2) { a[0]=a0; a[1]=a1; }
};
struct FuncArg3 : public FuncArg { ArgPtr a[3];
    FuncArg3(Symbol*op, Arg*a0, Arg*a1, Arg*a2) : FuncArg(op, 3)
      { a[0]=a0;a[1]=a1;a[2]=a2;}
};
struct FuncArg4 : public FuncArg { ArgPtr a[4];
    FuncArg4(Symbol*op, Arg*a0, Arg*a1, Arg*a2, Arg*a3) : FuncArg(op, 4)
      {a[0]=a0;a[1]=a1;a[2]=a2;a[3]=a3;}
};

typedef struct NumArg Root;
struct NumArg : public ConstArg {
    virtual arg_kind kindof() const;
    virtual numarg_kind num_kindof() const;
    virtual int equals(Arg *arg2);
    virtual int compare(const Root&) const;

    virtual void printon(FILE *) const = 0;
    virtual void printon(FILE *, char *) const = 0;
    virtual void print(BindEnv*, FILE *file, char *fmt_str) const;
    virtual void print(BindEnv*, FILE *file) const;
    virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const;
    virtual void dump(int arg_number, FILE *file);
};

#include "gennum.h"

struct ExprArg : public NumArg {

    Name   op;
    int    op_arity;
    Arg    *left_arg;
    Arg    *right_arg;

    ExprArg(Name op, Arg *left, Arg *right) 
	{this->op = op; left_arg = left; right_arg = right; op_arity = 2;}
    ExprArg(Name op, Arg *only)
	{this->op = op; left_arg = only; right_arg = (SmallInt *) Zero; 
			op_arity = 1;}

    virtual numarg_kind num_kindof() const;
    virtual Arg* simplify(BindEnv *context, TermLink *&renamed_vars,
			BindEnv *const_env, BindEnv *rename_only_env);
    // virtual const Numeric * numeric() const ;
    virtual HashVal hash(BindEnv *context = 0);
    virtual VarLink *var_list(VarLink* rest);

/** Tarun **/
    virtual void print(BindEnv *, FILE *) const ;
    virtual void print_dump(BindEnv * env, FILE *file) const;
    virtual void printon(FILE *) const ;
    virtual void printon(FILE *, char *) const ; 
    virtual void dump(int arg_number, FILE *file) ;
};

// NOTE: Do not edit this without also editing builtin_ops in gram.y!
enum AggregateKind {
    SumAggregation,
    ProductAggregation,
    CountAggregation,
    MinAggregation,
    MaxAggregation,
    AvgAggregation,
    SetAggregation,
    AnyAggregation,
    NoAggregation, // create_functor in gram.y assumes this is last.
};

// WARNING : Use Grouping::New to get a new Grouping (it is of variable size)
class Grouping : public Arg {
  public:
    FuncArg * nestedArgs;
    int index;               // Sequence number within current clause.

    short check_subsum;

    enum AggregateKind kind;
    // If kind==NoAggregation, then 'this' is the parse of '<ARGS>',
    // where 'nestedArgs' represents 'ARGS'.
    // Otherwise, if kind is (say) SummAggregation,
    // then 'this' is the parse of 'sum<ARGS>'.

    Grouping(int argcount);
    Grouping(FuncArg *func, int index);
    Grouping(FuncArg *func, int _index, int k)
	{ nestedArgs = func; index = _index; kind = (enum AggregateKind)k; }
    static Grouping* New(int arity) { return new Grouping(arity); }

    virtual arg_kind kindof() const;
    virtual int equals(Arg *arg2);
    virtual int isConstant() { return 1; }
    virtual void set_subsumption(short subsum_flag)
                                { check_subsum = subsum_flag; }

    /** Tarun **/
    virtual void print_dump(BindEnv * env, FILE *file) const;
    virtual void print(BindEnv* env, FILE *file) const;
    virtual void print(BindEnv* env, FILE *file, char *fmt_str) const;
    virtual void sprint(char *str, int *pos, BindEnv *context = NULL) const;
    virtual void dump(int arg_number, FILE *file);

    inline Arg **first() const { return nestedArgs->args.first(); }
    int arity() const { return nestedArgs->count(); }
    virtual Arg* simplify(BindEnv *context, TermLink *&renamed_vars,
			BindEnv *const_env, BindEnv *rename_only_env);
    // WARNING:: This assumes that nested sets are ground!! This ought to
    // 		be the case, but we should make sure using the 
    //   	hash value.
    int update_tuple(Relation *rel, Tuple *tuple, 
				int argnum, BindEnv *env, int &do_insert);
};

#endif /*!CORAL_ARG_H*/
