/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	apply.h : Header file

	Declaration of the rule structure that is created after
	the rule structures created by the parser are 'interpreted'.
	This is the rule structure used during query evaluation.

	Contains the following class/type  declarations	 :
	  RuleInfo

%%%
 ***********************************************************************/

#ifndef APPLY_H
#define APPLY_H

#include <stdio.h>
#include "externs.h"
#include "arg.h"
#include "profile.h"

typedef struct RuleInfo RuleInfo ;

extern int do_rule(void *, RuleInfo *, int, int, ...) ;

struct RuleInfo { 
  public :

  Arg***      arg_list ;
  int *       relations ;
  int *       offsets ;
  int         num_literals ;
  int         num_vars ;
  ProfileInfo pInfo ;
  struct rule *rule ;
  Relation ** headrel_ptr;

  RuleInfo(struct rule *);

  ~RuleInfo() ;
}; 

#define FORWARD 1
#define BACKWARD 0

// Define a couple of macros to avoid messy code within the function.

#define _PROFILE(X,Y,Z) \
   { \
     if ((exEnv.profile_sn)) {\
       pinfo->print(exEnv.profile_file,"SNR",Y,Z);\
       AddProfileInfo(pinfo, &X);\
       pinfo->reset();\
     }\
     else if ((exEnv.profile_scc) || (exEnv.profile_module)) { \
	     AddProfileInfo(pinfo, &X) ;\
             pinfo->reset() ; \
          } \
   }

#define NEGATED(index) (rInfo->relations[index] < 0)

#endif
