/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	annotations.h : Header file

	Declarations for predicate and rule annotations.

	Contains the following class/type  declarations	 :
	  PredAnnotations
	  RuleAnnotes
	  RuleAnno
	  AliasList
	  RuleAnnoCase
	  RuleAnnoCaseName
	  RuleAnnoCaseDetails

	  
 ***********************************************************************/


#ifndef ANNOTATIONS_H
#define ANNOTATIONS_H
#include "externs.h"

class PredAnnotations {
	struct PredAnnotations *_next;
public:
	Symbol *pred;
	ArgList *arglist1, *arglist2;
	BitVector *adorn;
	Arg *op_arg;  /* Operation and arg for aggregate selections */
	int check_subsum;

	PredAnnotations(Symbol *pred1, struct PredAnnotations *next1)
		{ pred =pred1; _next = next1; op_arg = NULL;}
	PredAnnotations *next() { return _next;}
	PredAnnotations *link(PredAnnotations *tail) 
			{ _next = tail; return this;}
	void print(FILE *file, int adorned = 1); 
	     // if "adorned" is not set, the field "adorn" is printed in
	     // parentheses instead of with an "_"
} ;


class RuleAnnotes{
public:

};

class AliasList{
public:

};


class RuleAnno{
public:
	RuleAnno *next;
};

class RuleAnnoCase{
public:
	RuleAnnoCase *next;
};

class RuleAnnoCaseName{
public:

};

class RuleAnnoCaseDetails{
public:

};

extern RuleAnnoCaseDetails *make_anno_case_details( Symbol *);
extern RuleAnnoCaseDetails *make_anno_case_details( ArgPtr);
extern RuleAnnoCaseDetails *make_anno_case_details( RuleAnnoCase *);
extern RuleAnnoCaseName *make_anno_case_name(Symbol *);
extern RuleAnnoCaseName *make_anno_case_name(ArgPtr);
extern RuleAnnoCase *link_anno_case_list( RuleAnnoCase*, RuleAnnoCase*);
extern RuleAnno	    *link_rule_anno(RuleAnno*, RuleAnno*);
extern RuleAnnoCase *make_anno_case(RuleAnnoCaseName*, RuleAnnoCaseDetails*);
extern RuleAnno     *make_anno(Symbol *, RuleAnnoCaseDetails*);

#endif
