// This may look like C code, but it is really -*- C++ -*-

/**********************************************************************
    File Name: The derivation class
    Author:    Bill Roth(387-820-7277)
    Date:      Tue Nov 17 22:10:43 1992 @ feline
    File:      /var/home/roth/code/iv/if/Derivation.h
    Comments:  The definition of the derivation class, and the NodeMenu
    Class

**********************************************************************/
#ifndef derivation_h
#define derivation_h

#include <InterViews/menu.h>
#include <Unidraw/uarray.h>

class Event;
class GraphicBlock;
class Node;
class PopupMenu;
class SF_Rect;
class TextGraphic;
class UArray;			
class ModuleWindow;
class C_ScanDesc;
class ArgList;
class Arg;

class Derivation {
public:
  Derivation(SF_Rect *theBox,TextGraphic *theText,GraphicBlock *gb,
	     ModuleWindow* m,boolean root);
  
  ~Derivation();		/* destructor */
  void Draw();			/* draw list */
  void Erase();			// erase the nodes. 
  /* insert term into list */
  void HandleHit(Event &e,PopupMenu *);	// handle mouse down
  void InsertTerm(const char *str,Arg* arg);

//menu commands

  void DoUp();
  void DoDown();
  void DoNext();
  void ShowUsed();

  void setMenu(PopupMenu *pop) {menu = pop;}
  void setMenuItemList(UArray* a) {menuItemList = a;}
  void setParent(Derivation* d,Node* n) {parent = d;parentNode=n;}
  void setChild(Derivation* d,Node*n);
  void setScanDesc(C_ScanDesc *s) {scan = s;}
  void Redo();			// called from Undo
  
  Derivation* getChild() {return child;}
  Derivation* getParent() {return parent;}

  Node* getNodeWithChildren() { return (Node*)((*nodeList)[childPos]);}
  Node* getFirstNode() {return (Node*)((*nodeList)[0]);}

  boolean isOnScreen() {return onScreen;}
  boolean isroot() {return isRoot;};
  void addTerms(Arg *list);         //take an arg list and add nodes from list
  
  C_ScanDesc *scan;            //The Scan descriptor.HACK
private:
  void GetTranslation(int i,int count,Coord& dx,Coord& dy);
  void ShowMenu(Event &e,Node* node);	// pop up Menu
  boolean makeSubTree(Node *node,C_ScanDesc*theScan=0);		// 

  int termPos;			/* position in term array */
  int childPos;			// position child in array
  Derivation *child;		// child of the node.
  Derivation *parent;		// derivation of where I came from.
  boolean onScreen;		// if I have been drawn
  ModuleWindow *window;		// connection for undo.
  Node *parentNode;		// node that I\'m hanging from.

// node stuff
  UArray *list;			/* list of terms */
  UArray *nodeList;		/* list of nodes */
  UArray *argsList;		// for args in nodes.

// menu data
  PopupMenu *menu;
  UArray* menuItemList;		// list of menu items
  

  SF_Rect *box;			/* the box template */
  TextGraphic *text;		/* The text template */
  GraphicBlock *block;		/* the block to draw into */
  boolean isRoot;		// if not root, do not draw the top box.

  Node *selectedNode;
};

#ifndef NodeMenuItem_func
#define NodeMenuItem_func
typedef void (Derivation::*NodeMenuItem_Func)();
#endif

class NodeMenuItem : public MenuItem {
public:
  NodeMenuItem(const char*,  const char*, Alignment);
  virtual void Do();
  void SetCoreClass(Derivation*d) { _coreclass = d;}
  void SetCoreFunc(NodeMenuItem_Func f){_func = f;}
private:
  NodeMenuItem_Func _func;
  Derivation* _coreclass;
};

#endif derivation_h

