
\begin{tt}
\begin{verbatim}

module pipe_eg2.
@pipelining.

export tested1(f), tested2(f), tested3(f).

%  This is a simple example of a generate-and-test program that
%  uses cut (!) to stop after producing one solution.

tested1(X) :- generate(X,Y), test(Y), !.

%  Compare tested1 with tested2, which does not use the cut.

tested2(X) :- generate(X,Y), test(Y). 

generate(X,Y) :- candidates(X,Y).
test(Y) :-  candidates(X,Z), candidates(U,V), Z>V, Y>Z, Y<6.

%  tested3 shows the operational reasoning involved in using cuts: although
%  it is logically equivalent to the previous definitions, it produces
%  no answer.

tested3(X) :- generate(X,Y), test3(Y), !, Y<6.

test3(Y) :-  candidates(X,Z), candidates(U,V), Z>V, Y>Z.

end_module.

% sample data

candidates(a,2).
candidates(a,1).
candidates(b,3).
candidates(b,4).
candidates(c,5).
candidates(d,6).
candidates(d,7).

\end{verbatim}
\end{tt}

