

module declad_eg5a.
export spanning_tree(bfff,ffff), is_source(f).

/*  Selects (in a non-deterministic manner) spanning trees.
   	spanning_tree(root, start, end, cost)
    is true if (start, end, cost) is an edge in a selected spanning 
    tree rooted at root.   Can also be queried with root free.
    A variant of this program is discussed by Ganguly et al. in
    a PODS92 paper.

    Assumes a base relation edge(start, end, cost); sample in declad5.F 
 */ 

% The program below essentially does transitive closure to "reach" 
% all nodes. For each node reached via more than one incoming arc, 
% only one of these arcs is retained, thanks to the aggregate selection.

spanning_tree(R,nil,R,0) :- is_source(R).
spanning_tree(R,X,Y,C) :- spanning_tree(R,Z,X,C1), edge(X,Y,C).

% The following definition of is_source ensures that the "tree" does not
% contain cycles involving the source node.  It requires special entries
% in the edge relation for potential source nodes.

is_source(R) :- edge(nil, R, _).

@aggregate_selection spanning_tree (R,X,Y,C) (R,Y) any(X,C).

% the above aggregate selection is the same as:
% @choice spanning_tree (R,X,Y,C) (R,Y).

end_module.


module declad_eg5b.
export min_spanning_tree(bfff,ffff).


/*  Selects (in a non-deterministic manner) minimum cost spanning trees.
   	min_spanning_tree2(root, start, end, cost)
    is true if (start, end, cost) is an edge in a selected spanning 
    tree rooted at root.   Can also be queried with root free.

    At each step, the set of edges of the form (from,to) with `from' in
    the current spanning tree is examined.  Of these, the edges with the
    least cost are chosen and added to the tree, subject to an
    aggregate selection on min_spanning_tree that ensures that each 
    node has only one immediate predecessor in a tree.  
    In considering candidate edges for addition to the tree,
    previously chosen edges are ignored in order to allow
    more expensive edges to be considered; the @monotonic
    annotation ensures that the current set of `chosen'
    tuples is used in the negated literal.  (The default is
    to completely evaluate `chosen'; this would be
    inappropriate.)  This definition of `chosen' ensures
    that the current least cost edges are added to the tree at 
    each step.  Contrast this with the min_spanning_tree2 program,
    which is WRONG.

    Assumes a base relation edge(start, end, cost) 

*/ 

min_spanning_tree(R,nil,R,0) :- is_source(R).
min_spanning_tree(R,X,Y,C):- 
	min_spanning_tree(R,Z,X,C1), chosen(R,X,Y,C).

@aggregate_selection min_spanning_tree (R,X,Y,C) (R,Y) any(X,C).

is_source(R) :- edge(nil, R, _).

chosen(R,X,Y,C) :- candidate(R,X,Y,C), not chosen(R,X,Y,_).
candidate(R,X,Y,C) :- min_spanning_tree(R,_,X,_), edge(X,Y,C).

@monotonic.
@aggregate_selection chosen (R,X,Y,C) (R,X,Y) min(C).

end_module.


module declad_eg5c.
export min_spanning_tree2(bfff).

/*  This program is incorrect.  It is only included to further
illustrate how the previous (correct) program works.  */

min_spanning_tree2(R,nil,R,0) :- is_source(R).
min_spanning_tree2(R,X,Y,C):- 
	min_spanning_tree2(R,Z,X,C1), chosen(R,X,Y,C).

@aggregate_selection min_spanning_tree2 (R,X,Y,C) (R,Y) any(X,C).

is_source(R) :- edge(nil, R, _).

chosen(R,X,Y,C) :- min_spanning_tree2(R,_,X,_), edge(X,Y,C).

@monotonic.
@aggregate_selection chosen (R,X,Y,C) (R,X,Y) min(C).

end_module.


