
\begin{tt}
\begin{verbatim}

module declse_eg4b.
export friends(ff), known(ff), connected(ff).
@pipelining.

% these rules illustrate that sets can be manipulated effectively
% in conjunction with pipelining although grouping is not allowed.

friends(john, {joe,sue}).
friends(joe, {jill,jack}).
friends(jack, {carl}).

known(X,Z) :- friends(X,S), member(S,Z).
known(X,Z) :- friends(X,S1), member(S1,Y), friends(Y,S), member(S,Z).

% however, the following definition causes an infinite loop with pipelining!
% try it without pipelining; it works fine.

connected(X,Z) :- friends(X,S), member(S,Z).
connected(X,Z) :- connected(X,Y), friends(Y,S), member(S,Z).

end_module.

\end{verbatim}
\end{tt}

