
\begin{tt}
\begin{verbatim}

module declad_eg5a.
export spanning_tree(bfff,ffff).

/*  Selects (in a non-deterministic manner) spanning trees.
   	spanning_tree(root, start, end, cost)
    is true if (start, end, cost) is an edge in a selected spanning 
    tree rooted at root.   Can also be queried with root free.
    A variant of this program is discussed by Ganguly et al. in
    a PODS92 paper.

    Assumes a base relation edge(start, end, cost); sample set in declad5.F 
 */ 

% The program below essentially does transitive closure to "reach" all 
% nodes. For each node reached via more than one incoming arc, only 
% one of these arcs is retained, thanks to the aggregate selection.

spanning_tree(R,nil,R,0) :- is_source(R).
spanning_tree(R,X,Y,C) :- spanning_tree(R,Z,X,C1), edge(X,Y,C).

% The following definition of is_source ensures that the "tree" does not
% contain cycles involving the source node.  It requires special entries
% in the edge relation for potential source nodes.

is_source(R) :- edge(nil, R, _).

@aggregate_selection spanning_tree (R,X,Y,C) (R,Y) any(X,C).

% the above aggregate selection is the same as:
% @choice spanning_tree (R,X,Y,C) (R,Y).

end_module.

\end{verbatim}
\end{tt}
