

\begin{tt}
\begin{verbatim}

module declad_eg4b.
export sort2(f).
@no_rewriting.

% In each iteration, the old sort2 fact is deleted and a new one, 
% containing exactly one new X-value from p (the least cost tuple), 
% is generated.  Clearly, no additional rewriting is to be performed.  
% Further, if either head delete is omitted, the set of answers changes.  
% This is a very % operational program, and is perhaps best viewed 
% as a production-rule program.  The prioritize annotation ensures 
% that scc-by-scc evaluation is overridden (i.e. the rules are 
% evaluated together), and that in each iteration,
% the q relation contains a single tuple, with the order in which the
% tuples are seen governed by the min(C) condition.

sort2([]).
sort2([X|[C|L]]), del sort2(L), del q(X,C) :- sort2(L), q(X,C).

% The effect of prioritize is to add exactly one least cost q tuple 
%to the delta in each iteration. (Additional q facts are made 
% available only when no facts can be derived without such an addition.)

@prioritize q(X,C) min(C).

% The following rule is needed since only derived predicates 
% can be prioritized.

q(X,C) :- p(X,C).

end_module.

\end{verbatim}
\end{tt}

