

\begin{tt}
\begin{verbatim}

module declad_eg4a.
export sort1(f).
@no_rewriting.

% In each iteration, the old sort1 fact is deleted and a new one, 
% containing exactly one new X-value from p (the least cost tuple), 
% is generated.  Clearly, no additional rewriting is to be performed.  
% Further, if either of these head deletes is omitted, the set of 
% answers changes.  This is a very operational program, and is 
% perhaps best viewed as a production-rule program.

sort1([]).
sort1([X|[C|L]]), del sort1(L), del choose(C), del p(X,C) :- 
			sort1(L), choose(C), p(X,C).

% The fixpoint evaluation uses the scc-by-scc optimization:
% predicates are divided into sccs, and are evaluated in scc-by-scc order.
% This has the advantage that at each stage, only a small number of
% rules is examined, and further, a predicate from a lower scc can be
% treated as a base predicate, i.e. assumed to be fully evaluated,
% in higher sccs --- an optimization that significantly reduces
% the number of ``semi-naive'' rules.  In this program, the following 
% (commented out) rule is evaluated just once, prior to application 
% of the sort1 rules.  However, for the program to work as intended, 
% this rule must be re-evaluated after each change to p.  This effect 
% is achieved by placing the rule in a separate module.  Again, the 
% operational nature of this program is underscored.

% choose(min(<C>)) :- p(X,C).

end_module.

module declad_eg4a2.
export choose(f).

choose(min(<C>)) :- p(X,C).

end_module.

\end{verbatim}
\end{tt}

