module reverse.
export reverse(bf).

/* This is the well-known naive reverse program.  A sample query is in
nrev.F.  If supplementary magic is used, some additional annotations
will improve performance:

@index_deltas -.
@multiset +.
@check_subsumption +.
@sup_magic +.

However, this program is best evaluated with pipelining.  */

@pipelining.
@index_deltas -.

reverse([],[]) .
reverse([X|Y], Z) :- reverse(Y,Z1), append(Z1, [X], Z).

append([], X, X).
append([X|Y], Z, [X|W]) :- append(Y, Z, W).


end_module.
