
module mcp.

export cost(bbff). 

% The chain product of n matrices M1.M2 ... Mn is to be computed;
% The input relation r is such that for each i, 1 <= i < n, 
% Mi has R rows and C columns where r(i,R) and r(i+1,C).
% See, e.g., Sedgewick's Algorithms text for a discussion.

% cost(L,R,C,K):  C is the minimum cost of computing ML ... MR;
% The minimum cost was obtained by multiplying (ML ... Mk-1)
% and (MK ... MR).  (This field allows us to recover the exact 
% chain of multiplications, if desired.)

cost(I,I,0,I).	% A `group' containing just one matrix needs no multiplications.

cost(L,R,C,K) :- foreach(K,L+1,R), 	% Consider all groupings.
	cost(L,K-1,C1,_), 		% Cost of computing group ML...MK-1
	cost(K,R,C2,_), 		% Cost of computing group MK...MR
	r(L,P), r(K,Q), r(R+1,S),	% These are P-by-Q and Q-by-S matrices.
	C = C1+C2+ P*Q*S.		% Add costs of computing plus multiplying
					% the two intermediate matrices.


% We only care about the least cost grouping for a given L and R.

@aggregate_selection cost(L,R,C,K) (L,R) min(C).

end_module.


module foreach.
export foreach(fbb).

% Generates all integer values in the range Low to High, both inclusive.

foreach(Low,Low,High) :- Low <= High.
foreach(I+1,Low,High) :- foreach(I,Low,High), I < High.

end_module.


/*  Sample data */

% Data for the example discussed in the Sedgewick text
% 6 matrices are being multiplied; 4-by-2, 2-by-3, 3-by-1,
% 1-by-2, 2-by-2 and 2-by-3.  The appropriate query i
% is ?cost(1,6,C,K).

r(1,4).
r(2,2).
r(3,3).
r(4,1).
r(5,2).
r(6,2).
r(7,3).
