
module knap2.

export cost2(bbf). 

% cost(J,I,C):  C is the optimal value of a knapsack 
% of size I packed using only items of types 1 through J.
% This program uses grouping, rather than aggregate selections.
% Since this program is monotonic, the elegant solution
% using aggregate solutions, presented in knap.P, is
% possible.  However, the solution with grouping
% brings out the dependencies between different problem
% sizes more clearly.  It is instructive to compare the two
% solutions.

cost2(J,I, max(<C>)) :- cost1(J,I,C).

cost1(1,0,0).	
cost1(J,I,C) :- J1=J-1, J1>0, cost2(J1,I,C).
cost1(J,I,C) :- size(J,S), I1=I-S, I1>=0,
	cost2(J, I1, C2), 	% knapsack value for size I1
	value(J,V), C = C2+V.	% add item of type J to
				% knapsack of size I1 

end_module.

/*  Sample data */

% 5 types of items; see Sedgewick's ``Algorithms'' text 
% for a discussion.  The size s and value v of an item of 
% type i is given by size(i,s) and value(i,v).
% Try ?cost(5,17,C,X).

size(1,3).
size(2,4).
size(3,7).
size(4,8).
size(5,9).

value(1,4).
value(2,5).
value(3,10).
value(4,11).
value(5,13).

