module algebra.
export g(f).
@sup_magic.	% This is the default.

/*  This refines the solution in algebra2.P by changing the representation
from lists to terms, taking advantage of the fact that all elements of
the larger algebra have exactly 27 elements.  This speeds up the program
by over a factor of 3.  The technique is presented in O'Keefe's book.   */



g(X) :- g1(X).
g(X) :- g2(X).
g(X) :- g3(X).

g(X) :- g(Y), g(Z), mt(Y,Z,X).

end_module.


module mt.
export mt(bbf).
@pipelining.
@make_index m(bbf).

/*  Here's where the changes are.  These changes are also reflected
in the data.  */


mt(f(Xa,Xb,Xc,Xd,Xe,Xf,Xg,Xh,Xi,Xj,Xk,Xl,Xm,Xn,Xo,Xp,Xq,Xr,Xs,Xt,Xu,Xv,Xw,Xx,Xy,Xz,X0),
   f(Ya,Yb,Yc,Yd,Ye,Yf,Yg,Yh,Yi,Yj,Yk,Yl,Ym,Yn,Yo,Yp,Yq,Yr,Ys,Yt,Yu,Yv,Yw,Yx,Yy,Yz,Y0),
   f(Za,Zb,Zc,Zd,Ze,Zf,Zg,Zh,Zi,Zj,Zk,Zl,Zm,Zn,Zo,Zp,Zq,Zr,Zs,Zt,Zu,Zv,Zw,Zx,Zy,Zz,Z0)) :-

   m(Xa,Ya,Za),
   m(Xb,Yb,Zb),
   m(Xc,Yc,Zc),
   m(Xd,Yd,Zd),
   m(Xe,Ye,Ze),
   m(Xf,Yf,Zf),
   m(Xg,Yg,Zg),
   m(Xh,Yh,Zh),
   m(Xi,Yi,Zi),
   m(Xj,Yj,Zj),
   m(Xk,Yk,Zk),
   m(Xl,Yl,Zl),
   m(Xm,Ym,Zm),
   m(Xn,Yn,Zn),
   m(Xo,Yo,Zo),
   m(Xp,Yp,Zp),
   m(Xq,Yq,Zq),
   m(Xr,Yr,Zr),
   m(Xs,Ys,Zs),
   m(Xt,Yt,Zt),
   m(Xu,Yu,Zu),
   m(Xv,Yv,Zv),
   m(Xw,Yw,Zw),
   m(Xx,Yx,Zx),
   m(Xy,Yy,Zy),
   m(Xz,Yz,Zz),
   m(X0,Y0,Z0).


end_module.


% Data


/*  Note the change in the g1, ge and g3 facts below; 
the argument in each case is now a term rather than a list.
This is a more compact representation.  */


g1(f(0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2)).
g2(f(0,0,0,1,1,1,2,2,2,0,0,0,1,1,1,2,2,2,0,0,0,1,1,1,2,2,2)).
g3(f(0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2)).

m(0,0,0).
m(0,1,0).
m(0,2,0).
m(1,0,0).
m(1,1,0).
m(1,2,1).
m(2,0,0).
m(2,1,2).
m(2,2,2).
