
module ackermann.
export ack(bbf).

/*  The Ackermann function is the simplest non-primitive recursive function.
The number of calls rises (very!) rapidly with values of M and N. 
The optional annotations below improve performance somewhat.  They
are based upon the fact that this is a function; see tak.P and fib.P
for similar optimization.  */

@index_deltas -.
@multiset +.
@check_subsumption +.

ack(0,N,N+1).
ack(M,0,A) :- M>0, ack(M-1,1,A).
ack(M,N,C) :- M>0, N>0, ack(M,N-1,B), ack(M-1,B,C).

end_module.
