/*
 *
 *	sowam
 *		Bytecode-Interpreter fuer die SOWAM
 *
 *
 *	FILE
 *		streams.c
 *
 *	PURPOSE
 *		Verwaltung fuer Dateien
 *		
 *
 *
 *	AUTHORS
 *		Volker Siebert, Andreas Schwab
 *
 */

#include <stdio.h>
#include "sowam.h"
#include "streams.h"

struct stream streams[N_STREAMS] = { 0 };

static char *file_modes[3] = { "r", "w", "a" };

term
open_stream(name, mode)
  term* name;
  term* mode;
{
    int i;
    term result;

    for (i = 0; i < N_STREAMS; i++) {
	if (streams[i].file != NULL
	    && VAL(*name) == streams[i].name) {
	    fclose(streams[i].file);
	    break;
	}
    }
    if (i >= N_STREAMS)
	for (i = 0; i < N_STREAMS; i++)
	    if (streams[i].file == NULL)
		break;
    if (i >= N_STREAMS)
	runtime_error("Too many open streams");

    streams[i].name = VAL(*name);
    streams[i].mode = A_F(VAL(*mode)) - A_F(INPUT_SYM);
    if (streams[i].mode < 0 || streams[i].mode > 2)
	runtime_error("Illegal file mode");

    streams[i].file = fopen(AF_NAME(VAL(*name)), file_modes[streams[i].mode]);

    if (streams[i].file == NULL) {
	fail();
	SET_ECONST(result, NIL);
    } else
	SET_ECONST(result, i + 0x10000 - N_STREAMS);

    return result;
}

void
close_stream(s)
  term* s;
{
    struct stream *sp;

    DEREF_TERMP(s);
    if (TAG(*s) != T_AF || A_F(VAL(*s)) < MIN_STREAM)
	runtime_error("Illegal stream argument");

    sp = STREAM(*s);
    if (sp->file != NULL) {
	if (fclose(sp->file) == EOF)
	    fail();
	sp->file = NULL;
    }
}

FILE *
get_file(s, mode)
  term *s;
  int mode;
{
    struct stream *sp;

    DEREF_TERMP(s);
    if (TAG(*s) != T_AF || A_F(VAL(*s)) < MIN_STREAM)
	runtime_error("Illegal stream argument");

    sp = STREAM(*s);
    if (sp->file == NULL)
	runtime_error("Stream not open");

    if ((sp->mode == 0) != (mode == 0))
	runtime_error(mode == 0 ?
		      "Stream not open for input" : "Stream not open for output");

    return sp->file;
}
