/*
 *	std.h
 *
 *	Standard-Definitionen fuer den SOWAM Bytecode Interpreter
 *
 */


#define	TRUE	1
#define FALSE	0

#define forever	for(;;)

#define DEFAULT_HP_MAX		500000
#define DEFAULT_LS_MAX		500000
#define DEFAULT_OS_MAX		50000
#define DEFAULT_TRL_MAX		50000
#define DEFAULT_AF_MAX		5000
#define	DEFAULT_TA_MAX		10000

#define NIL		0	/* index des nil-Atomes in der A/F Area */
#define SUCC_SYM	(1|0x10000)	/* Index der s(_) Struktur in der A/F Area */
#define ZERO_SYM	2	/* Index des '0'-Atoms in der A/F Area */
#define READERROR_SYM	3
#define EQ_SYM		(4|0x20000)
#define COMP_SYM	(5|0x20000)
#define CONST_SYM	(6|0x10000)
#define VAR_SYM		(7|0x10000)
#define STR_SYM		(8|0x10000)
#define LIST_SYM	(9|0x20000)
#define INT_SYM		(10|0x10000)
#define YFX_SYM		(11|0x20000) 
#define XFY_SYM		(12|0x20000)
#define XFX_SYM		(13|0x20000)
#define FY_SYM		(14|0x20000)
#define YF_SYM		(15|0x20000)
#define EOF_SYM		16
#define INPUT_SYM	17
#define OUTPUT_SYM	18
#define APPEND_SYM	19


#define READ		FALSE
#define WRITE		TRUE

#define FAIL		((code_addr)-1)
#define UNDEF		((term *)-2)

#define NO		0
#define YES		1
#define ABORT		2
#define TERMINATE	3

#define MAJOR_OPCODE(x)		(((x) >> 4) & 15)
#define MINOR_OPCODE(x)		((x) & 15)
#define OP2ARG(x)		(((x) >> 8) & 0xff)
#define OP1ARG(x)		((x) & 0xff)
#define LONG_ARG(p)		GET_LONG(p)

#define FUNCTOR		0
#define CONSTRUCTOR     1

#define CALL_OPCODE	0x60
#define CALL_AF_OPCODE	0x3C
#define CALL_RAF_OPCODE	0x3D
