/*
 * plstd.h
 *   Standard C header file for pl... application utilities
 *
 * Copyright (C) 1990 V.Siebert
 */

#ifndef __PLSTD_H
#define __PLSTD_H

#if __STDC__ || defined(USE_PROTOTYPES)
# define PROTO(x)	x
# ifndef __STDC__
#  define const
#  define volatile
# endif
#else
# define PROTO(x)	()
#endif

#ifndef MALLOC
/*
 * You can use your own memory management, if you define MALLOC,
 * REALLOC and FREE in "prologdef.h"
 */
extern void *malloc PROTO((unsigned s));
extern void *realloc PROTO((void *p,unsigned s));
extern void free PROTO((void *p));
# define MALLOC(s)	malloc(s)
# define REALLOC(p,s)	realloc(p,s)
# define FREE(p)	free(p)
#endif
#define TMALLOC(s,T)	(T *)MALLOC((s)*sizeof(T))
#define TREALLOC(p,s,T)	(T *)REALLOC(p,(s)*sizeof(T))

#ifndef TERMASSIGN
/*
 * If your TERM structure is too large to do a direct assignment,
 * define TERMASSIGN in "prologdef.h"
 */
# define TERMASSIGN(td,ts)	(td)=(ts)
#endif

#ifndef prolog_getchar
extern int prolog_getchar PROTO((void));
#endif

#ifndef prolog_putchar
extern int prolog_putchar PROTO((int ch));
#endif

#ifndef EOF
# define EOF		(-1)
#endif

#ifndef NULL
# define NULL		((void *)0)
#endif

#ifdef BSTRING
extern char *index PROTO((const char *s,int c));
extern void *bcopy PROTO((const void *s,void *d,unsigned l));
extern void *bzero PROTO((void *d,unsigned l));
extern int bcmp PROTO((const void *s,const void *d,unsigned l));
#else
/*
 * if BSTRING isn't defined, we use Ansi string functions
 */
# define index(s,c)	strchr(s,c)
# define bcopy(s,d,l)	memmove(d,s,l)
# define bzero(d,l)	memset(d,0,l)
# define bcmp(s,d,l)	memcmp(s,d,l)
extern char *strchr PROTO((const char *s,int c));
extern void *memmove PROTO((void *d,const void *s,unsigned l));
extern void *memset PROTO((void *d,int ch,unsigned l));
extern int memcmp PROTO((const void *s,const void *d,unsigned l));
#endif
extern int strcmp PROTO((const char *s1,const char *s2));
extern int strlen PROTO((const char *str));
extern char *strcpy PROTO((char *dst,const char *src));

#endif	/* __PLSTD_H */
