/*
 *
 *	sowam_funcs
 *		Hilfsfunktionen fuer den SOWAM-Interpreter
 *
 *
 *	FILE
 *		funcs.c
 *
 *	PURPOSE
 *		Hilfsfunktionen fuer den SOWAM-Interpreter
 *		
 *
 *
 *	AUTHORS
 *		Mike Wilhelm, Frank Lindert, Volker Siebert
 *
 *	HISTORY
 *		[001]	08.05.1990
 *			Erstimplementation
 *
 */

#include <sys/param.h>		/* fuer HZ */
#include <sys/types.h>
#include <sys/times.h>

#include "sowam.h"


void fail()
{
  struct trail *x;
  struct backtrack *p;
  int oanz;

  if (s_regs.tfp != FAIL)
    {
      s_regs.p = s_regs.tfp;
      s_regs.e = s_regs.re;
    }
  else if (s_regs.rfp != FAIL)
    {
      s_regs.p = s_regs.rfp;
      s_regs.e = s_regs.re;
    }
  else if(s_regs.b != 0)
    {
      /* Trail abbauen */
      for (x = s_regs.t; x < BACKB->bt_regs.t; x++)
	*x->trl_addr = x->trl_cont;
      /* Backtrackpunkt abbauen */
      p = BACKB;
      s_regs = p->bt_regs;
      s_flags = p->bt_flags;
      s_regs.b = p;
      bcopy((term *)p - p->bt_anz, &X_REG(1), p->bt_anz * sizeof(term));
      oanz = OANZ + isizeof(struct occ_stack) - 1;
      bcopy((term *)p - p->bt_anz - oanz, s_regs.op,
	    oanz * sizeof(term *));
    }
  else
    {
      print_time();
      stop(NO);
    }
}

int trail_undef(x)
term* x;
{
  if (x < s_regs.hr || x >= LS_MIN && x < s_regs.r)
    {
      fail();
      return FALSE;
    }
  if (BACKB != 0 && (x < BACKB->bt_regs.h || x >= LS_MIN && x < (term *)s_regs.b))
    PUSH_TRL_ENTRY(x);
  return TRUE;
}


/*
 * Diese Funktion baut den Occ-Stack ausgehend vom Term t auf
 */

void build_occ_stack(t)
     term *t;
{
  int n;

 loop:
  while (TAG(*t) == T_VAR || TAG(*t) == T_STRUCT)
    {
      if (LOC(*t) == ENV) return;
      t = &REF(*t);
    }

  switch (TAG(*t))
    {
    case T_AF:
      if (IS_FUNCTION(*t))
	PUSH_OS_ENTRY(t);
      for (n = ARITY(VAL(*t)); n > 1; n--)
	build_occ_stack(t + n);
      if (n > 0)
	{
	  t++;
	  goto loop;
	}
      break;

    case T_LIST:
      build_occ_stack(&TAIL(*t));
      t = &REF(*t);
      goto loop;

    default:
      break;
    }
  return;
}


void
print_time()
{
  struct tms end_time;

  times(&end_time);
  printf("Elapsed time: %.2fs\n",
	 (float)(end_time.tms_utime - start_time.tms_utime) / HZ);
}
