/*
 *	bytecode.h
 *		Definition des extenen Bytecode-Formats
 *
 */


/*
 * Aufbau eines Code-Headers
 */
struct codeheader {
    char	 ch_magic[4];	/* "FALF" */
    long	 ch_version;	/* Bytecode-Version */
    long	 ch_ca_max;	/* Laenge Code-Area in Bytes */
    long	 ch_af_max;	/* Laenge A/F-Area */
    long	 ch_ta_max;	/* Laenge Text-Area */
    long	 ch_rel_max;	/* Laenge Relocation-Tabelle */
    long	 ch_entry;	/* Programmeinsprung */
};


#define NONFIX		0	/* f (Atom) */
#define PREFIX		1	/* f(,,,) */
#define POSTFIX		2	/* (,,,)f */
#define INFIXNOT	3	/* (. f .) */
#define INFIXLEFT	4	/* (. f . f .) */
#define INFIXRIGHT	5	/* ((. f .) f .) */

struct ex_af_entry {
  long code1_addr;
  long code2_addr;
  long text_addr;
  long arity;
  WORD op_type;
  WORD prio;
};

struct relocation {
  int tag:8;
  int param:24;
};

#define REL_SYM		0
#define REL_CODE	1
#define REL_TABLE	2
