/*
 *
 *	sowam_c
 *		Bytecode-Interpreter fuer die SOWAM
 *
 *
 *	FILE
 *		af-area.c
 *
 *	PURPOSE
 *		Verwaltung der Atom/Funktor-Area
 *
 *
 *	AUTHORS
 *		Andreas Schwab
 *
 *
 */

#include "sowam.h"
#include "af-area.h"
#include "bytecode.h"

#define HASH(var, c) \
  ((var += (c)), (var = ((var) << 7) + ((var) >> 20)))

struct af_entry *af_ptr, *af_end;

struct af_hash {
  struct af_hash *next;
  int index;
};

#define NAME_BUCKETS	1009

struct af_hash *af_hash_table[NAME_BUCKETS];

int
lookup_symbol(name, arity)
     char *name;
     int arity;
{
  struct af_hash *ah;
  unsigned int hash;
  char *p;

  hash = arity;
  for (p = name; *p != '\0'; p++)
    HASH(hash, *p);
  hash %= NAME_BUCKETS;

  for (ah = af_hash_table[hash]; ah != NULL; ah = ah->next)
    if (strcmp(name, b_af_area[ah->index].text_addr) == 0
	&& b_af_area[ah->index].arity == arity)
      return ah->index;

  if (af_ptr >= af_end)
    af_overflow();

  ah = (struct af_hash *)xmalloc(sizeof(struct af_hash));
  ah->next = af_hash_table[hash];
  af_hash_table[hash] = ah;
  ah->index = af_ptr - b_af_area;
  af_ptr->rewrite_addr = af_ptr->narrow_addr = af_ptr->pred_addr = 0;
  af_ptr->text_addr = savestring(name);
  af_ptr->arity = arity;
  af_ptr->op_type = nonfix;
  af_ptr->prio = 0;
  af_ptr++;

  return ah->index;
}

static struct init_af {
  char *name;
  int arity;
} builtin_symbols[] = {
  { "[]", 0 },
  { "s", 1 },
  { "0", 0 },
  { "read_error", 0 },
  { "=", 2 },
  { "compound", 2 },
  { "const", 1 },
  { "var", 1 },
  { "str", 1 },
  { "list", 2 },
  { "integer", 1 },
  { "infixleft", 2 },
  { "infixright", 2 },
  { "infixnot", 2 },
  { "prefix", 2 },
  { "postfix", 2 },
  { "end_of_file", 0 },
  { "input", 0 },
  { "output", 0 },
  { "append", 0 }
};

#define N_BUILTIN_SYMBOLS (sizeof(builtin_symbols) / sizeof(builtin_symbols[0]))

void init_builtin_symbols()
{
  int i, index;

  b_af_area =
    (struct af_entry *)xmalloc(af_max * sizeof(struct af_entry));
  af_ptr = b_af_area;
  af_end = b_af_area + af_max;

  for (i = 0; i < N_BUILTIN_SYMBOLS; i++)
    {
      index = lookup_symbol(builtin_symbols[i].name, builtin_symbols[i].arity);
      if (index != i)
	internal_error("builtin_symbols");
    }
}

#ifdef DEBUG
void
dump_af_hash()
{
  int i;
  struct af_hash *ah;

  for (i = 0; i < NAME_BUCKETS; i++)
    {
      ah = af_hash_table[i];
      if (ah)
	{
	  printf("%d: ", i);
	  while (ah)
	    {
	      printf("%s/%d ", b_af_area[ah->index].text_addr,
		     b_af_area[ah->index].arity);
	      ah = ah->next;
	    }
	  printf("\n");
	}
    }
}
#endif
