%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                     
% c4_build_skeleton : compiler FLAT_ALF --> SOWAM   (Prozedurgeruest)
%                                                                     
% Projektgruppe PILS             UNIVERSITAET DORTMUND                
% Untergruppe COMPILER                                                
% Hans-Bernhard Korthaus                                              
%                                                                     
% April 1990 - Juli 1990                                              
%                                                                     
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_build_skeleton(+Ruleblock1, -SOWAM_G)
% 	main procedure to c4_get the procedure skeleton (written in SOWAM-Code)
% 	out of a FLAT_ALF-program                                           
%
% Ruleblock1:   This is the structure which contains the information 
%		necessary to compile the procedure skeleton for a specific
%		procedure.
%		The name of the structure is 'pred', 'redu' of 'func'.
%		It contains 
%		* the arity of the procedure, 
%		* the quantity of its rules, and
%		* a list which represents the first arguments of a FLAT_ALF-
%		  procedure and their order. The sorts of the arguments can be:
% 		  - const(NAME)
% 		  - struct(NAME, ARITY)
% 		  - var
% 		  - list
% SOWAM_G:	This is the procedure skeleton, a list containing SOWAM-Code.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4b(A,B) :- c4_build_skeleton(A,B).

c4_build_skeleton(Ruleblock1, SOWAM_G) :-
    c4_pass_EXT_1(Ruleblock1, EXT_1),
    c4_check_EXT_1(EXT_1, SOWAM_G).


c4_check_EXT_1(ext_1(_, _, 1, _, _, _, _, _), [pseudocode(c1)]).

c4_check_EXT_1(ext_1(A, B, QUANTITY, C, D, F, G, H), SOWAM_G) :-
    c4_pass_EXT_3(ext_1(A, B, QUANTITY, C, D, F, G, H), EXT_3),
    c4_pass_EXT_4(EXT_3, EXT_4),
    c4_pass_SOWAM_1(EXT_4, SOWAM_1),
    c4_pass_SOWAM_2(SOWAM_1, SOWAM_2),
    c4_pass_SOWAM_3(SOWAM_2, SOWAM_3),
    c4_pass_SOWAM_4(SOWAM_3, SOWAM_4),
    c4_pass_SOWAM_G(SOWAM_4, SOWAM_G).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% p(+Ruleblock1_FILE)
% 	This procedure provides the possiblity to test the program 
%       'build-skeleton'. The input must be a file-name, the file has to 
%	contain a structure of the syntax of Ruleblock1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4p(FILE) :-
    see(FILE),                        % TEST-FACILITY
    read(Ruleblock1),                 % TEST-FACILITY
    seen,                             % TEST-FACILITY
    c4_pass_EXT_1(Ruleblock1, EXT_1),
    c4_pass_EXT_3(EXT_1, EXT_3),
    c4_pass_EXT_4(EXT_3, EXT_4),
    c4_pass_SOWAM_1(EXT_4, SOWAM_1),
    c4_pass_SOWAM_2(SOWAM_1, SOWAM_2),
    c4_pass_SOWAM_3(SOWAM_2, SOWAM_3),
    c4_pass_SOWAM_4(SOWAM_3, SOWAM_4),
    c4_pass_SOWAM_G1(SOWAM_4, SOWAM_G),
    c4_print_result(SOWAM_G).

    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_EXT_1(+Ruleblock1, -EXT_1)                                     
% 	Translates imported Sort Ruleblock1 to first own Sort EXT_1        
% Ruleblock1:	see above
% EXT_1: 	This sort is only an own representation of the input.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_EXT_1(pred(ARITY, QUANTITY, TERM_LIST),
	      ext_1(pred, ARITY, QUANTITY, TERM_LIST, _, _, _, _)).

c4_pass_EXT_1(redu(ARITY, QUANTITY, TERM_LIST),
	      ext_1(redu, ARITY, QUANTITY, TERM_LIST, _, _, _, _)).

c4_pass_EXT_1(func(ARITY, QUANTITY, TERM_LIST),
	      ext_1(func, ARITY, QUANTITY, TERM_LIST, _, _, _, _)).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_EXT_2(+EXT_1, -EXT_2)                                          
% 	c4_pass_EXT_2 is no longer necessary because of a modification of
% 	the TERMLIST which c4_build_skeleton (the main procedure) will 
% 	receive: This TERMLIST is already classified, consisting only
% 	of the elements 
% 	- const(NAME)
% 	- struct(NAME, ARITY)
% 	- var
% 	- list
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_EXT_3(+EXT_1, -EXT_3)                                          
% 	Divides TERM_LIST0 into a list of blocks (BLOCK_LIST) ,which 
%	elements are either the list     
% 	- [var] or
%	- a list of terms not containing the atom 'var', with maximal length.
% 	Gets also the number of blocks (BLOCK_QUANTITY) and a list of 
%	their strengths (BLOCK_STRENGTHS).        
% EXT_1:	see above
% EXT_3:	like EXT_1, plus the three sorts BLOCK_LIST, BLOCK_QUANTITY
%		and BLOCK_STRENGHTS.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_EXT_3(ext_1(KIND, ARITY, QUANTITY, TERM_LIST0, _, _, _, _),
	      ext_3(KIND, ARITY, QUANTITY, BLOCK_LIST, _, BLOCK_STRENGTHS,
		    BLOCK_QUANTITY, _)) :-
    c4_pass_block_list(TERM_LIST0, BLOCK_LIST),
    c4_block_strength(BLOCK_LIST, BLOCK_STRENGTHS),
    length(BLOCK_LIST, BLOCK_QUANTITY).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_block_list(+LIST_OF_TERMS, -LIST_OF_BLOCKS_OF_TERMS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_block_list([], []).
c4_pass_block_list([var|TERMLIST0], [[var]|TERMLIST]) :-
    c4_pass_block_list(TERMLIST0, TERMLIST).
c4_pass_block_list(TERMLIST0, [BLOCK|REST_BLOCK_LIST]) :-
    c4_is_in(TERMLIST0, var),
    c4_first_position(TERMLIST0, var, POSITION),
    c4_split(TERMLIST0, POSITION, BLOCK, REST_BLOCK_LIST0),
    c4_pass_block_list(REST_BLOCK_LIST0, REST_BLOCK_LIST).
c4_pass_block_list(TERMLIST0, [TERMLIST0]).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_block_strength(+LIST_OF_LISTS, -LIST_OF_THEIR_STRENGTHS)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_block_strength([], []).
c4_block_strength([H|T] , [STRENGTH|STRENGTH_LIST]) :-
    length(H, STRENGTH),
    c4_block_strength(T, STRENGTH_LIST).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_EXT_4(+EXT_3, -EXT_4)                                          
% 	Gets a struct_list out of the block_list of EXT_3, that is a list 
% 	of blocks containing information about the c4_occurences of            
% 	constants, variables, structures and lists in those blocks.         
%	c4_pass_EXT_4 is the c4_last procedure which collects only information,
%	all coming procedures will build the procedure skeleton.
% EXT_3: 	see above
% EXT_4:	like EXT_3, the fourth argument has changed to the sort
%		STRUCTURE_LIST
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_EXT_4(ext_3(KIND, ARITY, QUANTITY, BLOCK_LIST, _, BLOCK_STRENGTHS, 
		    BLOCK_QUANTITY, _),
	      ext_4(KIND, ARITY, QUANTITY, STRUCTURE_LIST, _, BLOCK_STRENGTHS,
		    BLOCK_QUANTITY, _)) :-
    c4_pass_struct_list(BLOCK_LIST, STRUCTURE_LIST, BLOCK_STRENGTHS, 1).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_struct_list(+BLOCK_LIST, -STRUCTURE_LIST, +BLOCK_STRENGTHS,
%		      +BLOCK_NUMBER)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%+BLOCK_LIST:      Main structure of EXT_3, containing a list of blocks.
%                  Blocks are either the list '[var]' or a list of the
%                  structures 'list', 'const(name)', 'struct(name, arity)'
%-STRUCTURE_LIST:  The result of this translation step, containing
%                  the elements 'var(position)' and 
%                  'block(CONSTANTS, STRUCTURES, LISTS)'. The substructs 
%                  are lists containing information about the quantities 
%		   and positions of the elements of the blocks from BLOCK_LIST.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_struct_list([], [], _, _).
c4_pass_struct_list([[var]|BLOCK_LIST0], [[var(POSITION)]|STRUCTURE_LIST], 
		    BLOCK_STRENGTHS, BLOCK_NUMBER0) :-
    BLOCK_NUMBER1 is BLOCK_NUMBER0-1,
    c4_add_first_elements(BLOCK_STRENGTHS, BLOCK_NUMBER1, OFFSET),
    POSITION is OFFSET+1,
    BLOCK_NUMBER is BLOCK_NUMBER0+1,
    c4_pass_struct_list(BLOCK_LIST0, STRUCTURE_LIST, BLOCK_STRENGTHS,
			BLOCK_NUMBER).
c4_pass_struct_list([BLOCK|BLOCK_LIST0],
		    [block(CONSTANTS, STRUCTURES, LISTS)|STRUCTURE_LIST],
		    BLOCK_STRENGTHS, BLOCK_NUMBER0) :-
    BLOCK_NUMBER1 is BLOCK_NUMBER0-1,
    c4_add_first_elements(BLOCK_STRENGTHS, BLOCK_NUMBER1, OFFSET),
    c4_pass_consts(BLOCK, OFFSET, CONSTANTS),
    c4_pass_structs(BLOCK, OFFSET, STRUCTURES),
    c4_pass_lists(BLOCK, OFFSET, LISTS),
    BLOCK_NUMBER is BLOCK_NUMBER0+1,
    c4_pass_struct_list(BLOCK_LIST0, STRUCTURE_LIST, BLOCK_STRENGTHS,
			BLOCK_NUMBER).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_add_first_elements(+LIST , +K, -SUM)
% 	Adds the first K elements of the list of integers LIST, result is SUM.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_add_first_elements(_,0,0).
c4_add_first_elements([INTEGER|T], K, SUM) :-
    K1 is K-1,
    c4_add_first_elements(T, K1, SUM1),
    SUM is INTEGER+SUM1.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_consts(+BLOCK, +OFFSET, -CONSTANTS)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_consts(BLOCK, OFFSET, CONSTANTS) :-
    c4_is_in(BLOCK, const(CONSTANT)),
    c4_pass_consts(BLOCK, OFFSET, CONSTANT, CONSTANTS).
c4_pass_consts(_, _, noconst).

c4_pass_consts(BLOCK, OFFSET, CONSTANT, oneconst(CONSTTABLE_ELEMENT)) :-
    c4_only_const(BLOCK, CONSTANT),
    c4_get_consttable_element(BLOCK, OFFSET, CONSTANT, CONSTTABLE_ELEMENT).
c4_pass_consts(BLOCK, OFFSET, CONSTANT, consttable(CONSTTABLE_LIST)) :-
    c4_get_consttable_list(BLOCK, BLOCK, OFFSET, CONSTANT, CONSTTABLE_LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_get_consttable_element(+BLOCK, +OFFSET, +CONSTANT, -CONSTTABLE_ELEMENT)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_get_consttable_element(BLOCK, OFFSET, CONSTANT, CONSTTABLE_ELEMENT) :-
    c4_position_list(BLOCK, const(CONSTANT), POSITION_LIST),
    c4_get_consttable_element1(POSITION_LIST, OFFSET, CONSTANT,
			       CONSTTABLE_ELEMENT).

c4_get_consttable_element1([POSITION1], OFFSET, CONSTANT,
			   lonely(CONSTANT, POSITION)) :-
    POSITION is POSITION1+OFFSET.
c4_get_consttable_element1(POSITION_LIST1, OFFSET, CONSTANT,
			   try(CONSTANT, QUANTITY, POSITION_LIST)) :-
    length(POSITION_LIST1, QUANTITY),
    c4_add_to_list(POSITION_LIST1, OFFSET, POSITION_LIST).

	
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_get_consttable_list(+BLOCK0, -BLOCK, +OFFSET, +CONSTANT, -CONSTTABLE_LIST)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_get_consttable_list(_, _, _, no(next_const), []).
c4_get_consttable_list(ORIGINAL_BLOCK, NEW_BLOCK0, OFFSET, CONSTANT, 
		       [CONSTTABLE_ELEMENT|CONSTTABLE_LIST]) :-
    c4_get_consttable_element(ORIGINAL_BLOCK, OFFSET, CONSTANT,
			      CONSTTABLE_ELEMENT),
    c4_delete_element(NEW_BLOCK0, const(CONSTANT), NEW_BLOCK),
    c4_find_next_const(NEW_BLOCK, NEW_CONSTANT),
    c4_get_consttable_list(ORIGINAL_BLOCK, NEW_BLOCK, OFFSET, NEW_CONSTANT,
			   CONSTTABLE_LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_find_next_const(+BLOCK1, -CONSTANT)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_find_next_const(BLOCK1, CONSTANT) :-
    c4_is_in(BLOCK1, const(CONSTANT)).
c4_find_next_const(_, no(next_const)).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_only_const(+BLOCK, +CONSTANT)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_only_const([], _).
c4_only_const([BLOCK_ELEMENT|BLOCK], CONSTANT) :-
    c4_is_this_const(BLOCK_ELEMENT, CONSTANT),
    c4_only_const(BLOCK, CONSTANT).

c4_is_this_const(const(CONSTANT), CONSTANT).
c4_is_this_const(struct(_,_), _).
c4_is_this_const(list, _).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_structs(+BLOCK, +OFFSET, -STRUCTURES)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_structs(BLOCK, OFFSET, STRUCTURES) :-
    c4_is_in(BLOCK, struct(STRUC_NAME, ARITY)),
    c4_pass_structs(BLOCK, OFFSET, STRUC_NAME, ARITY, STRUCTURES).
c4_pass_structs(_, _, nostruc).

c4_pass_structs(BLOCK, OFFSET, STRUC_NAME, ARITY,
		onestruc(STRUCTABLE_ELEMENT)) :-
    c4_only_struc(BLOCK, STRUC_NAME, ARITY),
    c4_get_structable_element(BLOCK, OFFSET, STRUC_NAME, ARITY,
			      STRUCTABLE_ELEMENT).
c4_pass_structs(BLOCK, OFFSET, STRUC_NAME, ARITY,
		structable(STRUCTABLE_LIST)) :-
    c4_get_structable_list(BLOCK, BLOCK, OFFSET, STRUC_NAME, ARITY,
			   STRUCTABLE_LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_get_structable_element(+BLOCK, +OFFSET, +STRUC_NAME, ARITY,
%			    -STRUCTABLE_ELEMENT)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_get_structable_element(BLOCK, OFFSET, STRUC_NAME, ARITY,
			  STRUCTABLE_ELEMENT) :-
    c4_position_list(BLOCK, struct(STRUC_NAME, ARITY), POSITION_LIST),
    c4_get_structable_element1(POSITION_LIST, OFFSET, STRUC_NAME, ARITY,
			       STRUCTABLE_ELEMENT).

c4_get_structable_element1([POSITION1], OFFSET, STRUC_NAME, ARITY,
			   lonely(STRUC_NAME, ARITY, POSITION)) :-
    POSITION is POSITION1+OFFSET.
c4_get_structable_element1(POSITION_LIST1, OFFSET, STRUC_NAME, ARITY,
			   try(STRUC_NAME, ARITY, QUANTITY, POSITION_LIST)) :-
    length(POSITION_LIST1, QUANTITY),
    c4_add_to_list(POSITION_LIST1, OFFSET, POSITION_LIST).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_get_structable_list(+BLOCK0, -BLOCK, +OFFSET, +STRUC_NAME, ARITY,
%			 -STRUCTABLE_LIST)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_get_structable_list(_, _, _, no(next_struct), _, []).
c4_get_structable_list(ORIGINAL_BLOCK, NEW_BLOCK0, OFFSET, STRUC_NAME, ARITY, 
		       [STRUCTABLE_ELEMENT|STRUCTABLE_LIST]) :-
    c4_get_structable_element(ORIGINAL_BLOCK, OFFSET, STRUC_NAME, ARITY,
			      STRUCTABLE_ELEMENT),
    c4_delete_element(NEW_BLOCK0, struct(STRUC_NAME, ARITY), NEW_BLOCK),
    c4_find_next_struct(NEW_BLOCK, NEW_STRUC_NAME, NEW_ARITY),
    c4_get_structable_list(ORIGINAL_BLOCK, NEW_BLOCK, OFFSET, NEW_STRUC_NAME, 
			   NEW_ARITY, STRUCTABLE_LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_find_next_struct(+BLOCK1, -STRUC_NAME, ARITY)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_find_next_struct(BLOCK1, STRUC_NAME, ARITY) :-
    c4_is_in(BLOCK1, struct(STRUC_NAME, ARITY)),
    !.
c4_find_next_struct(_, no(next_struct), _).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_only_struc(+BLOCK, +STRUC_NAME, +ARITY)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_only_struc([], _, _).
c4_only_struc([BLOCK_ELEMENT|BLOCK], STRUC_NAME, ARITY) :-
    c4_is_this_struc(BLOCK_ELEMENT, STRUC_NAME, ARITY),
    c4_only_struc(BLOCK, STRUC_NAME, ARITY).

c4_is_this_struc(struct(STRUC_NAME, ARITY), STRUC_NAME, ARITY).
c4_is_this_struc(const(_), _, _).
c4_is_this_struc(list, _, _).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_lists(+BLOCK, +OFFSET, -LIST_STRUCTURE)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_lists(BLOCK, OFFSET, LIST_STRUCTURE) :-
    c4_position_list(BLOCK, list, POSITION_LIST),
    c4_pass_lists1(POSITION_LIST, OFFSET, LIST_STRUCTURE).

c4_pass_lists1([], _, nolist).    
c4_pass_lists1([POSITION1], OFFSET, lonelylist(POSITION)) :-
    POSITION is POSITION1 + OFFSET.
c4_pass_lists1(POSITION_LIST1, OFFSET, trylist(QUANTITY, POSITION_LIST)) :-
    length(POSITION_LIST1, QUANTITY),
    c4_add_to_list(POSITION_LIST1, OFFSET, POSITION_LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_add_to_list(+INTEGER_LIST0, +K, -INTEGER_LIST)
% 	Adds to each element of INTEGER_LIST0 the integer K
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_add_to_list([], _, []).
c4_add_to_list([H0|T0], K, [H|T]) :-
    H is H0 + K,
    c4_add_to_list(T0, K, T).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_SOWAM_1(+EXT_4, -SOWAM_1)                                      
% 	This step builds the main frame of the procedure skeleton, i.e.
%	a sequence of
%	- try_me_else,
%	- retry_me_else and
%	- trust_me_else_fail - Code.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_SOWAM_1(ext_4(KIND, ARITY, QUANTITY, STRUCTURE_LIST, _,
		      BLOCK_STRENGTHS, 1, _),
		sowam_1(KIND, ARITY, QUANTITY, STRUCTURE_LIST, _,
			BLOCK_STRENGTHS, 1, CODEBLOCK_LIST)) :-
    c4_pass_one_block(KIND, STRUCTURE_LIST, CODEBLOCK_LIST).
c4_pass_SOWAM_1(ext_4(KIND, ARITY, QUANTITY, STRUCTURE_LIST, _,
		      BLOCK_STRENGTHS, BLOCK_QUANTITY, _),
		sowam_1(KIND, ARITY, QUANTITY, STRUCTURE_LIST, _,
			BLOCK_STRENGTHS, BLOCK_QUANTITY, CODEBLOCK_LIST)) :-
    c4_pass_many_block(KIND, ARITY, QUANTITY, STRUCTURE_LIST, BLOCK_QUANTITY, 
		       CODEBLOCK_LIST, 1).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_one_block(+ARITY, +STRUCTURE_LIST, -CODEBLOCK)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_one_block(_, [[var(_)]], [[pseudocode(c1)]]).
c4_pass_one_block(_, _, [[]]).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_many_block(+KIND, +ARITY, +QUANTITY, +STRUCTURE_LIST,
%		     +BLOCK_QUANTITY, -CODEBLOCK_LIST, +BLOCK_NUMBER)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_many_block(KIND, ARITY, QUANTITY, [STRUCTURE|STRUCTURE_LIST],
		   BLOCK_QUANTITY, [CODEBLOCK|CODEBLOCK_LIST], BLOCK_NUMBER) :-
    BLOCK_NUMBER > 1,
    BLOCK_QUANTITY =\= BLOCK_NUMBER,
    BLOCK_NUMBER1 is BLOCK_NUMBER + 1,
    c4_make_label(b, BLOCK_NUMBER, '', CODE_LABEL1),
    c4_make_label(b, BLOCK_NUMBER1, '', CODE_LABEL2),
    c4_pass_middle_block(CODE_LABEL1, CODE_LABEL2, KIND, STRUCTURE, CODEBLOCK),
    c4_pass_many_block(KIND, ARITY, QUANTITY, STRUCTURE_LIST, BLOCK_QUANTITY, 
		       CODEBLOCK_LIST, BLOCK_NUMBER1).

c4_pass_many_block(KIND, ARITY, QUANTITY, [STRUCTURE|STRUCTURE_LIST],
		   BLOCK_QUANTITY, [CODEBLOCK|CODEBLOCK_LIST], 1) :-
    c4_pass_first_block(KIND, ARITY, STRUCTURE, CODEBLOCK),
    c4_pass_many_block(KIND, ARITY, QUANTITY, STRUCTURE_LIST, BLOCK_QUANTITY, 
		       CODEBLOCK_LIST, 2).

c4_pass_many_block(KIND, _, _, [STRUCTURE|_], BLOCK_QUANTITY, [CODEBLOCK], 
		   BLOCK_QUANTITY) :-
    c4_make_label(b, BLOCK_QUANTITY, '', CODE_LABEL),
    c4_pass_last_block(CODE_LABEL, KIND, STRUCTURE, CODEBLOCK).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_middle_block(+CODE_LABEL1, +CODE_LABEL2, +KIND, +STRUCTURE,
%		       -CODEBLOCK)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_middle_block(CODE_LABEL1, CODE_LABEL2, KIND, STRUCTURE,
		     [code(CODE_LABEL1, RETRY_ME_ELSE)|PSEUDOCODE]) :-
    c4_redu_or_not(KIND, r_retry_me_else(CODE_LABEL2),
		   retry_me_else(CODE_LABEL2), RETRY_ME_ELSE),
    c4_pass_middle_block_pseudocode(STRUCTURE, PSEUDOCODE).

c4_pass_middle_block_pseudocode([var(POSITION)],
				[pseudocode(PSEUDOCODE_LABEL)]) :-
    c4_make_label(c, POSITION, '', PSEUDOCODE_LABEL).
c4_pass_middle_block_pseudocode(_, []).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_first_block(+KIND, +ARITY, +STRUCTURE, -CODEBLOCK)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_first_block(KIND, ARITY, STRUCTURE,
		    [code(nolabel, TRY_ME_ELSE)|PSEUDOCODE]) :-
    c4_redu_or_not(KIND,r_try_me_else(b2),try_me_else(b2, ARITY),TRY_ME_ELSE),
    c4_pass_first_block_pseudocode(STRUCTURE,PSEUDOCODE).

c4_pass_first_block_pseudocode([var(_)], [pseudocode(c1)]).
c4_pass_first_block_pseudocode(_, []).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_last_block(+CODE_LABEL, +KIND, +STRUCTURE, -CODEBLOCK)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_last_block(CODE_LABEL, KIND, STRUCTURE,
		   [code(CODE_LABEL, TRUST_ME_ELSE_FAIL)|PSEUDOCODE]) :-
    c4_redu_or_not(KIND, r_trust_me_else_fail, trust_me_else_fail,
		   TRUST_ME_ELSE_FAIL),
    c4_pass_last_block_pseudocode(STRUCTURE, PSEUDOCODE).

c4_pass_last_block_pseudocode([var(POSITION)],
			      [pseudocode(PSEUDOCODE_LABEL)]) :-
    c4_make_label(c, POSITION, '', PSEUDOCODE_LABEL).
c4_pass_last_block_pseudocode(_, []).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_make_label(+ATOM1, +NUMBER, +ATOM2, -LABEL)
% 	Map ATOM1 x NUMBER x ATOM2 --> LABEL  (in atomic representation)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_make_label(ATOM1, NUMBER, ATOM2, LABEL) :-
    name(ATOM1, ATOM1_CHARS),
    name(NUMBER, NUMBER_CHARS),
    name(ATOM2, ATOM2_CHARS),
    c4_concat_3(ATOM1_CHARS, NUMBER_CHARS, ATOM2_CHARS, LABEL_CHARS),
    name(LABEL, LABEL_CHARS).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_SOWAM_2(+SOWAM_1, -SOWAM_2)                                    
%	This translation step adds the switch_on_term-Code to the 
% 	procedure skeleton
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_SOWAM_2(sowam_1(KIND, ARITY, QUANTITY, STRUCTURE_LIST, _,
			BLOCK_STRENGTHS, BLOCK_QUANTITY, CODEBLOCK_LIST0),
		sowam_2(KIND, ARITY, QUANTITY, STRUCTURE_LIST, _,
			BLOCK_STRENGTHS, BLOCK_QUANTITY, CODEBLOCK_LIST)) :-
    c4_pass_codeblock_list2(STRUCTURE_LIST, BLOCK_STRENGTHS, 1, 
			    CODEBLOCK_LIST0, CODEBLOCK_LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_codeblock_list2([], _, _, _, []).

c4_pass_codeblock_list2([_|STRUCTURE_LIST], BLOCK_STRENGTH, BLOCK_NUMBER, 
			[CODEBLOCK|CODEBLOCK_LIST0],
			[CODEBLOCK|CODEBLOCK_LIST]) :-
    c4_get_element(BLOCK_STRENGTH, BLOCK_NUMBER, 1),
    BLOCK_NUMBER1 is BLOCK_NUMBER + 1,
    c4_pass_codeblock_list2(STRUCTURE_LIST, BLOCK_STRENGTH, BLOCK_NUMBER1, 
			    CODEBLOCK_LIST0, CODEBLOCK_LIST).

c4_pass_codeblock_list2([STRUCTURE|STRUCTURE_LIST], BLOCK_STRENGTH,
			BLOCK_NUMBER, 
			[CODEBLOCK0|CODEBLOCK_LIST0],
			[CODEBLOCK|CODEBLOCK_LIST]) :-
    c4_get_element(BLOCK_STRENGTH, BLOCK_NUMBER, B_STRENGTH),
    B_STRENGTH > 1,
    BLOCK_NUMBER0 is BLOCK_NUMBER - 1,
    c4_add_first_elements(BLOCK_STRENGTH, BLOCK_NUMBER0, POSITION),
    POSITION1 is POSITION  + 1,
    c4_pass_switch_on_term(STRUCTURE, POSITION1, BLOCK_NUMBER, SWITCH_TERM),
    c4_hang_on(CODEBLOCK0, SWITCH_TERM, CODEBLOCK),
    BLOCK_NUMBER1 is BLOCK_NUMBER + 1,
    c4_pass_codeblock_list2(STRUCTURE_LIST, BLOCK_STRENGTH, BLOCK_NUMBER1, 
			    CODEBLOCK_LIST0, CODEBLOCK_LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_switch_on_term(block(CONSTS, STRUCTS, LISTS), POSITION, BLOCK_NUMBER,
		       code(nolabel,
			    switch_on_term(VAR_LABEL, CONST_LABEL, 
					   LIST_LABEL, STRUCT_LABEL))) :-
    c4_make_var_label(POSITION, VAR_LABEL),
    c4_make_const_label(CONSTS, BLOCK_NUMBER, CONST_LABEL),
    c4_make_list_label(LISTS, BLOCK_NUMBER, LIST_LABEL),
    c4_make_struct_label(STRUCTS, BLOCK_NUMBER, STRUCT_LABEL).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_make_var_label(POSITION, VAR_LABEL) :-
    c4_make_label(c, POSITION, a, VAR_LABEL).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_make_const_label(noconst, _, fail).

c4_make_const_label(oneconst(lonely(_, POSITION)), _, CONST_LABEL) :-
    c4_make_label(c, POSITION, '', CONST_LABEL).

c4_make_const_label(oneconst(try(_, _, _)), BLOCK_NUMBER, CONST_LABEL) :-
    c4_make_label(t, BLOCK_NUMBER, c, CONST_LABEL).

c4_make_const_label(consttable(_), BLOCK_NUMBER, CONST_LABEL) :-
    c4_make_label(b, BLOCK_NUMBER, c, CONST_LABEL).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_make_list_label(nolist, _, fail).

c4_make_list_label(lonelylist(POSITION), _, LIST_LABEL) :-
    c4_make_label(c, POSITION, '', LIST_LABEL).

c4_make_list_label(trylist(_, _), BLOCK_NUMBER, LIST_LABEL) :-
    c4_make_label(t, BLOCK_NUMBER, l, LIST_LABEL).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_make_struct_label(nostruc, _, fail).

c4_make_struct_label(onestruc(lonely(_, _, POSITION)), _, VAR_LABEL) :-
    c4_make_label(c, POSITION, '', VAR_LABEL).

c4_make_struct_label(onestruc(try(_, _, _, _)), BLOCK_NUMBER, VAR_LABEL) :-
    c4_make_label(t, BLOCK_NUMBER, s, VAR_LABEL).

c4_make_struct_label(structable(_), BLOCK_NUMBER, VAR_LABEL) :-
    c4_make_label(b, BLOCK_NUMBER, s, VAR_LABEL).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_SOWAM_3(+SOWAM_2, -SOWAM_3)                                    
%	This translation step adds the switch_on_constant and 
%	switch_on_structure-Code to the procedure skeleton.
%
% TRY_INFO_LIST is a list of lists. It saves information about the
% try-retry-trust-codes which are constructed through c4_pass_SOWAM_4.
% This information is easy accessible during this pass, so it is obtained
% during this pass and not during c4_pass_SOWAM_4.
%
% Structure of TRY_INFO_LIST:
%    [ TRY_INFO_LIST_of_BLOCK_1,
%      TRY_INFO_LIST_of_BLOCK_2,
%      ...,
%      TRY_INFO_LIST_of_BLOCK_n
%    ]
%
% Structure of TRY_INFO_LIST_of_BLOCK_k:
%    [ try(TRY_LABEL_1k, POSITION_LIST1k),
%      try(TRY_LABEL_2k, POSITION_LIST2k),
%      ...,
%      try(TRY_LABEL_nk, POSITION_LISTnk)
%    ]
%      
% Structure of POSITION_LIST_ik: [POS_1, POS_2, ..., POS_n]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_SOWAM_3(sowam_2(KIND, ARITY, QUANTITY, STRUCTURE_LIST, _,
			BLOCK_STRENGTHS, BLOCK_QUANTITY, CODEBLOCK_LIST0),
		sowam_3(KIND, ARITY, QUANTITY, STRUCTURE_LIST, TRY_INFO_LIST,
			BLOCK_STRENGTHS, BLOCK_QUANTITY, CODEBLOCK_LIST)) :-
    c4_pass_codeblock_list3(STRUCTURE_LIST, BLOCK_STRENGTHS, 1,
			    CODEBLOCK_LIST0, TRY_INFO_LIST, CODEBLOCK_LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_codeblock_list3([], _, _, _, [], []).

c4_pass_codeblock_list3([[var(_)]|STRUCTURE_LIST], BLOCK_STRENGTHS,
			BLOCK_NUMBER, [CODEBLOCK|CODEBLOCK_LIST0], 
			[[]|TRY_INFO_LISTS], [CODEBLOCK|CODEBLOCK_LIST]) :-
    BLOCK_NUMBER1 is BLOCK_NUMBER + 1,
    c4_pass_codeblock_list3(STRUCTURE_LIST, BLOCK_STRENGTHS, BLOCK_NUMBER1, 
			    CODEBLOCK_LIST0, TRY_INFO_LISTS, CODEBLOCK_LIST).

c4_pass_codeblock_list3([STRUCTURE|STRUCTURE_LIST], BLOCK_STRENGTHS,
			BLOCK_NUMBER, [CODEBLOCK0|CODEBLOCK_LIST0],
			[TRY_INFO_LIST|TRY_INFO_LISTS], 
			[CODEBLOCK|CODEBLOCK_LIST]) :-
    c4_pass_switch_on(STRUCTURE, BLOCK_NUMBER, TRY_INFO_LIST, SWITCH_TERMS),
    c4_concat(CODEBLOCK0, SWITCH_TERMS, CODEBLOCK),
    BLOCK_NUMBER1 is BLOCK_NUMBER + 1,
    c4_pass_codeblock_list3(STRUCTURE_LIST, BLOCK_STRENGTHS, BLOCK_NUMBER1,
			    CODEBLOCK_LIST0, TRY_INFO_LISTS, CODEBLOCK_LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_switch_on(block(CONSTS, STRUCTS, LISTS), BLOCK_NUMBER, TRY_INFO_LIST,
		  SWITCH_TERMS) :-
    c4_make_switch_on_constant(CONSTS, BLOCK_NUMBER, 1, TRY_INFO_LIST1,
			       CONST_SWITCHES1),
    length(CONST_SWITCHES1, CL),
    c4_make_label(b, BLOCK_NUMBER, c, C_SWITCH_LABEL),
    (
	CONST_SWITCHES1 = [] ->
	CONST_SWITCHES = [];
	CONST_SWITCHES = [code(C_SWITCH_LABEL, 
			       switch_on_constant(CL, CONST_SWITCHES1))]
    ),
%% HBK 10.6.90
    c4_get_try_info_list_for_lists(LISTS, BLOCK_NUMBER, TRY_INFO_LIST2),
%% HBK 10.6.90
    c4_make_switch_on_structure(STRUCTS, BLOCK_NUMBER, 1, TRY_INFO_LIST3,
				STRUCT_SWITCHES1),
    length(STRUCT_SWITCHES1, SL),
    c4_make_label(b, BLOCK_NUMBER, s, S_SWITCH_LABEL),
    (
	STRUCT_SWITCHES1 = [] ->
	STRUCT_SWITCHES = [];
	STRUCT_SWITCHES = [code(S_SWITCH_LABEL, 
				switch_on_structure(SL, STRUCT_SWITCHES1))]
    ),
%% HBK 10.6.90
    c4_concat_3(TRY_INFO_LIST1, TRY_INFO_LIST2, TRY_INFO_LIST3, TRY_INFO_LIST),
    c4_concat(CONST_SWITCHES, STRUCT_SWITCHES, SWITCH_TERMS).
	
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% HBK 10.6.90
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_get_try_info_list_for_lists(trylist(_, POSITION_LIST), BLOCK_NUMBER,
			       [try(TRY_LABEL, POSITION_LIST)]):-
    c4_make_label(t, BLOCK_NUMBER, l, TRY_LABEL).

c4_get_try_info_list_for_lists(_, _, []).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_make_switch_on_constant(consttable([]), _,  _, [], []).

c4_make_switch_on_constant(oneconst(try(_, _, POSITION_LIST)), BLOCK_NUMBER,
			   _, [try(TRY_LABEL, POSITION_LIST)], []) :-
    c4_make_label(t, BLOCK_NUMBER, c, TRY_LABEL).

c4_make_switch_on_constant(consttable([lonely(CONST_NAME, POSITION)|
					   ENTRY_LIST0]),
			   BLOCK_NUMBER, CURRENT_TRY_NUMBER,
			   TRY_INFO_LIST,
			   [entry(CONST_NAME, CODE_LABEL)|ENTRY_LIST]) :-
    c4_make_label(c, POSITION, '', CODE_LABEL),
    c4_make_switch_on_constant(consttable(ENTRY_LIST0), BLOCK_NUMBER, 
			       CURRENT_TRY_NUMBER, TRY_INFO_LIST, ENTRY_LIST).

c4_make_switch_on_constant(consttable([try(CONST_NAME, _, POSITION_LIST)|
					   ENTRY_LIST0]),
			   BLOCK_NUMBER, CURRENT_TRY_NUMBER,
			   [try(TRY_LABEL, POSITION_LIST)|TRY_INFO_LIST],
			   [entry(CONST_NAME, TRY_LABEL)|ENTRY_LIST]) :-
    c4_make_label(t, BLOCK_NUMBER, c, TRY_LABEL1),
    name(TRY_LABEL1, TRY_LABEL1_CHARS),
    name(CURRENT_TRY_NUMBER, CURRENT_TRY_NUMBER_CHARS),
    c4_concat_3(TRY_LABEL1_CHARS, "_", CURRENT_TRY_NUMBER_CHARS,
		TRY_LABEL_CHARS),
    name(TRY_LABEL, TRY_LABEL_CHARS),
    CURRENT_TRY_NUMBER1 is CURRENT_TRY_NUMBER + 1,
    c4_make_switch_on_constant(consttable(ENTRY_LIST0), BLOCK_NUMBER, 
			       CURRENT_TRY_NUMBER1, TRY_INFO_LIST, ENTRY_LIST).

c4_make_switch_on_constant(_, _, _, [], []).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_make_switch_on_structure(structable([]), _, _, [], []).

c4_make_switch_on_structure(onestruc(try(_, _, _, POSITION_LIST)), 
			    BLOCK_NUMBER, _, [TRY_INFO], []) :-
    c4_make_label(t, BLOCK_NUMBER, s, TRY_LABEL),
    TRY_INFO = try(TRY_LABEL, POSITION_LIST).

c4_make_switch_on_structure(structable([lonely(STRUC_NAME, ARITY, POSITION)|
					    ENTRY_LIST0]),
			    BLOCK_NUMBER, CURRENT_TRY_NUMBER,
			    TRY_INFO_LIST,
			    [entry(/(STRUC_NAME, ARITY), CODE_LABEL)|
				 ENTRY_LIST]) :-
    c4_make_label(c, POSITION, '', CODE_LABEL),
    c4_make_switch_on_structure(structable(ENTRY_LIST0), BLOCK_NUMBER, 
				CURRENT_TRY_NUMBER, TRY_INFO_LIST, ENTRY_LIST).

c4_make_switch_on_structure(structable([try(STRUC_NAME, ARITY, _,
					    POSITION_LIST)|ENTRY_LIST0]),
			    BLOCK_NUMBER, CURRENT_TRY_NUMBER,
			    [try(TRY_LABEL, POSITION_LIST)|TRY_INFO_LIST],
			    [entry(/(STRUC_NAME, ARITY), TRY_LABEL)|
				 ENTRY_LIST]) :-
    c4_make_label(t, BLOCK_NUMBER, s, TRY_LABEL1),
    name(TRY_LABEL1, TRY_LABEL1_CHARS),
    name(CURRENT_TRY_NUMBER, CURRENT_TRY_NUMBER_CHARS),
    c4_concat_3(TRY_LABEL1_CHARS, "_", CURRENT_TRY_NUMBER_CHARS,
		TRY_LABEL_CHARS),
    name(TRY_LABEL, TRY_LABEL_CHARS),
    CURRENT_TRY_NUMBER1 is CURRENT_TRY_NUMBER + 1,
    c4_make_switch_on_structure(structable(ENTRY_LIST0), BLOCK_NUMBER, 
				CURRENT_TRY_NUMBER1,TRY_INFO_LIST,ENTRY_LIST).

c4_make_switch_on_structure(_, _, _, [], []).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_SOWAM_4(+SOWAM_3, -SOWAM_4)                                    
%	This translation step adds the try-, retry- and trust- Sequences
%	to the procedure skeleton.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_SOWAM_4(sowam_3(KIND, ARITY, QUANTITY, STRUCTURE_LIST, TRY_INFO_LISTS, 
			BLOCK_STRENGTHS, BLOCK_QUANTITY, CODEBLOCK_LIST0),
		sowam_4(KIND, ARITY, QUANTITY, STRUCTURE_LIST, _,
			BLOCK_STRENGTHS, BLOCK_QUANTITY, CODEBLOCK_LIST)) :-
    c4_pass_codeblock_list4(STRUCTURE_LIST, KIND, ARITY, TRY_INFO_LISTS, 1, 
			    CODEBLOCK_LIST0, CODEBLOCK_LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_codeblock_list4([], _, _, _, _, _, []).

c4_pass_codeblock_list4([[var(_)]|STRUCTURE_LIST], KIND, ARITY,
			[_|TRY_INFO_LISTS], 
			BLOCK_NUMBER, [CODEBLOCK|CODEBLOCK_LIST0],
			[CODEBLOCK|CODEBLOCK_LIST]) :-
    BLOCK_NUMBER1 is BLOCK_NUMBER + 1,
    c4_pass_codeblock_list4(STRUCTURE_LIST, KIND, ARITY, TRY_INFO_LISTS, 
			    BLOCK_NUMBER1, CODEBLOCK_LIST0, CODEBLOCK_LIST).

c4_pass_codeblock_list4([_|STRUCTURE_LIST], KIND, ARITY,
			[TRY_INFO_LIST|TRY_INFO_LISTS], BLOCK_NUMBER, 
			[CODEBLOCK0|CODEBLOCK_LIST0],
			[CODEBLOCK|CODEBLOCK_LIST]) :-
    c4_pass_try_lists(KIND, ARITY, TRY_INFO_LIST, [], TRY_LISTS),
    c4_concat(CODEBLOCK0, TRY_LISTS, CODEBLOCK),
    BLOCK_NUMBER1 is BLOCK_NUMBER + 1,
    c4_pass_codeblock_list4(STRUCTURE_LIST, KIND, ARITY, TRY_INFO_LISTS, 
			    BLOCK_NUMBER1, CODEBLOCK_LIST0, CODEBLOCK_LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_try_lists(_, _, [], TRY_LIST, TRY_LIST).

c4_pass_try_lists(KIND, ARITY, [try(TRY_LABEL, POSITION_LIST)|TRY_INFO_LIST], 
		  TRY_LIST0, TRY_LIST) :- 
    c4_make_try_list_begin(KIND, TRY_LABEL, ARITY, POSITION_LIST, TRY),
    c4_concat(TRY_LIST0, TRY, TRY_LIST1),
    c4_pass_try_lists(KIND, ARITY, TRY_INFO_LIST, TRY_LIST1, TRY_LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_make_try_list_begin(KIND, TRY_LABEL, ARITY, [POSITION|POSITION_LIST], 
		       [code(TRY_LABEL, TRY)|TRY_LIST]) :-
    c4_make_label(c, POSITION, '', CODE_LABEL),
    c4_redu_or_not(KIND, r_try(CODE_LABEL), try(CODE_LABEL, ARITY), TRY),
    c4_make_try_list(KIND, POSITION_LIST, TRY_LIST).

c4_make_try_list(KIND, [POSITION], [code(nolabel, TRUST)]) :-
    c4_make_label(c, POSITION, '', CODE_LABEL),
    c4_redu_or_not(KIND, r_trust(CODE_LABEL), trust(CODE_LABEL), TRUST).

c4_make_try_list(KIND, [POSITION|POSITION_LIST],
		 [code(nolabel, RETRY)|TRY_LIST]) :-
    c4_make_label(c, POSITION, '', CODE_LABEL),
    c4_redu_or_not(KIND, r_retry(CODE_LABEL), retry(CODE_LABEL), RETRY),
    c4_make_try_list(KIND, POSITION_LIST, TRY_LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_SOWAM_G1(+SOWAM_4, -SOWAM_G)                                    
%	This last translation step adds the inner 
%	- try_me_else,
%	- retry_me_else and
%	- trust_me_else_fail - code
%	to the procedure skeleton.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_SOWAM_G1(sowam_4(KIND, ARITY, QUANTITY, STRUCTURE_LIST, _,
			 BLOCK_STRENGTHS, BLOCK_QUANTITY, CODEBLOCK_LIST0),
		 sowam_G(KIND, ARITY, QUANTITY, STRUCTURE_LIST, _,
			 BLOCK_STRENGTHS, BLOCK_QUANTITY, CODEBLOCK_LIST)) :-
    c4_pass_codeblock_listG(STRUCTURE_LIST, KIND, ARITY, BLOCK_STRENGTHS, 
			    BLOCK_STRENGTHS, 1, CODEBLOCK_LIST0,
			    CODEBLOCK_LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pass_SOWAM_G(+SOWAM_4, -SOWAM_G)                                    
%	This last translation step adds the inner 
%	- try_me_else,
%	- retry_me_else and
%	- trust_me_else_fail - code
%	to the procedure skeleton.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_SOWAM_G(sowam_4(KIND, ARITY, _, STRUCTURE_LIST, _, BLOCK_STRENGTHS, 
			_, CODEBLOCK_LIST0),
		CODEBLOCK_LIST) :-
    c4_pass_codeblock_listG(STRUCTURE_LIST, KIND, ARITY, BLOCK_STRENGTHS, 
			    BLOCK_STRENGTHS, 1, CODEBLOCK_LIST0,
			    CODEBLOCK_LIST1),
    c4_union(CODEBLOCK_LIST1, [], CODEBLOCK_LIST).
			
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_union([], LIST, LIST).
c4_union([CODEBLOCK1|CODEBLOCK_LIST1], CODEBLOCK_LIST, CODELIST) :-
    c4_concat(CODEBLOCK_LIST, CODEBLOCK1, CODELIST1),
    c4_union(CODEBLOCK_LIST1, CODELIST1, CODELIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pass_codeblock_listG([], _, _, _, _, _, _, []).

c4_pass_codeblock_listG([[var(_)]|STRUCTURE_LIST], KIND, ARITY, 
			[_|BLOCK_STRENGTH_LIST], BLOCK_STRENGTHS, 
			BLOCK_NUMBER, [CODEBLOCK|CODEBLOCK_LIST0], 
			[CODEBLOCK|CODEBLOCK_LIST]) :-
    BLOCK_NUMBER1 is BLOCK_NUMBER + 1,
    c4_pass_codeblock_listG(STRUCTURE_LIST, KIND, ARITY, BLOCK_STRENGTH_LIST, 
			    BLOCK_STRENGTHS, BLOCK_NUMBER1,
			    CODEBLOCK_LIST0, CODEBLOCK_LIST).

c4_pass_codeblock_listG([_|STRUCTURE_LIST], KIND, ARITY, 
			[BLOCK_STRENGTH|BLOCK_STRENGTH_LIST], BLOCK_STRENGTHS,
			BLOCK_NUMBER, [CODEBLOCK0|CODEBLOCK_LIST0],
			[CODEBLOCK|CODEBLOCK_LIST]) :-
    BLOCK_NUMBER0 is BLOCK_NUMBER - 1,
    c4_add_first_elements(BLOCK_STRENGTHS, BLOCK_NUMBER0, POSITION),
    POSITION1 is POSITION  + 1,
    c4_make_try_me_else_list_begin(KIND, ARITY, POSITION1, TRY_ME_ELSE_LIST,
				   BLOCK_STRENGTH),
    c4_concat(CODEBLOCK0, TRY_ME_ELSE_LIST, CODEBLOCK),
    BLOCK_NUMBER1 is BLOCK_NUMBER + 1,
    c4_pass_codeblock_listG(STRUCTURE_LIST, KIND, ARITY, 
			    BLOCK_STRENGTH_LIST, BLOCK_STRENGTHS, 
			    BLOCK_NUMBER1, CODEBLOCK_LIST0, CODEBLOCK_LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_make_try_me_else_list_begin(_, _, POSITION,
			       [pseudocode(PSEUDO_CODE_LABEL)], 1) :-
    c4_make_label(c, POSITION, '', PSEUDO_CODE_LABEL).

c4_make_try_me_else_list_begin(_, _, _, [], 0).

c4_make_try_me_else_list_begin(KIND, ARITY, POSITION,
			       [code(CODE_LABEL, TRY_ME_ELSE),
				pseudocode(PSEUDO_CODE_LABEL)|TRY_LIST],
			       CODE_QUANTITY) :-
    POSITION1 is POSITION + 1,
    c4_make_label(c, POSITION, a, CODE_LABEL),
    c4_make_label(c, POSITION1, a, CODE_LABEL1),
    c4_make_label(c, POSITION, '', PSEUDO_CODE_LABEL),
    c4_redu_or_not(KIND, r_try_me_else(CODE_LABEL1),
		   try_me_else(CODE_LABEL1, ARITY), TRY_ME_ELSE),
    CODE_QUANTITY_1 is CODE_QUANTITY - 1,
    c4_make_try_me_else_list(KIND, POSITION1, TRY_LIST, CODE_QUANTITY_1).

c4_make_try_me_else_list(KIND, POSITION,
			 [code(CODE_LABEL, TRUST_ME_ELSE_FAIL),
			  pseudocode(PSEUDO_CODE_LABEL)], 1) :-
    c4_make_label(c, POSITION, a, CODE_LABEL),
    c4_make_label(c, POSITION, '', PSEUDO_CODE_LABEL),
    c4_redu_or_not(KIND, r_trust_me_else_fail, trust_me_else_fail,
		   TRUST_ME_ELSE_FAIL).

c4_make_try_me_else_list(KIND, POSITION,
			 [code(CODE_LABEL, RETRY_ME_ELSE),
			  pseudocode(PSEUDO_CODE_LABEL)|TRY_LIST],
			 CODE_QUANTITY) :-
    POSITION1 is POSITION + 1,
    c4_make_label(c, POSITION, a, CODE_LABEL),
    c4_make_label(c, POSITION1, a, CODE_LABEL1),
    c4_make_label(c, POSITION, '', PSEUDO_CODE_LABEL),
    c4_redu_or_not(KIND, r_retry_me_else(CODE_LABEL1),
		   retry_me_else(CODE_LABEL1), RETRY_ME_ELSE),
    CODE_QUANTITY_1 is CODE_QUANTITY - 1,
    c4_make_try_me_else_list(KIND, POSITION1, TRY_LIST, CODE_QUANTITY_1).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_redu_or_not(+KIND, +CODE_REDU, +CODE_NOT_REDU, -CODE)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_redu_or_not(redu, CODE, _, CODE).
c4_redu_or_not(_, _, CODE, CODE).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_print_result(+SOWAM_G)                                              
% SOWAM_G
% print result of translation                                         
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_print_result(SOWAM_G) :-
    format('~n~n*****************************************', []),
    format('~n* result of information collecting step:*', []),
    format('~n*****************************************~n', []),
    c4_print_information(SOWAM_G),
    format('~n~n**********************************************************',
	   []),
    format('~n* result of translation in normal form (interface-form): *', []),
    format('~n**********************************************************', []),
    c4_print_result_in_normal_form(SOWAM_G),
    format('~n~n***************************************', []),
    format('~n* result of translation in neat form: *', []),
    format('~n***************************************', []),
    c4_print_result_in_neat_form(SOWAM_G),
    format('~n**************************', []).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_print_information(sowam_G(KIND, ARITY, QUANTITY, STRUCTUREBLOCK, _,
			     BLOCKTHICKNESS_LIST, BLOCKQUANTITY, _)) :-
    format('~nKind:     ~a ',    KIND),
    format('~nArity:    ~d ',    ARITY),
    format('~nQuantity: ~d ', QUANTITY),
    format('~nBlockstrenght_list: ', []),
    write(BLOCKTHICKNESS_LIST),
    format('~nBlockquantity:       ~d', BLOCKQUANTITY),
    format('~n~n***********BLOCK-INFORMATION:************~n', []),
    c4_write_structblock(STRUCTUREBLOCK),
    format('~n*****************************************', []).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_print_result_in_normal_form(sowam_G(_,_,_,_,_,_,_,CODEBLOCK_LIST)) :-
    c4_write_codeblock_list(CODEBLOCK_LIST),
    format('~n**************************', []).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_print_result_in_neat_form(sowam_G(_,_,_,_,_,_,_,CODEBLOCK_LIST)) :-
    c4_write_codeblock_list_neat(CODEBLOCK_LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_write_structblock                                                
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_write_structblock([]).
c4_write_structblock([[var(X)]|T]) :-
    nl,
    write('['),
    write(var(X)),
    nl,
    write(']'),
    nl,
    c4_write_structblock(T).
c4_write_structblock([block(C,S,L)|T]) :-
    nl,
    write('['),
    write('block('),
    nl,
    write('   '),write(C),write(','),
    nl,
    write('   '),write(S),write(','),
    nl,
    write('   '),write(L),
    nl,
    write(')]'),
    nl,
    c4_write_structblock(T).
	
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_write_codeblock_list_neat                                                
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_write_codeblock_list_neat([]).
c4_write_codeblock_list_neat([CODE_LIST|T]) :-
    c4_write_list_neat(CODE_LIST),
    nl,
    c4_write_codeblock_list_neat(T).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_write_list_neat                                                     
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_write_list_neat([]).

c4_write_list_neat([code(nolabel, CODE)|T]) :-
    (
	CODE = retry(_)
      | CODE = r_retry(_)
      | CODE = trust(_)
      | CODE = r_trust(_)
    ),
    format('~n          ~w', CODE),
    c4_write_list_neat(T).

c4_write_list_neat([code(nolabel, CODE)|T]) :-
    format('~n~w', CODE),
    c4_write_list_neat(T).

c4_write_list_neat([code(LABEL, JUMP)|T]) :-
    name(LABEL, [99|_]),           % 99 is ASCII-code for c
    format('~n    ~w   ~w', [LABEL, JUMP]),
    c4_write_list_neat(T).

c4_write_list_neat([code(LABEL, JUMP)|T]) :-
    name(LABEL, [116|_]),           % 116 is ASCII-code for t
    format('~n    ~w   ~w', [LABEL, JUMP]),
    c4_write_list_neat(T).

c4_write_list_neat([code(LABEL, CODE)|T]) :-
    (
	CODE = switch_on_structure(_, LIST)
      | CODE = switch_on_constant(_, LIST)
    ),
    functor(CODE, FUNCTOR, _),
    format('~n ~w    ~w', [LABEL, FUNCTOR]),
    c4_write_structure_list(LIST),
    c4_write_list_neat(T).

c4_write_list_neat([code(LABEL, JUMP)|T]) :-
    name(LABEL, [98|_]),           % 98 is ASCII-code for b
    format('~n ~w   ~w', [LABEL, JUMP]),
    c4_write_list_neat(T).

c4_write_list_neat([pseudocode(LABEL)|T]) :-
    format('~n            ~w  pseudocode', LABEL),
    c4_write_list_neat(T).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_write_structure_list                                                     
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_write_structure_list([]).
c4_write_structure_list([H|T]) :-
    format('~n                         ~w', H),
    c4_write_structure_list(T).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_write_codeblock_list                                                
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_write_codeblock_list([]).
c4_write_codeblock_list([CODE_LIST|T]) :-
    c4_write_list(CODE_LIST),
    c4_write_codeblock_list(T).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_write_list                                                     
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_write_list([]).
c4_write_list([H|T]) :-
    format('~n ~w', H),
    c4_write_list(T).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_pause                                                     
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_pause :- 
    prompt(_, '==> '),
    nl,
    nl,
    write('... please type c. + RETURN to continue ...'),
    nl,
    c4_backtrack,
    read(c).

c4_backtrack.
c4_backtrack :- c4_backtrack.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_first(+LIST0, +K, -LIST)                                            
% c4_get the first K elements of LIST0                                   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_first(_, 0, []).
c4_first([H|T], K0, [H|LIST0]) :- 
    K is K0-1,
    c4_first(T, K, LIST0).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_last(+LIST0, -E)                                                    
% c4_get the c4_last element of LIST0                                       
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_last([E],E).
c4_last([_|T], E) :-
    c4_last(T, E).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_last(+LIST0, +K, -LIST)                                             
% c4_get the c4_last K elements of LIST0                                    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_last(LIST0, K, LIST0) :-
    length(LIST0, K).
c4_last([_|T], K, LIST) :-
    c4_last(T, K, LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_split(+LIST0, +K, -FIRST_LIST, -SECOND_LIST)                        
% c4_split LIST0 into two lists, the second beginning with the Kth       
% element of LIST0                                                    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_split(LIST0, K0, FIRST_LIST, SECOND_LIST) :-
    length(LIST0, LENGTH),
    K0 =< LENGTH,
    K1 is K0-1,
    c4_first(LIST0, K1, FIRST_LIST),
    K2 is LENGTH-K0+1,
    c4_last(LIST0, K2, SECOND_LIST).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_occurences(+LIST, +ELEMENT, -N)                                     
% the number of c4_occurences of ELEMENT in LIST is N                    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_occurences([], _, 0).
c4_occurences([ELEMENT|T], ELEMENT, N) :-
    c4_occurences(T, ELEMENT, N1),
    N is N1+1.
c4_occurences([_|T], ELEMENT, N) :-
    c4_occurences(T, ELEMENT, N).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_position_list(+LIST0, +ELEMENT, -POSITION_LIST)                     
% c4_get the POSITION_LIST of all c4_occurences of ELEMENT in LIST0         
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_position_list(LIST0, ELEMENT, POSITION_LIST) :-
    c4_p_list(LIST0, ELEMENT, POSITION_LIST, 1).

c4_p_list([], _, [], _).
c4_p_list([ELEMENT|LIST0], ELEMENT, [POSITION0|POSITION_LIST], POSITION0) :-
    POSITION is POSITION0+1,
    c4_p_list(LIST0, ELEMENT, POSITION_LIST, POSITION).
c4_p_list([_|LIST0], ELEMENT, POSITION_LIST, POSITION0) :-
    POSITION is POSITION0+1,
    c4_p_list(LIST0, ELEMENT, POSITION_LIST, POSITION).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_first_position(+LIST0, +ELEMENT, -POSITION)                         
% c4_get the POSITION of the first occurence of ELEMENT in LIST0         
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_first_position([ELEMENT|_], ELEMENT, 1).
c4_first_position([_|LIST], ELEMENT, POSITION) :-
    c4_is_in(LIST, ELEMENT),
    c4_first_position(LIST, ELEMENT, POSITION1),
    POSITION is POSITION1+1,
    !.
c4_first_position(_, _, 0).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_get_element(+LIST0, +K, -ELEMENT)                                   
% c4_get the K-th element of LIST0                                       
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_get_element([ELEMENT|_], 1, ELEMENT).
c4_get_element([_|LIST0], K0, ELEMENT) :-
    K is K0-1,
    c4_get_element(LIST0, K, ELEMENT).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_delete_element(+LIST0, +ELEMENT, -LIST)                             
% LIST is LIST0 without any occurence of ELEMENT                      
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_delete_element([], _, []).
c4_delete_element([ELEMENT|T], ELEMENT, LIST) :-
    c4_delete_element(T, ELEMENT, LIST).
c4_delete_element([H|T], ELEMENT, [H|LIST]) :-
    c4_delete_element(T, ELEMENT, LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_is_in(+LIST0, +ELEMENT)                                             
% test wether ELEMENT is member of LIST0 or not                       
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_is_in([ELEMENT|_], ELEMENT).
c4_is_in([_|LIST], ELEMENT) :-
    c4_is_in(LIST, ELEMENT).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_hang_on(?LIST0, ?E, ?LIST)                                          
% hang element E on end of list LIST0                                 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_hang_on([], E, [E]).
c4_hang_on([H|T], E, [H|TE]) :-
    c4_hang_on(T, E, TE).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_concat_3(?LIST1, ?LIST2, ?LIST3, ?LIST)
% c4_concat_3 concats three lists, result is LIST
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_concat_3(L1, L2, L3, LIST) :-
    c4_concat(L1, L2, L12),
    c4_concat(L12, L3, LIST).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% c4_concat(?LIST1, ?LIST2, ?LIST)
% c4_concat LIST1 and LIST2, result is LIST                                
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c4_concat([], LIST2, LIST2).
c4_concat([H|T], LIST2, [H|LIST]) :-
    c4_concat(T, LIST2, LIST).
