%:-ensure_loaded(vars).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FLATABSY   flat-ALF-Prog in abstrakte Syntax umwandeln   Schwider 31.05.90
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Aenderungen:
%
% 13.09.90	Andreas Schwab
%		beliebige Reihenfolge der Deklarationen
%
% 14.10.90	Andreas Schwab
%		0 wird in '0' umgewandelt
%
% 04.02.91	Andreas Schwab
%		Zahlen werden in fNumber(Zahl) umgewandelt
%
% 22.02.91	Andreas Schwab
%		Neues konkrete Syntax:
%		pred, func, ... steht einzeln, danach als einzelne Terme
%		die Regeln.
%		Altes Format wird noch unterstuetzt
%

% Uebereifer von QProlog daempfen
:- dynamic pIsCons/2, pIsFunc/2, pIsPred/2.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% +FlatName... Name der Datei (ohne Endung) eines flat-ALF-Programms, die
%              eingelesen werden soll.
% -FlatProg... Abstrakte Syntax des flat-ALF-Programms.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ff(FlatName,FlatProg) :- readFlatAbsy(FlatName,FlatProg).

readFlatAbsy(FlatName,FlatProg) :-
    seen,
    retractall(pIsCons(_,_)),
    retractall(pIsFunc(_,_)),
    retractall(pIsPred(_,_)),
    readFlatAbsy2(FlatName,FlatProg).
readFlatAbsy2(user,FlatProg) :-
    !,pFlatOpsOn,
    pReadFlatAbsy(Decl,Rules,Redus),
    pFlatOpsOff,
    FlatProg = fProg(Decl,Rules,Redus,fGoal([fPredAppl('_goal',[])])).
readFlatAbsy2(Name,FlatProg) :-
    name(Name,NameL),            % Dateinamen bilden durch...
    pAppnd(NameL,".fal",DateiL), % ...anhaengen von '.fal'!
    name(Datei,DateiL),
    see(Datei),
    pFlatOpsOn,
    pReadFlatAbsy(Decl,Rules,Redus),!,
    pFlatOpsOff,
    FlatProg = fProg(Decl,Rules,Redus,fGoal([fPredAppl('_goal',[])])),
    seen.
readFlatAbsy2(_,_) :-
    write('*** Was soll der Quatsch?'),
    pfAbort.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% flat-ALF-Operatoren ein- bzw. ausschalten:

pFlatOpsOn :-
    op(1199,fx,pred),
    op(1199,fx,cons),
    op(1199,fx,func),
    op(1199,fx,total),
    op(1199,fx,rules),
    op(1199,fx,redus),
    op(1199,fx,goals),
    op(1099,xfx,(:-)),
    op(1097,xfx,infixleft),
    op(1097,xfx,infixright),
    op(1097,xfx,infixnot),
    op(1097,xfx,prefix),
    op(1097,xfx,postfix),
    op(1097,xf,infixleft),
    op(1097,xf,infixright),
    op(1097,xf,infixnot),
    op(1097,xf,prefix),
    op(1097,xf,postfix).

pFlatOpsOff :-
    op(0,fx,pred),
    op(0,fx,cons),
    op(0,fx,func),
    op(0,fx,total),
    op(0,fx,rules),
    op(0,fx,redus),
    op(0,fx,goals),
    op(1200,xfx,(:-)),
    op(0,xfx,infixleft),
    op(0,xfx,infixright),
    op(0,xfx,infixnot),
    op(0,xfx,prefix),
    op(0,xfx,postfix),
    op(0,xf,infixleft),
    op(0,xf,infixright),
    op(0,xf,infixnot),
    op(0,xf,prefix),
    op(0,xf,postfix).

pfAbort :-
    nl, pFlatOpsOff, seen, abort.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Die verschiedenen Teile eines flat-ALF-Programms einlesen:
   
pReadFlatAbsy(fDeclare(Pred,Cons,Func,Total),Rules,Redus) :-
    %% Ein flat-ALF-Programm besteht aus (maximal) sieben Termen.
    %% Die Goals jedoch werden als Rules gespeichert...
    read(Term),
    pReadFlat(Term,Pred,Cons2,Func,Total,Rules,Redus),
    pNameVariables(Rules,Redus),
    pAddListCons(Cons2,Cons).
pReadFlatAbsy(_,_,_) :-
    write('*** Totaler Absturz: Abwehrraketen werden sofort gestartet...'),nl,
    write(3),nl,write(2),nl,write(1),nl,
    pfAbort.

pReadFlat(end_of_file,[],[],[],[],[],[]).
%% Neues Dateiformat: 
%% pred, func, ... steht alleine, Regeln sind einzelne Terme
pReadFlat(pred,PredL,ConsL,FuncL,TotalL,RulesL,RedusL) :- !,
    read(Term),
    pSammleTerme(Term, Preds, TermOut),
    pMakePreds(Preds,PredsAbsy),
    pAppnd(PredsAbsy,PredL2,PredL),
    pReadFlat(TermOut,PredL2,ConsL,FuncL,TotalL,RulesL,RedusL).
pReadFlat(cons,PredL,ConsL,FuncL,TotalL,RulesL,RedusL) :- !,
    read(Term),
    pSammleTerme(Term, Cons, TermOut),
    pMakeConss(Cons,ConssAbsy),
    pAppnd(ConssAbsy,ConsL2,ConsL),
    pReadFlat(TermOut,PredL,ConsL2,FuncL,TotalL,RulesL,RedusL).
pReadFlat(func,PredL,ConsL,FuncL,TotalL,RulesL,RedusL) :- !,
    read(Term),
    pSammleTerme(Term, Funcs, TermOut),
    pMakeFuncs(Funcs,FuncsAbsy),
    pAppnd(FuncsAbsy,FuncL2,FuncL),
    pReadFlat(TermOut,PredL,ConsL,FuncL2,TotalL,RulesL,RedusL).
pReadFlat(total,PredL,ConsL,FuncL,TotalL,RulesL,RedusL) :- !,
    read(Term),
    pSammleTerme(Term, Totals, TermOut),
    pMakeFuncs(Totals,TotalsAbsy),
    pAppnd(TotalsAbsy,TotalL2,TotalL),
    pReadFlat(TermOut,PredL,ConsL,FuncL,TotalL2,RulesL,RedusL).
pReadFlat(rules,PredL,ConsL,FuncL,TotalL,RulesL,RedusL) :- !,
    read(Term),
    pSammleTerme(Term, Rules, TermOut),
    pMakeRules(Rules,RulesAbsy),
    pAppnd(RulesAbsy,RulesL2,RulesL),
    pReadFlat(TermOut,PredL,ConsL,FuncL,TotalL,RulesL2,RedusL).
pReadFlat(redus,PredL,ConsL,FuncL,TotalL,RulesL,RedusL) :- !,
    read(Term),
    pSammleTerme(Term, Redus, TermOut),
    pMakeRedus(Redus,RedusAbsy),
    pAppnd(RedusAbsy,RedusL2,RedusL),
    pReadFlat(TermOut,PredL,ConsL,FuncL,TotalL,RulesL,RedusL2).
pReadFlat(goals,PredL,ConsL,FuncL,TotalL,RulesL,RedusL) :- !,
    read(Term),
    pSammleTerme(Term, Goals, TermOut),
    pMakeGoals(Goals,GoalsAbsy),
    pAppnd(GoalsAbsy,RulesL2,RulesL),
    pReadFlat(TermOut,PredL,ConsL,FuncL,TotalL,RulesL2,RedusL).

%% Altes Dateiformat
pReadFlat(pred(Preds),PredL,ConsL,FuncL,TotalL,RulesL,RedusL) :- !,
    pMakePreds(Preds,PredsAbsy),
    pAppnd(PredsAbsy,PredL2,PredL),
    read(Term),
    pReadFlat(Term,PredL2,ConsL,FuncL,TotalL,RulesL,RedusL).
pReadFlat(cons(Cons),PredL,ConsL,FuncL,TotalL,RulesL,RedusL) :- !,
    pMakeConss(Cons,ConssAbsy),
    pAppnd(ConssAbsy,ConsL2,ConsL),
    read(Term),
    pReadFlat(Term,PredL,ConsL2,FuncL,TotalL,RulesL,RedusL).
pReadFlat(func(Funcs),PredL,ConsL,FuncL,TotalL,RulesL,RedusL) :- !,
    pMakeFuncs(Funcs,FuncsAbsy),
    pAppnd(FuncsAbsy,FuncL2,FuncL),
    read(Term),
    pReadFlat(Term,PredL,ConsL,FuncL2,TotalL,RulesL,RedusL).
pReadFlat(total(Totals),PredL,ConsL,FuncL,TotalL,RulesL,RedusL) :- !,
    pMakeFuncs(Totals,TotalsAbsy),
    pAppnd(TotalsAbsy,TotalL2,TotalL),
    read(Term),
    pReadFlat(Term,PredL,ConsL,FuncL,TotalL2,RulesL,RedusL).
pReadFlat(rules(Rules),PredL,ConsL,FuncL,TotalL,RulesL,RedusL) :- !,
    pMakeRules(Rules,RulesAbsy),
    pAppnd(RulesAbsy,RulesL2,RulesL),
    read(Term),
    pReadFlat(Term,PredL,ConsL,FuncL,TotalL,RulesL2,RedusL).
pReadFlat(redus(Redus),PredL,ConsL,FuncL,TotalL,RulesL,RedusL) :- !,
    pMakeRedus(Redus,RedusAbsy),
    pAppnd(RedusAbsy,RedusL2,RedusL),
    read(Term),
    pReadFlat(Term,PredL,ConsL,FuncL,TotalL,RulesL,RedusL2).
pReadFlat(goals(Goals),PredL,ConsL,FuncL,TotalL,RulesL,RedusL) :- !,
    pMakeGoals(Goals,GoalsAbsy),
    pAppnd(GoalsAbsy,RulesL2,RulesL),
    read(Term),
    pReadFlat(Term,PredL,ConsL,FuncL,TotalL,RulesL2,RedusL).

pAddListCons(Cons2,Cons) :-
    Cons = [fFuncDecl([],0,parameter,-1),
	    fFuncDecl('.',2,parameter,-1)|Cons2].

pSammleTerme(end_of_file, [], end_of_file).
pSammleTerme(pred, [], pred).
pSammleTerme(cons, [], cons).
pSammleTerme(func, [], func).
pSammleTerme(total, [], total).
pSammleTerme(rules, [], rules).
pSammleTerme(redus, [], redus).
pSammleTerme(goals, [], goals).
pSammleTerme(Term, [Term|Rest], TermOut) :-
    read(TermIn),
    pSammleTerme(TermIn, Rest, TermOut).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Variablen an 'variableNNN' binden.

pNameVariables(Rules,Redus) :-
    pNameVariables(Rules),
    pNameVariables(Redus).

pNameVariables([]).
pNameVariables([fFuncRule(Links,Rechts,Cond)|RestAbsy]) :-
    pNameVarInTerm(Links),
    pNameVarInTerm(Rechts),
    pNameVarInTermList(Cond),
    pNameVariables(RestAbsy).
pNameVariables([fFuncRedu(Links,Rechts,Cond)|RestAbsy]) :-
    pNameVarInTerm(Links),
    pNameVarInTerm(Rechts),
    pNameVarInTermList(Cond),
    pNameVariables(RestAbsy).
pNameVariables([fPredRule(Term,Cond)|RestAbsy]) :-
    pNameVarInTerm(Term),
    pNameVarInTermList(Cond),
    pNameVariables(RestAbsy).

pNameVarInTerm(fVar(Var)) :-
    pNameVariable(Var).
pNameVarInTerm(fNumber(_)).
pNameVarInTerm(fConsAppl(_,Terms)) :-
    pNameVarInTermList(Terms).
pNameVarInTerm(fFuncAppl(_,Terms)) :-
    pNameVarInTermList(Terms).
pNameVarInTerm(fPredAppl(_,Terms)) :-
    pNameVarInTermList(Terms).
pNameVarInTerm(fEquation(Links,Rechts)) :-
    pNameVarInTerm(Links),
    pNameVarInTerm(Rechts).

pNameVarInTermList([]).
pNameVarInTermList([Term|Terms]) :-
    pNameVarInTerm(Term),
    pNameVarInTermList(Terms).

pNameVariable(Var) :-
    var(Var), !,
    gensym(variable,Var).
pNameVariable(_).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Den Deklarationsteil in seine abstrakte Syntax umwandeln:

%% Praedikat fuer Praedikat...
pMakePreds([Pred | PredsRest],[PredAbsy|PredsRestAbsy]) :-
    !,
    pMakePred(Pred,PredAbsy),
    pMakePreds(PredsRest,PredsRestAbsy).
pMakePreds([], []).
pMakePreds((Pred; PredsRest),[PredAbsy|PredsRestAbsy]) :-
    !,
    pMakePred(Pred,PredAbsy),
    pMakePreds(PredsRest,PredsRestAbsy).
%% Nur (noch) ein Praedikat vorhanden:
pMakePreds(Pred,[PredAbsy]) :- 
    pMakePred(Pred,PredAbsy).
   
%% Kein OpType:
pMakePred((IName/Arity),fPredDecl(Name,Arity,'parameter')) :-
    pCheckName(IName,Name),
    !,
    assert(pIsPred(Name,Arity)).
%% Ah, ein Operator:
pMakePred(Pred,fPredDecl(Name,Arity,OpType)) :-
    Pred =.. [OpType,(IName/Arity)],
    pCheckName(IName,Name),
    !,
    assert(pIsPred(Name,Arity)),
    pMakeOperator(Name,OpType,700).	% precedence of '=' (MH)
pMakePred(Pred,_) :-
    write('*** Praedikat-Deklaration <'),writeq(Pred),
    write('> ???'),pfAbort.

%% Konstruktor fuer Konstruktor...
pMakeConss([Cons|ConssRest],[ConsAbsy|ConssRestAbsy]) :-
    !,
    pMakeCons(Cons,ConsAbsy),
    pMakeConss(ConssRest,ConssRestAbsy).
pMakeConss([], []).
pMakeConss((Cons;ConssRest),[ConsAbsy|ConssRestAbsy]) :-
    !,
    pMakeCons(Cons,ConsAbsy),
    pMakeConss(ConssRest,ConssRestAbsy).
%% Oh, nur (noch) ein Konstruktor da:
pMakeConss(Cons,[ConsAbsy]) :-
    pMakeCons(Cons,ConsAbsy).

%% Kein OpType:
pMakeCons((IName/Arity),fFuncDecl(Name,Arity,'parameter',-1)) :-
    pCheckName(IName,Name),
    !,
    assert(pIsCons(Name,Arity)). % Merken, dass es ein Konstruktor ist.
%% Ein Operator:
pMakeCons(Cons,fFuncDecl(Name,Arity,OpType,Precedence)) :-
    Cons =.. [OpType,(IName/Arity),Precedence],
    pCheckName(IName,Name),
    !,
    assert(pIsCons(Name,Arity)), % Merken, dass es ein Konstruktor ist.
    pMakeOperator(Name,OpType,Precedence).
pMakeCons(Cons,_) :-
    write('*** Konstruktor-Deklaration <'),writeq(Cons),
    write('> ???'),pfAbort.

%% Funktion fuer Funktion...
pMakeFuncs([Func|FuncsRest],[FuncAbsy|FuncsRestAbsy]) :-
    !,
    pMakeFunc(Func,FuncAbsy),
    pMakeFuncs(FuncsRest,FuncsRestAbsy).
pMakeFuncs([], []).
pMakeFuncs((Func;FuncsRest),[FuncAbsy|FuncsRestAbsy]) :-
    !,
    pMakeFunc(Func,FuncAbsy),
    pMakeFuncs(FuncsRest,FuncsRestAbsy).
%% Oh, nur (noch) eine Funktion da:
pMakeFuncs(Func,[FuncAbsy]) :-
    pMakeFunc(Func,FuncAbsy).

%% Kein OpType:
pMakeFunc((IName/Arity),fFuncDecl(Name,Arity,'parameter',-1)) :-
    pCheckName(IName,Name),
    !,
    assert(pIsFunc(Name,Arity)).
%% Ein Operator:
pMakeFunc(Func,fFuncDecl(Name,Arity,OpType,Precedence)) :-
    Func =.. [OpType,(IName/Arity),Precedence],
    pCheckName(IName,Name),
    !,
    assert(pIsFunc(Name,Arity)),
    pMakeOperator(Name,OpType,Precedence).
pMakeFunc(Func,_) :-
    write('*** Funktion-Deklaration <'),writeq(Func),
    write('> ???'),pfAbort.

pMakeOperator(Name,'infixleft', Prec) :- op(Prec,yfx,Name). % flat-ALF-Ops
pMakeOperator(Name,'infixright',Prec) :- op(Prec,xfy,Name). % als Prolog-Ops
pMakeOperator(Name,'infixnot',  Prec) :- op(Prec,xfx,Name). % definieren.
pMakeOperator(Name,'prefix',    Prec) :- op(Prec,fy, Name).
pMakeOperator(Name,'postfix',   Prec) :- op(Prec,yf, Name).
pMakeOperator(Name,Typ,_) :-
    write('*** Deklaration von <'),writeq(Name),
    write('>: OpTyp <'),write(Typ),
    write('> gibt es nicht!'),pfAbort.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Die flat-ALF-Regeln in ihre abstrakte Syntax umwandeln:

%% Regel fuer Regel...
pMakeRules([Rule|RulesRest],[RuleAbsy|RulesRestAbsy]) :-
    !,
    pMakeRule(Rule,RuleAbsy),
    pMakeRules(RulesRest,RulesRestAbsy).
pMakeRules([], []).
pMakeRules((Rule;RulesRest),[RuleAbsy|RulesRestAbsy]) :-
    !,
    pMakeRule(Rule,RuleAbsy),
    pMakeRules(RulesRest,RulesRestAbsy).
%% Nur (noch) eine Regel:
pMakeRules(Rule,[RuleAbsy]) :-
    pMakeRule(Rule,RuleAbsy).
   
%% Hat die Regel eine Bedingung?
pMakeRule((Lit:-Condition),RuleAbsy) :-
    !,
    pMakeLiterals(Condition,ConditionAbsy),
    pMakeRule(Lit,ConditionAbsy,RuleAbsy).
%% Keine Bedingung:
pMakeRule(Rule,RuleAbsy) :-
    pMakeRule(Rule,[],RuleAbsy).
   
%% Ist es eine Funktionsregel...
pMakeRule((Links=Rechts),CondAbsy,fFuncRule(LinksAbsy,RechtsAbsy,CondAbsy)) :-
    !,
    pMakeTerm(Links,LinksAbsy),
    pMakeTerm(Rechts,RechtsAbsy).
%% ...oder eine Praedikatsregel?
pMakeRule(Literal,CondAbsy,fPredRule(LiteralAbsy,CondAbsy)) :-
    pMakeLiteral(Literal,LiteralAbsy).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Die Reduktionsregeln umwandeln:

%% Redu-Regel fuer Redu-Regel...
pMakeRedus([Redu|RedusRest],[ReduAbsy|RedusRestAbsy]) :-
    !,
    pMakeRedu(Redu,ReduAbsy),
    pMakeRedus(RedusRest,RedusRestAbsy).
pMakeRedus([], []).
pMakeRedus((Redu;RedusRest),[ReduAbsy|RedusRestAbsy]) :-
    !,
    pMakeRedu(Redu,ReduAbsy),
    pMakeRedus(RedusRest,RedusRestAbsy).
%% Nur (noch) eine Reduktionsregel:
pMakeRedus(Redu,[ReduAbsy]) :-
    pMakeRedu(Redu,ReduAbsy).
   
%% Gibt es eine Bedingung fuer die Reduktionsregel?
pMakeRedu((Lit :- Condition),ReduAbsy) :-
    !,
    pMakeLiterals(Condition,ConditionAbsy),
    pMakeRedu(Lit,ConditionAbsy,ReduAbsy).
%% Keine Bedingung:
pMakeRedu(Redu,ReduAbsy) :-
    pMakeRedu(Redu,[],ReduAbsy).
   
%% Reduktionsregeln sind immer Gleichungen:
pMakeRedu((Links=Rechts),CondAbsy,fFuncRedu(LinksAbsy,RechtsAbsy,CondAbsy)) :-
    !,
    pMakeTerm(Links,LinksAbsy),
    pMakeTerm(Rechts,RechtsAbsy).
pMakeRedu(_,_,_) :-
    write('*** Fehler im Reduktionsteil: Keine Gleichung!'),
    pfAbort.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Die flat-ALF-Goals in ihre abstrakte Syntax umwandeln:

%% Goal fuer Goal...
pMakeGoals([Goal|GoalsRest],[GoalAbsy|GoalsRestAbsy]) :-
    !,
    pMakeGoal(Goal,GoalAbsy),
    pMakeGoals(GoalsRest,GoalsRestAbsy).
pMakeGoals([], []).
pMakeGoals((Goal;GoalsRest),[GoalAbsy|GoalsRestAbsy]) :-
    !,
    pMakeGoal(Goal,GoalAbsy),
    pMakeGoals(GoalsRest,GoalsRestAbsy).
%% Nur (noch) ein Goal vorhanden:
pMakeGoals(Goal,[GoalAbsy]) :-
    pMakeGoal(Goal,GoalAbsy).

%% "Goal" in "_goal :- Goal,write_and_ask(Goal)" umwandeln:
pMakeGoal(Goal,fPredRule(fPredAppl('_goal',[]),NewGoalAbsy)) :-
    pMakeLiterals(Goal,GoalAbsy), % Ein Goal ist eine Folge von Literalen.
    pAppnd(GoalAbsy,[fPredAppl('write_and_ask',GoalAbsy)],NewGoalAbsy).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Die Literale in ihre abstrakte Syntax umwandeln:
   
%% Literal fuer Literal...
pMakeLiterals((Lit,LitsRest),[LitAbsy|LitsRestAbsy]) :-
    !,
    pMakeLiteral(Lit,LitAbsy),
    pMakeLiterals(LitsRest,LitsRestAbsy).
%% Nur noch ein Literal uebrig:
pMakeLiterals(Lit,[LitAbsy]) :-
    pMakeLiteral(Lit,LitAbsy).
   
%% Gleichung...
pMakeLiteral((Links=Rechts),fEquation(LinksAbsy,RechtsAbsy)) :-
    !,
    pMakeTerm(Links,LinksAbsy),
    pMakeTerm(Rechts,RechtsAbsy).
%% ...oder Praedikat?
pMakeLiteral(Literal,fPredAppl(Name,TermsAbsy)) :-
    Literal =.. [IName|Terms],
    pCheckName(IName,Name),
    length(Terms,Arity),
    pIsPred(Name,Arity),!,
    pMakeTerms(Terms,TermsAbsy).
pMakeLiteral(Literal,_) :-
    Literal =.. [IName|Terms],
    pCheckName(IName,Name),
    length(Terms,Arity),
    write('*** Praedikat <'),writeq(Name/Arity),
    write('> ist undefiniert!'),pfAbort.
pMakeLiteral(_,_) :-
    write('*** Allgemeiner Fehler eines Literals! Syntax?'),
    pfAbort.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Die Terme umwandeln:
   
%% Sind keine Terme (mehr) vorhanden?
pMakeTerms([],[]) :- !.
%% Term fuer Term...
pMakeTerms([Term|TermsRest],[TermAbsy|TermsRestAbsy]) :-
    pMakeTerm(Term,TermAbsy),
    pMakeTerms(TermsRest,TermsRestAbsy).
   
%% Ein Term ist entweder eine Variable, ...
pMakeTerm(Term,fVar(Term)) :-
    var(Term), !.
%% ...eine Zahl... (as)
pMakeTerm(Number,fNumber(Number)) :-
    integer(Number),!.
%% ...ein Konstruktoraufruf...
pMakeTerm(Term,fConsAppl(Name,TermsAbsy)) :-
    Term =.. [IName|Terms],
    pCheckName(IName,Name),
    length(Terms,Arity),pIsCons(Name,Arity),!,
    pMakeTerms(Terms,TermsAbsy).
%% ...oder ein Funktionsaufruf.
pMakeTerm(Term,fFuncAppl(Name,TermsAbsy)) :-
    Term =.. [IName|Terms],
    pCheckName(IName,Name),
    length(Terms,Arity),pIsFunc(Name,Arity),!,
    pMakeTerms(Terms,TermsAbsy).
%% ...leere Liste undefiniert?
pMakeTerm([],fConsAppl('[]',[])) :-
    assert( pIsCons('[]',0) ),!,
    write('*   ACHTUNG! Leere Liste war nicht definiert!'),nl.
%% ...Punkt-Operator undefiniert?
pMakeTerm(Term,fConsAppl('.',TermsAbsy)) :-
    Term = .(T1,T2),
    assert( pIsCons('.',2) ),!,
    pMakeTerms([T1,T2],TermsAbsy),
    write('*   ACHTUNG! Punkt-Operator war undefiniert!'),nl.
pMakeTerm(Term,_) :-
    Term =.. [IName|Terms],
    pCheckName(IName,Name),
    length(Terms,Arity),
    write('*** Operator <'),writeq(Name/Arity),
    write('> ist undefiniert!'),pfAbort.
pMakeTerm(_,_) :-
    write('*** Allgemeiner Fehler eines Terms! Syntax?'),
    pfAbort.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% GENERAL'              Allgemeiner Kleinkram              Schwider 15.05.90
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

pAppnd([],L,L) :- !.
pAppnd([E|R],L,[E|RL]) :- pAppnd(R,L,RL).

%% Nullen sind hier nicht gefragt ... (as)
pCheckName(0,'0') :- !.
pCheckName(Name,Name) :-
    atom(Name),!.

