%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%    Uebersetzer3 von abstrakter SOWAM - Syntax in konkrete SOWAM - Syntax    %
%                                                                             %
%-----------------------------------------------------------------------------%
%                                                                             %
%    autor            : Stephan Alker                                         %
%                                                                             %
%    version          : 1.0                                                   %
%                                                                             %
%    letzte Aenderung : 13.06.90                                              %
%                                                                             %
%-----------------------------------------------------------------------------%
%                                                                             %
%  Beschreibung :                                                             %
%                                                                             %
%  Bei diesem Programm handelt es sich um die Realisierung der Ruecktransfor- %
%  mation eines in abstrakte Syntax ueberfuehrten SOWAM - Quellcodes in seine %
%  urspruengliche Form (d.h. in konkrete SOWAM - Syntax).                     %
%  Es ist zu beachten, dass es sich nicht um ein eigenstaendig ausfuehrbares  %
%  Programm handelt als vielmehr um ein einzubindenes Praedikat.              %
%  Der Aufruf erfolgt ueber das dreistellige Praedikat :                      %
%                                                                             %
%                  absy_to-sowam(Code,Mainlist,FileOut).                      %
%                                                                             %
%  Code : Liste der SOWAM - Instruktionen in abstrakter Syntax                %
%  Mainlist : aus op_typ(X,Y) generierte Liste von Labeln und Daten           %
%                                                                             %
%  Bei beiden Parametern handelt es sich um das von der SOWAM - Gruppe        %
%  wuenschte Uebergabeformat , wie es auch der Uebersetzer SOWAM_to_AbSy re - %
%  alisiert.                                                                  %
%                                                                             %
%  FileOut beschreibt die Ausgabedatei, in die der regenerierte SOWAM - Code  %
%  geschrieben wird. Der Inhalt des Files ist die urspruengliche Form eines   %
%  SOWAM - Programms.                                                         %
%  ANMERKUNG :                                                                %
%  FileOut sollte ohne Suffix '.sow' eingegeben werden, da das Anhaengen der  %
%  Endung vom Programm her realisiert wird.                                   %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%                               Grundprozeduren                               %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

		       
c3_concatenate([],List,List).
c3_concatenate([First|Restlist1],List2,[First|Restlist2]) :-
    c3_concatenate(Restlist1,List2,Restlist2).


c3_append([],E,[E]).
c3_append([Kopf|Rest],E,[Kopf|RestundE]) :- c3_append(Rest,E,RestundE).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



c3_absy_to_sowam(Code, Mainlist, FileOut) :- 
    c3_generate_labellist(Mainlist,Labellist),
    c3_code_transformation(Code,Labellist,Codelist),
    c3_oplist_transformation(Mainlist,Oplist),
    c3_concatenate(Oplist,Codelist,Sowamprogram),
    c3_write_sowamprogram(FileOut,Sowamprogram),
    !.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%           Entwicklung einer Labelliste aus uebergebener Mainliste           %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%  generate_labellist entwickelt aus uebergebener Mainlist eine Labelliste,   %
%  die zur spaeteren Regenerierung des Codes notwendig ist.                   %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

c3_generate_labellist([],[]).
c3_generate_labellist([Head|Rest],Labellist) :- 
    c3_transform_first(Head,LocalLablist),
    c3_concatenate(LocalLablist,RestLablist,Labellist),
    c3_generate_labellist(Rest,RestLablist).


c3_transform_first(entry(A,func(L1, L2),_,_),
		   [labinput(L1,func(A)),labinput(L2,redu(A))]).
c3_transform_first(entry(A,pred(L1),_,_),[labinput(L1, pred(A))]).
c3_transform_first(_,[]).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%          Regenerierung des SOWAM-Codes aus uebergebener Codeliste           %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%  Durch das Praedikat code_transfromation wird eine Vereinigung des eigent-  %
%  lichen Codes und der generierten Labelliste erreicht sowie die Ueberfueh - %
%  rung des in konkrete Syntax  aus abstrakter Syntax.                        %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


c3_code_transformation([],_,[]).
c3_code_transformation([Head|Restcode],Labellist,Codelist) :-
    c3_get_inslist(Head,Labellist,LocalCodelist),
    c3_code_transformation(Restcode,Labellist,RestCodelist),
    c3_concatenate(LocalCodelist,RestCodelist,Codelist).


c3_get_inslist([],_,_).
c3_get_inslist(proc(Label,Instructionlist),Labellist,Codelist) :-
    c3_join_label_with_list(proc(Label,Instructionlist),Labellist,Codelist).


c3_join_label_with_list([],_,_).
c3_join_label_with_list(proc(Label,Instructionlist),Labellist,
			[Labeloutput:Firstelem|Restinlist]) :-
    c3_check_labellist(Label,Labellist,Labeloutput),
    c3_divideup_inslist(Instructionlist,Firstelem,Restinlist),
    !.


c3_check_labellist(_,[],_).
c3_check_labellist(Lab,[labinput(Lab,Y)|_],Y).
c3_check_labellist(Lab,[_|Tail],Output) :- 
    c3_check_labellist(Lab,Tail,Output).


c3_divideup_inslist([],[],[]).
c3_divideup_inslist([First|Rest],First,Rest).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%                           Regenerierung der Oplist                          %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%  Durch oplist_transformation wird der Wiederaufbau der Optyp - Liste vorge- %
%  nommen, wie sie anfangs von der Praeprozessor - Gruppe uebergeben wurde.   %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

c3_oplist_transformation([],[]).
c3_oplist_transformation([Head|Tail],Oplist) :-
    c3_transform_element(Head,LocalOplist),
    c3_oplist_transformation(Tail,Taillist),
    c3_concatenate(LocalOplist,Taillist,Oplist).


c3_transform_element(entry(Decl,_,OpType,Precedence),
		     [op_typ(Decl,OpType,Precedence)]) :-
    !.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%         Ausgabe des regenrierten SOWAM - Programms in eine Datei            %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


c3_write_sowamprogram(FileOut,Sowamprogram) :-
    c3_get_outputfilename(FileOut, DATEI),
    tell(DATEI),
    c3_write_instlist_to_file(Sowamprogram),
    told.


c3_get_outputfilename(FILE, DATEI) :-
    name(FILE, LISTE),
    c3_until_point(LISTE, L),
    c3_concatenate(L, ".sow", LENDUNG),
    name(DATEI,LENDUNG).

c3_until_point([], []).
c3_until_point(".sow", []).
c3_until_point([H|REST], [H|REST2]) :- c3_until_point(REST, REST2).

c3_write_instlist_to_file([]).
c3_write_instlist_to_file([Inst | Tail]) :-
    c3_write_inst_to_file(Inst, nein), nl,
    c3_write_instlist_to_file(Tail).

c3_write_inst_to_file(op_typ(DeclN/Arity,OpType,Precedence), _) :-
    write('op_typ('),
    c3_write_name(DeclN),
    write('/'),
    write(Arity),
    write(', '),
    write(OpType),
    write(', '),
    write(Precedence),
    write(').').
c3_write_inst_to_file(func(Pred/Arity):Inst, _) :-
    nl,
    write('func '),
    c3_write_name(Pred),
    write('/'),
    write(Arity),
    write(':'), nl,
    c3_write_inst_to_file(Inst, nein).
c3_write_inst_to_file(redu(Pred/Arity):Inst, _) :-
    nl,
    write('redu '),
    c3_write_name(Pred),
    write('/'),
    write(Arity),
    write(':'), nl,
    c3_write_inst_to_file(Inst, nein).
c3_write_inst_to_file(pred(Pred/Arity):Inst, _) :-
    nl,
    write('pred '),
    c3_write_name(Pred),
    write('/'),
    write(Arity),
    write(':'), nl,
    c3_write_inst_to_file(Inst, nein).
c3_write_inst_to_file(Label:Inst, _) :-
    c3_write_label(Label),
    write(': '),
    c3_write_inst_to_file(Inst, ja).
c3_write_inst_to_file(switch_on_constant(Nat,Table), ISIT) :-
    c3_make_spaces(ISIT),
    write('switch_on_constant('),
    write(Nat),
    write(',['),
    c3_write_modify_const_entry(Table),
    write('.').
c3_write_inst_to_file(switch_on_structure(Nat,Table), ISIT) :-
    c3_make_spaces(ISIT),
    write('switch_on_structure('),
    write(Nat),
    write(',['),
    c3_write_modify_struct_entry(Table),
    write('.').
c3_write_inst_to_file(put_constant(Const,No), ISIT) :-
    c3_make_spaces(ISIT),
    write('put_constant('),
    c3_write_name(Const),
    write(','),
    write(No),
    write(').').
c3_write_inst_to_file(put_structure(Struct/Arity,No), ISIT) :-
    c3_make_spaces(ISIT),
    write('put_structure('),
    c3_write_name(Struct),
    write('/'),
    write(Arity),
    write(','),
    write(No),
    write(').').
c3_write_inst_to_file(get_constant(Const,No), ISIT) :-
    c3_make_spaces(ISIT),
    write('get_constant('),
    c3_write_name(Const),
    write(','),
    write(No),
    write(').').
c3_write_inst_to_file(get_structure(Struct/Arity,No), ISIT) :-
    c3_make_spaces(ISIT),
    write('get_structure('),
    c3_write_name(Struct),
    write('/'),
    write(Arity),
    write(','),
    write(No),
    write(').').
c3_write_inst_to_file(match_constant(Const,No), ISIT) :-
    c3_make_spaces(ISIT),
    write('match_constant('),
    c3_write_name(Const),
    write(','),
    write(No),
    write(').').
c3_write_inst_to_file(match_structure(Struct/Arity,No), ISIT) :-
    c3_make_spaces(ISIT),
    write('match_structure('),
    c3_write_name(Struct),
    write('/'),
    write(Arity),
    write(','),
    write(No),
    write(').').
c3_write_inst_to_file(unify_constant(Const), ISIT) :-
    c3_make_spaces(ISIT),
    write('unify_constant('),
    c3_write_name(Const),
    write(').').
c3_write_inst_to_file(read_constant(Const), ISIT) :-
    c3_make_spaces(ISIT),
    write('read_constant('),
    c3_write_name(Const),
    write(').').
c3_write_inst_to_file(write_constant(Const), ISIT) :-
    c3_make_spaces(ISIT),
    write('write_constant('),
    c3_write_name(Const),
    write(').').
c3_write_inst_to_file(put_struct_occ(Struct/Arity), ISIT) :-
    c3_make_spaces(ISIT),
    write('put_struct_occ('),
    c3_write_name(Struct),
    write('/'),
    write(Arity),
    write(').').
c3_write_inst_to_file(put_function_occ(Struct/Arity), ISIT) :-
    c3_make_spaces(ISIT),
    write('put_function_occ('),
    c3_write_name(Struct),
    write('/'),
    write(Arity),
    write(').').
c3_write_inst_to_file(put_const_occ(Const), ISIT) :-
    c3_make_spaces(ISIT),
    write('put_const_occ('),
    c3_write_name(Const),
    write(').').
c3_write_inst_to_file(call(Struct/Arity,No), ISIT) :-
    c3_make_spaces(ISIT),
    write('call('),
    c3_write_name(Struct),
    write('/'),
    write(Arity),
    write(','),
    write(No),
    write(').').
c3_write_inst_to_file(call_rewriting(Struct/Arity), ISIT) :-
    c3_make_spaces(ISIT),
    write('call_rewriting('),
    c3_write_name(Struct),
    write('/'),
    write(Arity),
    write(').').
c3_write_inst_to_file(call_rewriting(Struct/Arity,No), ISIT) :-
    c3_make_spaces(ISIT),
    write('call_rewriting('),
    c3_write_name(Struct),
    write('/'),
    write(Arity),
    write(','),
    write(No),
    write(').').
c3_write_inst_to_file(execute(Struct/Arity), ISIT) :-
    c3_make_spaces(ISIT),
    write('execute('),
    c3_write_name(Struct),
    write('/'),
    write(Arity),
    write(').').
c3_write_inst_to_file(execute_rewriting(Struct/Arity), ISIT) :-
    c3_make_spaces(ISIT),
    write('execute_rewriting('),
    c3_write_name(Struct),
    write('/'),
    write(Arity),
    write(').').
c3_write_inst_to_file(Inst, ISIT) :-
    c3_make_spaces(ISIT),
    writeq(Inst),
    write('.').

c3_make_spaces(ja).
c3_make_spaces(nein):-
    write('      ').

c3_write_modify_const_entry([]) :- write('])').
c3_write_modify_const_entry([entry(X,Y)]) :-
    c3_write_name(X),
    write(','),
    c3_write_label(Y),
    write('])').
c3_write_modify_const_entry([entry(X,Y)|Tail]) :-
    c3_write_name(X),
    write(','),
    c3_write_label(Y),
    write(','),
    c3_write_modify_const_entry(Tail).

c3_write_modify_struct_entry([]) :- write('])').
c3_write_modify_struct_entry([entry(X/N,Y)]) :-
    c3_write_name(X),
    write('/'),
    write(N),     
    write(','),
    c3_write_label(Y),
    write('])').
c3_write_modify_struct_entry([entry(X/N,Y)|Tail]) :-
    c3_write_name(X),
    write('/'),
    write(N), 
    write(','),
    c3_write_label(Y),
    write(','),
    c3_write_modify_struct_entry(Tail).

c3_write_name(Name) :-
    write('('),
    writeq(Name),
    write(')').

c3_write_label(Label) :-
    writeq(Label).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%                              END  OF  PROGRAM                               %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



