
%% Prolog-Praedikate zur Uebersetzung von AbSy(SOWAM) in Bytecode
%%   hier: Erstellung der Relocation-Tabelle
%%   Autor: Andreas Schwab

%%% b_make_reloc_table(Bytecode, PC, RelocTable)
%%
%% Eingabe:
%%   Bytecode: Liste der Bytecodes mit adr/1, const/2 und table/1 als
%%	       Markierung fuer zu relozierende Elemente
%%	       (tatsaechlich eine Liste von Listen)
%%   PC:       Adresse des ersten Bytecodes
%%
%% Ausgabe:
%%   RelocTable: Liste aus reloc(Adr, Art)
%%

b_make_reloc_table(Bytecode, PC, RelocTable) :-
    b_make_reloc(Bytecode, PC, RelocTable, [], _).


b_make_reloc([], PC, Reloc, Reloc, PC).
b_make_reloc([BCList | BCRest], PCIn, Reloc, RelocEnd, PCOut) :-
    b_make_reloc1(BCList, PCIn, Reloc, Reloc1End, PC1Out),
    b_make_reloc(BCRest, PC1Out, Reloc1End, RelocEnd, PCOut).

b_make_reloc1([], PC, Reloc, Reloc, PC).
b_make_reloc1([BC | BCRest], PCIn, Reloc, RelocEnd, PCOut) :-
    b_make_bc_reloc(BC, PCIn, Reloc, Reloc1End, PC1Out),
    b_make_reloc1(BCRest, PC1Out, Reloc1End, RelocEnd, PCOut).

b_make_bc_reloc(bc0(_), PCIn, Reloc, Reloc, PCOut) :-
    PCOut is PCIn + 1.
b_make_bc_reloc(bc1(_,_), PCIn, Reloc, Reloc, PCOut) :-
    PCOut is PCIn + 1.
b_make_bc_reloc(bc1adr(_,_), PCIn, [AR | RelocEnd], RelocEnd, PCOut) :-
    RPC is PCIn + 1,
    b_adr_reloc(RPC, AR),
    PCOut is PCIn + 3.
b_make_bc_reloc(bc1const(_,_,_), PCIn, [SR | RelocEnd], RelocEnd, PCOut) :-
    RPC is PCIn + 2,
    b_sym_reloc(RPC, SR),
    PCOut is PCIn + 3.
b_make_bc_reloc(bc2adr(_,_,_), PCIn, [AR | RelocEnd], RelocEnd, PCOut) :-
    RPC is PCIn + 1,
    b_adr_reloc(RPC, AR),
    PCOut is PCIn + 3.
b_make_bc_reloc(bc2const(_,_,_,_), PCIn, [SR | RelocEnd], RelocEnd, PCOut) :-
    RPC is PCIn + 2,
    b_sym_reloc(RPC, SR),
    PCOut is PCIn + 3.
b_make_bc_reloc(bc2(_,_,_), PCIn, Reloc, Reloc, PCOut) :-
    PCOut is PCIn + 2.
b_make_bc_reloc(bc2table(_,N,_), PCIn, [TR | RelocEnd], RelocEnd, PCOut) :-
    RPC is PCIn + 1,
    b_tab_reloc(RPC, TR),
    PCOut is PCIn + 4*N + 2.
b_make_bc_reloc(bc4adr(_,_,_,_,_), PCIn, [AR1,AR2,AR3,AR4|RelocEnd],
		RelocEnd, PCOut) :-
    RPC1 is PCIn + 1,
    b_adr_reloc(RPC1, AR1),
    RPC2 is PCIn + 3,
    b_adr_reloc(RPC2, AR2),
    RPC3 is PCIn + 5,
    b_adr_reloc(RPC3, AR3),
    RPC4 is PCIn + 7,
    b_adr_reloc(RPC4, AR4),
    PCOut is PCIn + 9.
b_make_bc_reloc(bc3adr(_,_,_,_), PCIn, [AR | RelocEnd], RelocEnd, PCOut) :-
    RPC is PCIn + 1,
    b_adr_reloc(RPC, AR),
    PCOut is PCIn + 4.

%b_make_table_reloc([Entry | Rest], PC, Reloc, RelocEnd) :-
%    b_make_table_reloc1(Entry, PC, Reloc, Reloc1End),
%    NPC is PC + 4,
%    b_make_table_reloc(Rest, NPC, Reloc1End, RelocEnd).
%b_make_table_reloc([], _, Reloc, Reloc).
%
%b_make_table_reloc1(entry(_,_,_), PC, [SR, AR | RelocEnd], RelocEnd) :-
%    RPC1 is PC + 1,
%    b_sym_reloc(RPC1, SR),
%    RPC2 is PC + 2,
%    b_adr_reloc(RPC2, AR).

b_adr_reloc(RPC, reloc(RPC, code)).
b_sym_reloc(RPC, reloc(RPC, symbol)).
b_tab_reloc(RPC, reloc(RPC, table)).
