%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% HILFE            Hilfe speichern & aufrufen         Jost Schwider 19.06.90
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% h.                           Gibt allgemeine Starthilfen.
% h(Stichwort).                Gibt Hilfe zum <Stichwort>, falls vorhanden.
% :-hilfe(Titel,Aufrufe,Text). Ein neuer Hilfstext wird definiert: <Titel>
%                              ist ein String, welcher die Ueberschrift der
%                              Hilfe angibt. <Aufrufe> ist eine Liste von
%                              Strings, welche die Stichwoerter (d.h. Such-
%                              begriffe) enthaelt. <Text> ist die Liste von
%                              Strings, die den Hilfstext Zeile fuer Zeile
%                              enthaelt.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Hilfe ausgeben:

h :- h(start). % Starthilfe

h(Stichwort) :-
   var(Stichwort),!,
   h('??? Variable ???').
h(Stichwort) :-
   hh(Stichwort,Aufruf),!,
   hh(Aufruf,Titel,Text),
   hWrite(Titel,Text).
h(Stichwort) :- 
   hWriteLine('='),
   write('Zu <'),write(Stichwort),write('> existiert kein Eintrag!'),nl,
   hWriteLines([
      '=',
      'Hilfstexte sind nur fuer folgende Stichwoerter vorhanden:',
      '-']),
   bagof(Hilfe,hh(Hilfe),HilfListe),
   hWriteListe(HilfListe),
   hWriteLine('=').

hh(Hilfe) :- hh(Hilfe,_). % QProlog ueberlisten!

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Routinen fuer Hilfe:

hWrite(Titel,Hilfe) :-
   hWriteLines(['=',Titel,'=']),
   hWriteLines(Hilfe),
   hWriteLines(['=']).

hWriteLines([]).
hWriteLines([Zeile|Rest]) :-
   hWriteLine(Zeile),
   hWriteLines(Rest).

hWriteLine(nl) :- !,nl.
hWriteLine(Zeile) :-
   name(Zeile,L),
   L = [_], % Falls nur ein Zeichen, dann Linie daraus bilden...
   hWriteChar(78,Zeile),nl.
hWriteLine(Zeile) :-
   write(Zeile),nl.

hWriteChar(0,_).
hWriteChar(N,Char) :-
   write(Char),
   N1 is N - 1,
   hWriteChar(N1,Char).

hWriteListe([]).
hWriteListe([E]) :-
   !,writeq(E),nl.
hWriteListe([E|L]) :-
   writeq(E),write(', '),
   hWriteListe(L).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Hilfstexte speichern:

hilfe(Titel,[Aufruf|AufrufListe],Text) :-
   assertz( hh(Aufruf,Titel,Text) ),
   hilfeAufrufe(Aufruf,[Aufruf|AufrufListe]).

hilfeAufrufe(_,[]).
hilfeAufrufe(AufrufOriginal,[Aufruf|AufrufListe]) :-
   assertz( hh(Aufruf,AufrufOriginal) ),
   hilfeAufrufe(AufrufOriginal,AufrufListe).
