/*
 * Copyright (C) 1990, 1993 by Ted Kim.
 *
 * This software work was developed at UCLA with support in part from
 * DARPA Contract F29601-87-C-0072.
 */

/*
 * pixmap.c - pixmap functions
 * 
 * pxCreatePixmap
 * pxDestroyPixmap
 *
 * pxGetPixmapAttribute
 * pxQueryPixmap
 */

#include <stdio.h>
#include <X11/Xlib.h>

#include "dl.h"
#include "conn.h"
#include "ff.h"
#include "attrib.h"

/*
 * pxCreatePixmap(+Connection, +Screen, +Width, +Height, +Depth, -Pixmap, 0)
 *	integer: Connection, ScreenOf, Width, Height, Depth, Pixmap
 */
FFInteger
pxCreatePixmap(pc, psc, pw, ph, pd, pp)
     FFInteger pc, psc, pw, ph, pd, *pp;
{
  PxConnection *pcp;
  PxScreen *pscp;

  PX_ErrorInit("xCreatePixmap/6");
  *pp = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  if (DLLookup(pxScreenList, (int)psc, (DLHeader **)&pscp))
    PX_Error(no_such_screen);

  *pp = XCreatePixmap(pcp->xDisplay, pscp->xScreen->root, pw, ph, pd);
  return FF_Ok;
}

/*
 * pxDestroyPixmap(+Connection, +Pixmap, 0)
 *	integer: Connection, Pixmap
 */
FFInteger
pxDestroyPixmap(pc, pp)
     FFInteger pc, pp;
{
  PxConnection *pcp;

  PX_ErrorInit("xDestroyPixmap/2");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XFreePixmap(pcp->xDisplay, pp);
  return FF_Ok;
}

/*
 * pxGetPixmapAttribute(+Attribute, -Value, 0)
 *	integer: Attribute, Value
 */

#define XPMA (pxAttribBuf.xpma)

#define PX_GetAttribute(A, MEM) \
  case A: *pv = XPMA.MEM; \
          break

FFInteger
pxGetPixmapAttribute(pa, pv)
     FFInteger pa, *pv;
{
  *pv = PX_Invalid;

  switch (pa) {
    PX_GetAttribute(0, width);
    PX_GetAttribute(1, height);
    PX_GetAttribute(2, border_width);
    PX_GetAttribute(3, depth);
    PX_GetAttribute(4, screen);
    default: PX_Error(unknown_attribute);
  }
  return FF_Ok;
}

/*
 * pxQueryPixmap(+Connection, +Drawable, 0).
 *	integer: Connection, Drawable;
 */
FFInteger
pxQueryPixmap(pc, pd)
     FFInteger pc, pd;
{
  PxConnection *pcp; PxScreen *psp;
  Window root;
  
  PX_ErrorInit("xQueryPixmap/3");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;
  
  if (!XGetGeometry(pcp->xDisplay, pd, &root, &(XPMA.x), &(XPMA.y),
		    &(XPMA.width), &(XPMA.height), &(XPMA.border_width),
		    &(XPMA .depth)))
    PX_Error("no such pixmap");

  psp = (PxScreen *)(pxScreenList.list);
  while (psp != NULL) {
    if (psp->xScreen->root == root) {
      XPMA.screen = psp->des;
      return FF_Ok;
    }
    psp = psp->next;
  }
  PX_Error(no_matching_screen);
}

/*
 * eof
 */
