%
% ECLiPSe XWIP Package
%

:- get_flag(extension, kegi_xview) ->
printf(error, 'XWIP can be loaded only into eclipse, xeclipse already contains\
%nan older version of XWIP which can be made visible by calling\
%n%txwip_mode/0.%n%b', []), halt;
	true.
%:- nodbgcomp.		% uncomment for optimized compiling
:- lib(foreign).
:- import
	printf_/5,
	trimcore/0
    from sepia_kernel.

% load foreign functions
:- compile(ff).

% load, libX11.a is assumed to be in /usr/lib
:- load_foreign_files(['xwip.o'], ['-L/usr/local/lib/X11', '-lX11']).
:- abolish((foreign_file/2,foreign/3)).

% load tables
:- compile(table).
:- compile(cfont).
:- compile(xatom).

% load predicates
:- compile(util).
:- compile(pred).

% cleanup
:- garbage_collect.
:- trimcore.

% version
version(V) :-
	recordz(ext_version, V).

banner(_, SepiaMessage) :-
	recorded(ext_version, V),
	printf(toplevel_output, "%w%n%w%n%b", [SepiaMessage, V]).

:- set_error_handler(164, banner/2).

:- set_flag(syntax_option, nl_in_quotes).
:- compile(version).
:- set_flag(syntax_option, not nl_in_quotes).

:- tool(format/3, format_body/4).
format(F, A) :-
	format(output, F, A).

format_body(Stream, Format, ArgList, Module) :-
        printf_(Stream, Format, ArgList, Module, 0'~) ->
                true
        ;
                get_bip_error(E),
                error(E, format(Stream, Format, ArgList), Module).
% precision
:- xPrecision(33).

% must be done by hand, since doing it here will cause problems with open files
% save_program(qpx)
:- printf('%n--->>> please type: save_program(epx).%n%n', []).

%
% eof
%
