/*
 * Copyright (C) 1990, 1993 by Ted Kim.
 *
 * This software work was developed at UCLA with support in part from
 * DARPA Contract F29601-87-C-0072.
 */

/*
 * attrib.h - declarations for attribute structures
 */

#define _PX_ATTRIB_H_

typedef struct {
  XWindowChanges xwc;
  XSetWindowAttributes xswa;
} PxWindowAttributes;

typedef struct {
  int x, y, width, height, border_width, depth, screen;
} PxPixmapAttributes;

typedef struct {
  XEvent xev;
  PxVector32 pev[37];
} PxEvent;

/* max size of an atom in Quintus */
#define MAXATOMLEN 512
#define KEYMAPBYTES 32

typedef union {
  PxWindowAttributes pwa;
  XWindowAttributes xwa;
  PxPixmapAttributes xpma;
  XGCValues xgcv;
  char xkeymap[KEYMAPBYTES];
  XKeyboardState xks;
  XKeyboardControl xkc;
  PxEvent ev;
  char atom[MAXATOMLEN + 1];
} PxAttributes;

/*
 * Copyright (C) 1990, 1993 by Ted Kim.
 *
 * This software work was developed at UCLA with support in part from
 * DARPA Contract F29601-87-C-0072.
 */

extern Bool pxAttribChanged1;
extern Bool pxAttribChanged2;
extern pxAttribMask1;
extern pxAttribMask2;
extern PxAttributes pxAttribBuf;

/*
 * eof
 */
