%
% ProTcl 1.1
%
%	Definitions common to all Prologs
%
% Author: Micha Meier
%
%
% sccsid("@(#)tk_common.pl	1.9          94/09/11").
% sccscr("@(#)  Copyright 1993 ECRC GmbH ").
%

tk_demo :-
    tk_init('$tk_library/demos/widget', []),
    tcl_eval('source $tk_library/demos/widget'),
    % now add our local demos
    tcl_eval('source $protcl_library/local/init'),
    update,
    tk_main_loop.

tcl_test :-
    tcl_tests(S),
    (S = '' ->
	write('No Tcl tests available'),
	nl,
	fail
    ;
	tk([nodisplay]),
	concat_atoms('cd ', S, CDS),
	tcl_eval(CDS),
	tcl_eval('source all'),
	tcl_eval('exit')
    ).

tk_test :-
    tk_tests(S),
    (S = '' ->
	write('No Tk tests available'),
	nl,
	fail
    ;
	tk([]),
	concat_atoms('cd ', S, CDS),
	tcl_eval(CDS),
	tcl_eval('source all'),
	tcl_eval('exit')
    ).

tk_init(File, Opts) :-
    tk_clear_options,
    tk_options(Opts),
    tk_init(File),
    protcl_source(ProTcl),
    concat_atoms('global protcl_library; set protcl_library ', ProTcl, SP),
    tcl_eval(SP),
    tcl_eval('set argc [llength $argv]').

tk_options([]).
tk_options([Opt|List]) :-
    Opt =.. [Name|Args],
    (Args = [Val|_] ->
	true
    ;
	Val = ''
    ),
    tk_option(Name, Val),
    tk_options(List).

tk_file(File, Options) :-
    tk_init(File, Options),
    concat_atoms('source ', File, InitFile),
    tcl_eval(InitFile),
    update,
    tk_main_loop.

update :-
    tcl_eval('if {[info commands update] == "update"} update').

tk_main_loop :-
    tk_do_one_event(0),
    tk_num_main_windows(X), X > 0 ->
	tk_main_loop
    ;
	true.

tcl_eval(S) :-
    tcl_eval(S, _).
