%
% ProTcl 1.0
%
%	Definitions common to Quintus-like foreign language interface
%
% Author: Micha Meier
% Date:   September 93
%

%
% sccsid("@(#)foreign.pl	1.6          94/09/11").
% sccscr("@(#)  Copyright 1993 ECRC GmbH ").
%

:- compile(dirs).

foreign_file('tk.o',
	[tk_init,
	 tk_clear_options,
	 tk_option,
	 tcl_eval_string,
	 tk_num_main_windows,
	 'Tk_DoOneEvent',
	 input_ready]).

foreign(tk_init, c, tk_init(+string)).
foreign(tk_clear_options, c, tk_clear_options).
foreign(tk_option, c, tk_option(+string, +string)).
foreign(tcl_eval_string, c, tcl_eval_string(+string, -string, [-integer])).
foreign(tk_num_main_windows, c, tk_num_main_windows([-integer])).
foreign('Tk_DoOneEvent', c, tk_do_one_event(+integer, [-integer])).
foreign(input_ready, c, input_ready(+integer, [-integer])).
	 
tcl_eval(S, R) :-
    tcl_eval_string(S, R, Err),
    Err = 0.

tk_do_one_event(I) :-
    tk_do_one_event(I, Ev),
    Ev > 0.

concat_atoms(A1, A2, Concat) :-
    name(A1, LA1),
    name(A2, LA2),
    append(LA1, LA2, LA),
    name(Concat, LA).

append([], L, L).
append([X|L1], L2, [X|L3]) :-
    append(L1, L2, L3).

:-
    tcl_library(TclLib),
    tk_library(TkLib),
    protcl_source(Pro),
    xlibsw(XLib),
    concat_atoms('-L', TclLib, TC),
    concat_atoms('-L', TkLib, TK),
    concat_atoms(Pro, '/libinit.a', Init),
    concat_atoms('-L', XLib, XL),
    load_foreign_files(['tk.o'], [Init, TC, TK, '-ltk -ltcl -lm', XLib]).

