%
% ECLiPSe version of the Prolog Tk interface
%
% Author: Micha Meier
% Date:   September 93
%

%
% sccsid("@(#)etk.pl	1.13          94/09/11").
% sccscr("@(#)  Copyright 1993 ECRC GmbH ").
%

:- module_interface(tk).

:- export
	tcl_eval/1,
	tcl_eval/2,
	tcl_test/0,
	tclsh/0,
	tk_demo/0,
	tk_test/0,
	tk_file/2,
	tk/1,
	tk_do_one_event/1,
	tk_do_one_event/2,
	tk_main_loop/0,
	tk_next_event/1,
	tk_next_event/2,
	tk_num_main_windows/1,
	tk_get_event/1,
	tk_get_event/2,
	tk_load_libs/2,
	wish/0.

:- begin_module(tk).

:- import
	sepia_toplevel_prompt/2,		% default 153 handler
	symbol_address/2
    from sepia_kernel.

:- external(tk_init/1).
:- external(tk_clear_options/0).
:- external(tk_option/2).
:- external(tk_do_one_event/2).
:- external(tcl_eval_string/2).
:- external(tk_num_main_windows/1).

% We assume that files may contain relative pathnames and the loading
% may be done from another directory. Therefore, the pathnames of the
% ProTcl files have to be absolute.

:-
    getcwd(Cwd),
    get_flag(hostarch, Arch),
    get_flag(object_suffix, O),
    concat_string(["../", Arch, "/dirs"], Dirs),
    get_flag(installation_directory, Inst),
    concat_atom([Inst, "/lib_graphic/tk"], ProTcl),
    compile(Dirs),
    set_error_handler(211, fail/0),
    (O == "so" ->
	concat_string([Cwd, "../", Arch, "/tk.so"], Load),
	LOAD = load(Load)
    ;
    symbol_address(p_tk_init, _) ->
	LOAD = true			% it is statically linked
    ;
%    O == "o" ->
	tcl_library(TclLib),
	tk_library(TkLib),
	xlibsw(XLib),
	LOAD = (concat_string([Cwd, "../", Arch, "/tk.o ", Files,
	    " -L", Cwd, "../", Arch,
	    " -L", TclLib,
	    " -L", TkLib,
	    " -linit -ltk -ltcl ", XLib, " -lm"], Load),
	    load(Load))
    ),
    reset_error_handler(211),
    compile_term([(
tk_load_libs(Files, Module) :-
	LOAD,
	external(tk_init/1, p_tk_init),
	external(tk_clear_options/0, p_tk_clear_options),
	external(tk_option/2, p_tk_option),
	external(tk_do_one_event/2, p_tk_do_one_event),
	external(tcl_eval_string/2, p_tcl_eval_string),
	external(tk_num_main_windows/1, p_tk_num_main_windows)
    ),
protcl_source(ProTcl)
    ]).
	
:-
	(current_module(tkext) ->
	    true			% loading will be done from tkext
	;
	    tk_load_libs("", '')
	).

:- compile(tk_common).

tcl_eval(S, R) :-
    (atom(S); string(S)),
    !,
    tcl_eval_string(S, R).
tcl_eval(List, R) :-
    concat_string(List, S),
    tcl_eval_string(S, R).

tk(Opts) :-
    tk_init('', Opts),
    update,
    set_error_handler(153, tk_prompt/2).

% For compatibility with other systems
tk_do_one_event(Mask) :-
    tk_do_one_event(Mask, L),
    (integer(L) ->
	true
    ;
	error(333, L)
    ).

% The new handler for the prompt event - until there is data to read,
%  we serve Tk events. Unfortunately this does not help when we block
%  in a read which is not issued from the top-level loop.
tk_prompt(_, M) :-
    sepia_toplevel_prompt(_, M),
    tk_loop.

tk_loop :-
    tk_do_one_event(0, L),
    (tk_num_main_windows(0) ->
	reset_error_handler(153)
    ;
    integer(L) ->				% file event
	(select([toplevel_input], 0, [_]) ->
	    true				% there is something to read
	;
	    tk_loop				% nothing, wait for next event
	)
    ;
	error(333, L),				% invoke the handler
	tk_loop
    ).

%
% Wait for the next Prolog event to occur, serve all other events
%
tk_next_event(List) :-
    tk_next_event(16'1e, List).

tk_next_event(Mask, List) :-
    M is Mask /\ 16'fe,
    tk_do_one_event(M, L),			% must succeed
    (tk_num_main_windows(0) ->
	reset_error_handler(153),
	List = 0
    ;
    L = 0 ->					% no Prolog event
	tk_next_event(Mask, List)
    ;
	List = L
    ).

%
% Process all events currently present in the queue, return the first Prolog
% one if available
%
tk_get_event(List) :-
    tk_get_event(16'1f, List).

tk_get_event(Mask, List) :-
    M is Mask \/ 1,				% don't wait
    (tk_do_one_event(M, L) ->
	(tk_num_main_windows(0) ->
	    reset_error_handler(153),
	    List = 0
	;
	L = 0 ->				% no Prolog event
	    tk_get_event(Mask, List)
	;
	    List = L
	)
    ;
	List = 0
    ).

% A wish-like facility to allow typing Tcl commands directly
wish :-
    wish([]).

tclsh :-
    wish([nodisplay]).

wish(Opts) :-
    (tcl_eval('') ->		% see if we have an interpreter
	true
    ;
	tk(Opts)
    ),
    get_prompt(toplevel_input, P, S),
    set_prompt(toplevel_input, '', S),
    block(wish_line(S), Tag, rest(Tag, P, S)),
    set_prompt(toplevel_input, P, S).

wish_line(S) :-
    printf(S, "%% %b", []),
    tk_loop,
    read_string(toplevel_input, "\n", _, String),
    !,
    (tcl_eval(String, Res) ->
	writeln(Res)
    ;
	true		% no fail if a tcl error occurs
    ),
    wish_line(S).
wish_line(_) :-
    tcl_eval(exit).

rest(Tag, P, S) :-
    set_prompt(toplevel_input, P, S),
    tcl_eval(exit),
    exit_block(Tag).
