'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /user6/ouster/tcl/man/RCS/seek.n,v 1.1 93/06/07 16:48:27 ouster Exp $ SPRITE (Berkeley)
'\" 
.so man.macros
.HS seek tcl
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
seek \- Change the access position for an open file
.SH SYNOPSIS
\fBseek \fIfileId offset \fR?\fIorigin\fR?
.BE

.SH DESCRIPTION
.PP
Change the current access position for \fIfileId\fR.
\fIFileId\fR must have been the return
value from a previous call to \fBopen\fR, or it may be \fBstdin\fR,
\fBstdout\fR, or \fBstderr\fR to refer to one of the standard I/O
channels.
The \fIoffset\fR and \fIorigin\fR arguments specify the position at
which the next read or write will occur for \fIfileId\fR.
\fIOffset\fR must be an integer (which may be negative) and \fIorigin\fR
must be one of the following:
.TP
\fBstart\fR
The new access position will be \fIoffset\fR bytes from the start
of the file.
.TP
\fBcurrent\fR
The new access position will be \fIoffset\fR bytes from the current
access position; a negative \fIoffset\fR moves the access position
backwards in the file.
.TP
\fBend\fR
The new access position will be \fIoffset\fR bytes from the end of
the file.  A negative \fIoffset\fR places the access position before
the end-of-file, and a positive \fIoffset\fR places the access position
after the end-of-file.
.LP
The \fIorigin\fR argument defaults to \fBstart\fR.
This command returns an empty string.

.SH KEYWORDS
access position, file, seek
