/* XLISP-PLUS is based on:
*/

/* xlisp - a small subset of lisp */
/*      Copyright (c) 1985, by David Michael Betz
        All Rights Reserved
        Permission is granted for unrestricted non-commercial use       */

/* Public Domain contributors to this modified distribution:
    Tom Almy, Mikael Pettersson, Neal Holtz, Johnny Greenblatt, 
    Ken Whedbee, Blake McBride, Pete Yadlowsky, and Hume Smith */

/* Portions of this code from XLISP-STAT Copyright (c) 1988, Luke Tierney */

/* system specific definitions */

#include <stdio.h>
#include <ctype.h>
#include <setjmp.h>
#include <string.h>

/************ Notice to anyone attempting modifications ****************/
/* Compared to original XLISP, length of strings in an LVAL exclude the
   terminating null. When appropriate, characters are consistantly treated
   as unsigned, and the null, \0, character is allowed. Don't write any new
   code that assumes NULL and/or NIL are zero */

/********************** PREFERENCE OPTIONS ****************/

/* There used to be many different preference options; if
   you turned them all off you got "standard" xlisp 2.0. But because
   of option proliferation, and the change of name, this is no longer
   true: there are many fewer options, and most functions are now
   standard. */

/* You can also use dynamic array allocation by substituting dldmem.c
   and dlimage.c for xldmem.c and xlimage.c. Using this alternative
   adds 1184 bytes of code */

/* Costs indicated for Borland Turbo C++ V1.0 (as a C compiler) */

/* Not all permutations of these choices have been tested, but luckily most
   won't interract. */

/* This eliminates the problems of rational numbers (fixnums and ratios)
   overflowing. The cost is slightly slower performance and 1100 bytes
   requires COMPLX */
#define NOOVFIXNUM

/* This option modifies performance, but don't affect execution of
   application programs (other than speed) */
#define JMAC        /* performance enhancing macros, Johnny Greenblatt 
                        (7.5K at full config). Don't bother for 16 bit
                        MSDOS compilers. */

/* This option is for IBM PC 8 bit ASCII. To use in other environments,
   you would need to modify the STUFF files, and possibly change the 
   definitions for the macros TOUPPER TOLOWER ISUPPER and ISLOWER.
   Option adds 464 bytes */
#define ASCII8

/* This option is necessary for Microsoft Windows 3.0, but can be used
   under MS-DOS as well. Borland C++ and TopSpeed C provide adequate library
   support for MS-DOS use. For other compilers, additional functions would
   need to be written (not supplied). Windows provides the necessary
   functions, so any Windows-compliant compiler should suffice.
   When using this option, you must compile all modules with the medium
   memory model, and you must also use the dldmem/dlimage pair of files
   rather than the xldmem/xlimage pair of files.
   This option is not enabled here; when desired it is enabled from the
   compiler command line. */
/*#define MEDMEM*/      /* Medium memory model */

/* This option is necessary for Microsoft Windows 3.0. It handles file
   streams using a local table of file defining structures. For non-windows
   use, the benefits are file streams can print their associated file names
   and files streams are preserved across saves. It also allows the
   functions TRUENAME and DELETE-FILE */
#define FILETABLE

/* This option allows xlisp to be called as a server. There is no outer loop.
   The STUFF file will have to modified appropriately, as well as xldbug. */
/*#define SERVER*/  /* server version */

/* This option adds a *readtable-case* global variable that has the same
   effect as the readtable-case function described in CLtL, 2nd Ed. 
   It is contributed by Blake McBride, root@blakex.raindernet.com, who
   places it in the public domain */
#define READTABLECASE

/* This option adds the :KEY arguments to appropriate functions. It's
   easy to work around when missing (adds about 2k bytes) */
#define KEYARG

/* Use environmental variable of same name as a search
    path for LOAD and RESTORE commands. Might not be
    available on some systems */
#define PATHNAMES "XLPATH"

/* The remainder of options solely add various functions. If you are
   pressed for space, you might try eliminating some of these (particularly
   TIMES, COMPLX, and RATIOS) */

#define SRCHFCN     /* SEARCH (1040 bytes)*/

#define MAPFCNS     /* SOME EVERY NOTANY NOTEVERY MAP (2352 bytes)*/

#define POSFCNS     /* POSITION-IF COUNT-IF FIND-IF (1504 bytes)*/

#define REMDUPS     /* REMOVE-DUPLICATES (1440 bytes)*/

#define REDUCE      /* REDUCE, by Luke Tierney (with modifications). 
                       (1008 bytes)*/

#define ADDEDTAA    /* added function by TAA: GENERIC (336 bytes) */

#define TIMES       /* time functions TIME GET-INTERNAL-RUN-TIME
                       GET-INTERNAL-REAL-TIME and constant
                       INTERNAL-TIME-UNITS-PER-SECOND (5286 bytes)*/

#define RANDOM      /* Add RANDOM-NUMBER-STATE type, *RANDOM-STATE*, and
                       function MAKE-RANDOM-STATE
                       You must also define TIMES (736 bytes)*/

#define HASHFCNS    /* Hash table functions (Ken Whedbee):
                       SETHASH (SETF (SETHASH..)), MAKE-HASH-TABLE, 
                       TAA's REMHASH, MAPHASH, CLRHASH, HASH-TABLE-COUNT
                       (2608 bytes)*/

#define SETS        /* Luke Tierney's set functions ADJOIN UNION INTERSECTION
                        SET-DIFFERENCE SUBSETP (1328 bytes)*/

#define APPLYHOOK   /* adds applyhook support, strangely missing before 
                       (1312 bytes)*/

#define COMPLX      /* complex numbers&more math from Luke Tierney:
                        COMPLEX, COMPLEXP, IMAGPART, REALPART, CONJUGATE, 
                        PHASE, LOG, FLOOR, CEILING, ROUND, and PI.
                        Also LCM (by Ken Whedbee) and
                        ASH (by Pete Yadlowsky) (15k bytes) */

#define RATIOS      /* rational numbers (by Pete Yadlowsky)
                       requires COMPLX even though there is no
                       support for complex rational numbers (4600 bytes)*/

#define SAVERESTORE
                    /* SAVE and RESTORE commands (an original option!) 
                        (3936 bytes) */

/* The following option only available for certain compilers noted
   below */

#define GRAPHICS    /* add graphics commands 
                        MODE COLOR MOVE DRAW MOVEREL DRAWREL
                       and screen commands CLS CLEOL GOTO-XY
                        (3k) */




/************ END OF PREFERENCE OPTIONS **************/


/* handle dependencies */


#ifdef RANDOM
#ifndef TIMES
#define TIMES
#endif
#endif

#ifdef RATIOS
#ifndef COMPLX
#define COMPLX
#endif
#endif

/*************** COMPILER/ENVIRONMENT OPTIONS ****************/



/* Default compiler options: */
/* NNODES       number of nodes to allocate in each request (2000) */
/* VSSIZE       number of vector nodes to allocate in each request (6000) */
/* EDEPTH       evaluation stack depth (650) */
/* ADEPTH       argument stack depth (1000) */
/* FORWARD      type of a forward declaration () */
/* LOCAL        type of a local function (static) */
/* NEAR         function is is same segment (8086 processors) () */
/* AFMT         printf format for addresses ("%x") */
/* FIXTYPE      data type for fixed point numbers (long) */
/* MAXFIX       maximum positive value of an integer (0x7fffffffL) */
/* MAXSLEN      maximum sequence length, <= maximum unsigned, on 16 bit
                systems should be the maximum string length that can be
                malloc'ed (1000000)*/
/* MAXVLEN      maximum vector length, should normally be MAXSLEN, but on
                16 bit systems needs to be the maximum vector size that can
                be malloc'ed (MAXSLEN) */
/* ITYPE        fixed point input conversion routine type (long atol()) */
/* ICNV         fixed point input conversion routine (atol) */
/* IFMT         printf format for fixed point numbers ("%ld") */
/* RFMT         printf format for ratios ("%ld/%ld") */
/* FLOTYPE      data type for floating point numbers (double) */
/* OFFTYPE      number the size of an address (int) */
/* CVPTR        macro to convert an address to an OFFTYPE. We have to go
                through hoops for some MS-DOS compilers that like to
                normalize pointers. In these days of Windows, compilers
                seem to be better behaved. Change to default definition
                only after extensive testing. This is no big deal as it
                only effects the SAVE command. (OFFTYPE)(x) */
/* ALIGN32      Compiler has 32 bit ints and 32 bit alignment of struct
                elements */
/* DOSINPUT     OS specific code can read using OS's line input functon */
/* IEEEFP       IEEE FP -- proper printing of +-INF and NAN
                       for compilers that can't hack it.
                       Currently for little-endian systems. */
/* CDECL        C style declaration, for compilers that can also generate
                Pascal style, to allow calling of main() ([nothing])*/
/* ANSI         define for ANSI C compiler */
/* FNAMEMAX     Maximum size of file name strings (63) */

/* STDIO and MEM and certain STRING calls can be overridden as needed
   for various compilers or environments. By default, the standard
   library functions are used. Any substitute function must mimic the
   standard function in terms of arguments and return values */

/* OSAOPEN      Open ascii file (fopen) */
/* OSBOPEN      Open binary file (fopen) */
/* MODETYPE     Type of open mode (const char *) */
/* OPEN_RO      Open mode for read only ("r") */
/* OPEN_UPDATE  Open mode for update ("r+") */
/* CREATE_WR    Open mode for create for writing ("w") */
/* CREATE_UPDATE Open mode for create update ("w+") */
/* CLOSED       Closed file, or return value when open fails (NULL) */
/* OSGETC       Character read (fgetc) */
/* OSPUTC       Character write (fputc) */
/* OSREAD       Binary read of file (fread) */
/* OSWRITE      Binary write of file (fwrite) */
/* OSCLOSE      Close the file (fclose) */
/* OSSEEK       Seek in file (fseek(fp,loc,SEEK_SET)) */
/* OSSEEKCUR    Seek for changing direction (fseek(fp,loc,SEEK_CUR)) */
/* OSSEEKEND    Seek to end  (fseek(fp,0L,SEEK_END)) */
/* OSTELL       Tell file location (ftell) */
/* FILEP        File pointer type (FILE *),
                used in all the above functions */
/* STDIN        Standard input (a FILEP) (stdin) */
/* STDOUT       Standard output (stdout) */
/* CONSOLE      Console (stderr) */

/* MALLOC       Memory allocation (malloc) */
/* CALLOC       Memory allocation (calloc) */
/* MFREE        Memory allocation (free) */

/* These are needed in case far pointer override is necessary: */

/* STRCMP       String compare (strcmp) */
/* STRCPY       String copy (strcpy) */
/* STRNCPY      String copy (strncpy) */
/* STRCAT       String concatenate (strcat) */
/* STRLEN       String length (strlen) */
/* MEMCPY       Memory copy (memcpy) */


/* for Zortech C  -- Versions 2.0 and above, please */
/* Works for Large Model, 268PM model (Z), and 386PM model (X) */
/* GRAPHICS ok */
/* EDEPTH should be stacksize/25 */
#ifdef __ZTC__
#ifdef DOS386   /* 80386 compiler */
#define EDEPTH 4000 
#define ADEPTH 6000
#define VSSIZE 20000
#define ALIGN32
#define ANSI
#if __ZTC__ < 0x300
#define IEEEFP      /* they fixed this */
#endif
#define CDECL   _cdecl
#define DOSINPUT
#ifndef FILETABLE
#define OSBOPEN osbopen /* special mode for binary files */
extern FILE * _cdecl osbopen(const char *name, const char *mode);   /* open binary file */
#endif
#else           /* 80286PM or Real mode */
#ifdef DOS16RM
#define EDEPTH          2000
#define ADEPTH          3000
#endif
#define MAXSLEN         (65519U)
#define MAXVLEN         (16379U)
#define ANSI
#define AFMT            "%lx"
#define OFFTYPE         unsigned long
#if __ZTC__ < 0x300
#define IEEEFP      /* they fixed this */
#endif
#define CDECL   _cdecl
#define DOSINPUT
#undef JMAC         /* not worth effort if cramped for space */
#define NEAR _near
#ifndef FILETABLE
#define OSBOPEN osbopen /* special mode for binary files */
extern FILE * _cdecl osbopen(const char *name, const char *mode);   /* open binary file */
#endif
#endif
#undef MEDMEM       /* doesn't work, as of V2.1 */
#endif

/* for the Turbo C compiler - MS-DOS, large or medium model */
/* Version 1.5 and 2.0.  1.5 won't compile with TIMES */
/* Also for Turbo/Borland C++, as a C compiler */
/* GRAPHICS ok */
/* EDEPTH should be stacksize/25 */
#ifdef __TURBOC__
#define MAXSLEN         (65519U)
#define MAXVLEN         (16383U)
#define ANSI
#define AFMT            "%lx"
#define OFFTYPE         unsigned long
#ifdef MEDMEM
#define CVPTR(x)        (unsigned long)(x)
#else
#define CVPTR(x)        ((((unsigned long)(x) >> 16) << 4) + ((unsigned) x))
#endif
#if __TURBOC__ < 0x297
#define IEEEFP          /* Borland C++ V2.0 or later handles this */
#endif
#define CDECL _Cdecl
#define DOSINPUT
#undef JMAC         /* not worth effort if cramped for space */
#define NEAR near
#ifndef FILETABLE
#define OSBOPEN osbopen /* special mode for binary files */
extern FILE * _Cdecl osbopen(const char *name, const char *mode);   /* open binary file */
#endif
#endif

/* for the JPI TopSpeed C Compiler, Medium or Large memory model */
/* GRAPHICS ok */
/* EDEPTH should be stacksize/25 */
#ifdef __TSC__
#pragma data(heap_size=>4096,stack_size=>16384)
#define IEEEFP
#define MAXSLEN         (65519U)
#define MAXVLEN         (16379U)
#define ANSI
#define AFMT            "%lx"
#define OFFTYPE         unsigned long
#ifdef MEDMEM
#define CVPTR(x)        (unsigned long)(x)
#else
#define CVPTR(x)        ((((unsigned long)(x) >> 16) << 4) + ((unsigned) x))
#endif
#define CDECL           /* don't use CDECL with this compiler */
#define DOSINPUT
#undef JMAC         /* not worth effort if cramped for space */
#define NEAR near
#ifndef FILETABLE
#define OSBOPEN osbopen /* special mode for binary files */
extern FILE *osbopen(const char *name, const char *mode);   /* open binary file */
#endif
#endif

/* for the Microsoft C compiler - MS-DOS, large model */
/* Version 5.0.  Avoid optimizations. Should work with earlier as well. */
/* Version 6.0A. Most opts ok. Avoid those that conflict with longjump */
/* GRAPHICS ok */
/* EDEPTH should be stacksize/25 */
#ifdef MSC
#define MAXSLEN         (65519U)
#define MAXVLEN         (16379U)
#define ANSI
#define AFMT            "%lx"
#define OFFTYPE         long
#define CVPTR(x)        ((((unsigned long)(x) >> 16) << 4) + ((unsigned) x))
#define CDECL _cdecl
#define DOSINPUT
#undef JMAC         /* not worth effort if cramped for space */
#define NEAR _near
#ifndef FILETABLE
#define OSBOPEN osbopen /* special mode for binary files */
extern FILE * _cdecl osbopen(const char *name, const char *mode);   /* open binary file */
#endif
#undef MEDMEM       /* Except for Windows, in the future */
#endif

/* for 80386, Metaware High-C386 */
/* GRAPHICS ok -- Special fast graphics code, this
   version works only for EGA/VGA/Enhanced EorVGA modes! */
/* Tested with Versions 1.3, 1.4, and 1.5 */
#ifdef __HIGHC__
/* default EDEPTH=2000, at stacksize/34, requires stack of 68000 */
#define EDEPTH 4000 
#define ADEPTH 6000
#define VSSIZE 20000
#define ALIGN32
#define ANSI
#define DOSINPUT
extern long myftell(FILE *fp);  /* ftell is broken at least through v1.62) */
#ifdef FILETABLE
#define OSTELL(f) myftell(filetab[f].fp)
#else
#define OSTELL myftell
#define OSBOPEN osbopen /* special mode for binary files */
extern FILE *osbopen(const char *name, const char *mode);   /* open binary file */
#endif
#undef MEDMEM
#endif

/* For GCC on MSDOS (see GCCSTUFF.C) */
/* for now graphics is pretty clunky, as well */
#ifdef GCC
#define EDEPTH 4000
#define ADEPTH 6000
#define VSSIZE 20000
#define ALIGN32
#define ANSI
#define  SEEK_CUR 1
#define  SEEK_END 2
#define  SEEK_SET 0
#define IEEEFP
/* library improperly handles ASCII files re lseek() */
#define OSGETC osgetc
#define OSPUTC osputc
#ifdef FILETABLE
extern int osgetc(int), osputc(int,int);
#else /* No FILETABLE */
extern int osgetc(FILE*), osputc(int,FILE*);
#define OSAOPEN osaopen /* special mode for ASCII files */
extern FILE *osaopen(const char *name, const char *mode);
#define OSBOPEN osbopen /* special mode for binary files */
extern FILE *osbopen(const char *name, const char *mode);
#endif
#define DOSINPUT
#undef MEDMEM
#endif

/* for BSD & SYSV Unix. */
/* Also define BSD in BSD or SUNOS systems */
#ifdef UNIX
#define VOID void
#define EDEPTH 4000 
#define ADEPTH 6000
#define ALIGN32
#define AFMT                    "%lx"
#ifndef SEEK_SET
#define SEEK_SET                0
#endif
#ifndef SEEK_CUR
#define SEEK_CUR                1
#endif
#ifndef SEEK_END
#define SEEK_END                2
#endif
#undef GRAPHICS
#undef MEDMEM
#undef ASCII8
#define remove unlink   /* not all Unix systems have remove */
#ifdef FILETABLE
extern int osopen();
#define OSAOPEN osopen
#define OSBOPEN osopen
/* use default FILETABLE declaration for OSCLOSE */
#endif
/* Unix filenames can be long! */
#include <sys/param.h>
#define FNAMEMAX MAXPATHLEN
#endif

/* Amiga Lattice 5.04 (From Hume Smith) */
#ifdef AMIGA
#define EDEPTH 4000
#define ADEPTH 6000
#define ALIGN32
#define AFMT         "%lx"
#define SEEK_SET      0
#define SEEK_CUR      1
#define SEEK_END      2
#undef GRAPHICS
#undef MEDMEM
#undef FILETABLE    /* not ported */
#undef ASCII8
#endif

/*>>>>>>> For other systems -- You are on your own! */

/* Take care of VOID default definition */

#ifndef VOID
#define VOID void    
#endif


/* Handle the FILETABLE specification -- non-windows */
#ifdef FILETABLE
#define FTABSIZE 13
#define FILEP int
#define CLOSED (-1)     /* because FILEP is now table index */
#define STDIN (0)
#define STDOUT (1)
#define CONSOLE (2)
#ifndef OSAOPEN
#define OSAOPEN osaopen
extern FILEP osaopen(const char *name, const char *mode);
#endif
#ifndef OSBOPEN
#define OSBOPEN osbopen
extern FILEP osbopen(const char *name, const char *mode);
#endif
#ifndef OSGETC
#define OSGETC(f) fgetc(filetab[f].fp)
#endif
#ifndef OSPUTC
#define OSPUTC(i,f) fputc(i,filetab[f].fp)
#endif
#ifndef OSREAD
#define OSREAD(x,y,z,f) fread(x,y,z,filetab[f].fp)
#endif
#ifndef OSWRITE
#define OSWRITE(x,y,z,f) fwrite(x,y,z,filetab[f].fp)
#endif
#ifndef OSCLOSE
#define OSCLOSE osclose
#ifdef ANSI
extern void osclose(int i); /* we must define this */
#else
extern VOID osclose();
#endif
#endif
#ifndef OSSEEK
#define OSSEEK(f,loc) fseek(filetab[f].fp,loc,SEEK_SET)
#endif
#ifndef OSSEEKEND
#define OSSEEKEND(f) fseek(filetab[f].fp,0L,SEEK_END)
#endif
#ifndef OSSEEKCUR
#define OSSEEKCUR(f,loc) fseek(filetab[f].fp,loc,SEEK_CUR)
#endif
#ifndef OSTELL
#define OSTELL(f) ftell(filetab[f].fp)
#endif
#endif

#ifdef ASCII8
/* 8 bit ASCII character handling */
extern char ascii8tbl[];
extern unsigned char ascii8cnv[];
#define LC8 1   /* lower case 8bit */
#define LUC8 2  /* lower case 8bit with upper case version */
#define LU8 (LC8 | LUC8)
#define UC8 4   /* upper case 8bit (always have lower case version) */
/* ISUPPER return true for all upper case characters */
#define ISUPPER(c) (UC8 & ascii8tbl[(unsigned char)(c)])
/* ISLOWER returns true for all lowercase characters which have upper case versions */
#define ISLOWER(c) (LUC8 & ascii8tbl[(unsigned char)(c)])
/* ISLOWERA returns true for all lowercase characters */
#define ISLOWERA(c) (LC8 & ascii8tbl[(unsigned char)(c)])
/* ISLOWER7 returns true for characters a-z only */
#define ISLOWER7(c) (isascii(c) && islower(c))
/* these versions of TOUPPER and TOLOWER only work on characters that
   can be converted in case. The functions are the same, and do a table lookup*/
#define TOLOWER(c) (ascii8cnv[(unsigned char)(c) - 'A'])
#define TOUPPER(c) (ascii8cnv[(unsigned char)(c) - 'A'])
#else
/* We will modify the IS* functions so that they work over the full 8 bit
   character range since these characters can still be generated. */
#define ISLOWER(c) (((unsigned)(c)) < 128 && islower(c))
#define ISUPPER(c) (((unsigned)(c)) < 128 && isupper(c))
#define TOUPPER(c) toupper(c)
#define TOLOWER(c) tolower(c)
#define ISLOWER7(c) (((unsigned)(c)) < 128 && islower(c))
#define ISLOWERA(c) (((unsigned)(c)) < 128 && islower(c))
#endif

/* Handle the MEDMEM specification */
#ifdef MEDMEM
#ifdef __ZTC__
#define FAR _far
#else
#include <alloc.h>
#define FAR far
#endif
#define STRCMP _fstrcmp
#define STRCPY _fstrcpy
#define STRNCPY _fstrncpy
#define STRCAT _fstrcat
#define STRLEN _fstrlen
#define MEMCPY _fmemcpy
#ifdef __TSC__
#define MALLOC _fmalloc
#define CALLOC _fcalloc
#define MFREE  _ffree
#endif
#ifdef __TURBOC__
#define MALLOC farmalloc
#define CALLOC farcalloc
#define MFREE farfree
#endif
#endif

/************ DEFAULT DEFINITIONS  ******************/
#ifndef NNODES
#define NNODES          2000
#endif
#ifndef VSSIZE
#define VSSIZE          6000
#endif
#ifndef EDEPTH
#define EDEPTH          650
#endif
#ifndef ADEPTH
#define ADEPTH          1000
#endif
#ifndef FORWARD
#define FORWARD
#endif
#ifndef LOCAL
#define LOCAL           static
#endif
#ifndef AFMT
#define AFMT            "%x"
#endif
#ifndef FIXTYPE
#define FIXTYPE         long
#endif
#ifdef ANSI /* ANSI C Compilers already define this! */
#include <limits.h>
#define MAXFIX  LONG_MAX
#else
#ifndef MAXFIX
#define MAXFIX          (0x7fffffffL)
#endif
#endif
#ifndef MAXSLEN
#define MAXSLEN         (1000000)   /* no sequences longer than this */
#endif
#ifndef MAXVLEN
#define MAXVLEN         MAXSLEN
#endif
#ifndef ITYPE
#define ITYPE           long atol()
#endif
#ifndef ICNV
#define ICNV(n)         atol(n)
#endif
#ifndef IFMT
#define IFMT            "%ld"
#endif
#ifdef RATIOS
#ifndef RFMT
#define RFMT            "%ld/%ld"
#endif
#endif
#ifndef FLOTYPE
#define FLOTYPE         double
#endif
#ifndef OFFTYPE
#define OFFTYPE         int
#endif
#ifndef CVPTR
#define CVPTR(x)        ((OFFTYPE)(x))
#endif
#ifdef ANSI
#define VOIDP   void
#else
#define VOIDP
#endif
#ifndef CDECL
#define CDECL
#endif
#ifndef NEAR
#define NEAR
#endif
#ifndef FAR
#define FAR
#endif
#ifndef FNAMEMAX
#define FNAMEMAX 63
#endif
#ifndef OSAOPEN
#define OSAOPEN fopen
#endif
#ifndef OSBOPEN
#define OSBOPEN fopen
#endif
#ifndef MODETYPE
#define MODETYPE const char *
#endif
#ifndef OPEN_RO
#define OPEN_RO "r"
#endif
#ifndef OPEN_UPDATE
#define OPEN_UPDATE "r+"
#endif
#ifndef CREATE_WR
#define CREATE_WR "w"
#endif
#ifndef CREATE_UPDATE
#define CREATE_UPDATE "w+"
#endif
#ifndef CLOSED
#define CLOSED NULL
#endif
#ifndef OSGETC
#define OSGETC fgetc
#endif
#ifndef OSPUTC
#define OSPUTC fputc
#endif
#ifndef OSREAD
#define OSREAD fread
#endif
#ifndef OSWRITE
#define OSWRITE fwrite
#endif
#ifndef OSCLOSE
#define OSCLOSE fclose
#endif
#ifndef OSSEEK
#define OSSEEK(fp,loc) fseek(fp,loc,SEEK_SET)
#endif
#ifndef OSSEEKEND
#define OSSEEKEND(fp) fseek(fp,0L,SEEK_END)
#endif
#ifndef OSSEEKCUR
#define OSSEEKCUR(fp,loc) fseek(fp,loc,SEEK_CUR)
#endif
#ifndef OSTELL
#define OSTELL ftell
#endif
#ifndef FILEP
#define FILEP FILE *
#endif
#ifndef STDIN
#define STDIN stdin
#endif
#ifndef STDOUT
#define STDOUT stdout
#endif
#ifndef CONSOLE
#define CONSOLE stderr
#endif
#ifndef MALLOC
#define MALLOC malloc
#endif
#ifndef CALLOC
#define CALLOC calloc
#endif
#ifndef MFREE
#define MFREE free
#endif
#ifndef STRCMP
#define STRCMP strcmp
#endif
#ifndef STRCPY
#define STRCPY strcpy
#endif
#ifndef STRNCPY
#define STRNCPY strncpy
#endif
#ifndef STRCAT
#define STRCAT strcat
#endif
#ifndef STRLEN
#define STRLEN strlen
#endif
#ifndef MEMCPY
#define MEMCPY memcpy
#endif

/* useful definitions */
#ifndef TRUE
#define TRUE    1
#endif
#ifndef FALSE
#define FALSE   0
#endif

#ifdef COMPLX
#define PI 3.14159265358979323846
#endif

#ifdef ANSI
#include <stdlib.h>
#endif

/************* END OF COMPILER/ENVIRONMENT OPTIONS ************/



/* $putpatch.c$: "MODULE_XLISP_H_PROVIDES" */

/* include the dynamic memory definitions */
#include "xldmem.h"

/* program limits */
#define STRMAX          100             /* maximum length of a string constant */
#define HSIZE           199             /* symbol hash table size */
#define SAMPLE          100             /* control character sample rate */

/* function table offsets for the initialization functions */
#define FT_RMHASH       0
#define FT_RMQUOTE      1
#define FT_RMDQUOTE     2
#define FT_RMBQUOTE     3
#define FT_RMCOMMA      4
#define FT_RMLPAR       5
#define FT_RMRPAR       6
#define FT_RMSEMI       7
#define FT_CLNEW        10
#define FT_CLISNEW      11
#define FT_CLANSWER     12
#define FT_OBISNEW      13
#define FT_OBCLASS      14
#define FT_OBSHOW       15
#define FT_OBPRIN1      16
        
/* macro to push a value onto the argument stack */
#define pusharg(x)      {if (xlsp >= xlargstktop) xlargstkoverflow();\
                         *xlsp++ = (x);}

/* macros to protect pointers */
#define xlstkcheck(n)   {if (xlstack - (n) < xlstkbase) xlstkoverflow();}
#define xlsave(n)       {*--xlstack = &n; n = NIL;}
#define xlprotect(n)    {*--xlstack = &n;}

/* check the stack and protect a single pointer */
#define xlsave1(n)      {if (xlstack <= xlstkbase) xlstkoverflow();\
                         *--xlstack = &n; n = NIL;}
#define xlprot1(n)      {if (xlstack <= xlstkbase) xlstkoverflow();\
                         *--xlstack = &n;}

/* macros to pop pointers off the stack */
#define xlpop()         {++xlstack;}
#define xlpopn(n)       {xlstack+=(n);}

/* macros to manipulate the lexical environment */
#define xlframe(e)      cons(NIL,e)
#define xlfbind(s,v)    xlpbind(s,v,xlfenv);
#define xlpbind(s,v,e)  {rplaca(e,cons(cons(s,v),car(e)));}

/* macros to manipulate the dynamic environment */
#define xldbind(s,v)    {xldenv = cons(cons(s,getvalue(s)),xldenv);\
                         setvalue(s,v);}
#define xlunbind(e)     {for (; xldenv != (e); xldenv = cdr(xldenv))\
                           setvalue(car(car(xldenv)),cdr(car(xldenv)));}

/* macro to manipulate dynamic and lexical environment */

#define xlbind(s,v) {if (specialp(s)) xldbind(s,v) else xlpbind(s,v,xlenv)}
#define xlpdbind(s,v,e) {e = cons(cons(s,getvalue(s)),e);\
                         setvalue(s,v);}

/* type predicates */                          
#ifdef __BORLANDC__
#define null(x)         (((unsigned)(void _seg *)(x)) == ((unsigned)(void _seg *) NIL))
#else
#ifdef MSC
#define null(x)         (((unsigned)(_segment *)(x)) == ((unsigned)(_segment *) NIL))
#else
#define null(x)         ((x) == NIL)
#endif
#endif
#define atom(x)         (null(x) || ntype(x) != CONS)
#define listp(x)        (null(x) || ntype(x) == CONS)

#define consp(x)        (ntype(x) == CONS)
#define subrp(x)        (ntype(x) == SUBR)
#define fsubrp(x)       (ntype(x) == FSUBR)
#define stringp(x)      (ntype(x) == STRING)
#define symbolp(x)      (ntype(x) == SYMBOL)
#define streamp(x)      (ntype(x) == STREAM)
#define objectp(x)      (ntype(x) == OBJECT)
#define fixp(x)         (ntype(x) == FIXNUM)
#ifdef RATIOS
#define ratiop(x)       (ntype(x) == RATIO)
#endif
#define floatp(x)       (ntype(x) == FLONUM)
#ifdef COMPLX
#define complexp(x)     (ntype(x) == COMPLEX)
#endif
#ifdef RATIOS
#define numberp(x)      (ntype(x) == FIXNUM || ntype(x) == FLONUM || ntype(x) == RATIO)
#else
#define numberp(x)      (ntype(x) == FIXNUM || ntype(x) == FLONUM)
#endif
#define vectorp(x)      (ntype(x) == VECTOR)
#define closurep(x)     (ntype(x) == CLOSURE)
#define charp(x)        (ntype(x) == CHAR)
#define ustreamp(x)     (ntype(x) == USTREAM)
#define structp(x)      (ntype(x) == STRUCT)

#define boundp(x)       (getvalue(x) != s_unbound)
#define fboundp(x)      (getfunction(x) != s_unbound)

/* shorthand functions */
#define consa(x)        cons(x,NIL)
#define consd(x)        cons(NIL,x)

/* argument list parsing macros */
#define xlgetarg()      (testarg(nextarg()))
#define xllastarg()     {if (xlargc != 0) xltoomany();}
#define testarg(e)      (moreargs() ? (e) : xltoofew())
#define typearg(tp)     (tp(*xlargv) ? nextarg() : xlbadtype(*xlargv))
#define nextarg()       (--xlargc, *xlargv++)
#define moreargs()      (xlargc > 0)

/* macros to get arguments of a particular type */
#define xlgacons()      (testarg(typearg(consp)))
#define xlgalist()      (testarg(typearg(listp)))
#define xlgasymbol()    (testarg(typearg(symbolp)))
#define xlgasymornil()  (testarg(typearg(symbolp)))
#define xlgastring()    (testarg(typearg(stringp)))
#define xlgastrorsym()  (testarg(symbolp(*xlargv) ? getpname(nextarg()) : typearg(stringp)))
#define xlgaobject()    (testarg(typearg(objectp)))
#define xlgafixnum()    (testarg(typearg(fixp)))
#define xlgaflonum()    (testarg(typearg(floatp)))
#define xlgachar()      (testarg(typearg(charp)))
#define xlgavector()    (testarg(typearg(vectorp)))
#define xlgastream()    (testarg(typearg(streamp)))
#define xlgaustream()   (testarg(typearg(ustreamp)))
#define xlgaclosure()   (testarg(typearg(closurep)))
#define xlgastruct()    (testarg(typearg(structp)))


/* FILETABLE specification -- non-windows */
#ifdef FILETABLE
typedef struct {
    FILE *fp;
    char *tname;    /* true file name */
} FILETABLETYPE;
extern FILETABLETYPE filetab[FTABSIZE];
#endif

/* function definition structure */
typedef struct {
    char *fd_name;      /* function name */
    int fd_type;        /* function type */
    LVAL (*fd_subr)();  /* function entry point */
} FUNDEF;

/* execution context flags */
#define CF_GO           0x0001
#define CF_RETURN       0x0002
#define CF_THROW        0x0004
#define CF_ERROR        0x0008
#define CF_CLEANUP      0x0010
#define CF_CONTINUE     0x0020
#define CF_TOPLEVEL     0x0040
#define CF_BRKLEVEL     0x0080
#define CF_UNWIND       0x0100

/* execution context */
typedef LVAL NEAR *FRAMEP;
typedef struct context {
    int c_flags;                        /* context type flags */
    LVAL c_expr;                        /* expression (type dependent) */
    jmp_buf c_jmpbuf;                   /* longjmp context */
    struct context *c_xlcontext;        /* old value of xlcontext */
    LVAL * NEAR *c_xlstack;             /* old value of xlstack */
    LVAL NEAR *c_xlargv;                /* old value of xlargv */
    int c_xlargc;                       /* old value of xlargc */
    LVAL NEAR *c_xlfp;                  /* old value of xlfp */
    LVAL NEAR *c_xlsp;                  /* old value of xlsp */
    LVAL c_xlenv;                       /* old value of xlenv */
    LVAL c_xlfenv;                      /* old value of xlfenv */
    LVAL c_xldenv;                      /* old value of xldenv */
} CONTEXT;


/* external variables */

extern LVAL * NEAR xlstkbase[];     /* evaluation stack */
extern LVAL * NEAR *xlstack;            /* evaluation stack pointer */
#define xlstktop (&xlstkbase[EDEPTH])   /* top of the evaluation stack */
extern LVAL NEAR xlargstkbase[];        /* base of the argument stack */
#define xlargstktop (&xlargstkbase[ADEPTH]) /* top of the argument stack */
extern LVAL NEAR *xlfp;             /* argument frame pointer */
extern LVAL NEAR *xlsp;             /* argument stack pointer */
extern LVAL NEAR *xlargv;           /* current argument vector */
extern int xlargc;              /* current argument count */

#ifdef ANSI /* thanks for this trick go to Hume Smith */
#define _(x) x
#else
#define _(x) ()
#endif

/* OS system interface, *stuff file */
extern VOID oscheck _((void));  /* check for control character during exec */
extern VOID osinit _((char *banner)); /* initialize os interface */
extern VOID osfinish _((void)); /* restore os interface */
extern VOID osflush _((void));  /* flush terminal input buffer */
extern long osrand _((long));   /* next random number in sequence */
#ifdef PATHNAMES
extern FILEP ospopen _((char *name, int ascii)); /* open file using path */
#endif
extern VOID xoserror _((char *msg));/* print an error message */
extern int  ostgetc _((void));      /* get a character from the terminal */
extern VOID ostputc _((int ch));    /* put a character to the terminal */
#ifdef TIMES
extern unsigned long ticks_per_second _((void));
extern unsigned long run_tick_count _((void));
extern unsigned long real_tick_count _((void));
#endif
extern int renamebackup _((char *filename));
#ifdef FILETABLE
extern int truename _((char *name, char *rname));
#endif

/* for xlisp.c */
extern VOID xlrdsave _((LVAL expr));
extern VOID xlevsave _((LVAL expr));
extern VOID xlfatal _((char *msg));
extern VOID wrapup _((void));

/* for xleval */
extern LVAL xlxeval _((LVAL expr));
extern VOID xlabind _((LVAL fun, int argc, LVAL *argv));
extern VOID xlfunbound _((LVAL sym));
extern VOID xlargstkoverflow _((void));
extern int  macroexpand _((LVAL fun, LVAL args, LVAL *pval));
extern int  pushargs _((LVAL fun, LVAL args));
extern LVAL makearglist _((int argc, LVAL *argv));
extern VOID xlunbound _((LVAL sym));
extern VOID xlstkoverflow _((void));

/* for xlio */
extern int xlgetc _((LVAL fptr));
extern VOID xlungetc _((LVAL fptr, int ch));
extern int xlpeek _((LVAL fptr));
extern VOID xlputc _((LVAL fptr, int ch));
extern VOID xlflush _((void));
extern VOID stdprint _((LVAL expr));
extern VOID stdputstr _((char *str));
extern VOID errprint _((LVAL expr));
extern VOID errputstr _((char *str));
extern VOID dbgprint _((LVAL expr));
extern VOID dbgputstr _((char *str));
extern VOID trcprin1 _((LVAL expr));
extern VOID trcputstr _((char *str));

/* for xlprin */
extern VOID xlputstr _((LVAL fptr, char *str));
extern VOID xlprint _((LVAL fptr, LVAL vptr, int flag));
extern VOID xlprintl _((LVAL fptr, LVAL vptr, int flag));
extern int  xlgetcolumn _((LVAL fptr));
extern int  xlfreshline _((LVAL fptr));
extern VOID xlterpri _((LVAL fptr));
extern VOID xlputstr _((LVAL fptr, char* str));

/* for xljump */
extern VOID xljump _((CONTEXT *target, int mask, LVAL val));
extern VOID xlbegin _((CONTEXT *cptr, int flags, LVAL expr));
extern VOID xlend _((CONTEXT *cptr));
extern VOID xlgo _((LVAL label));
extern VOID xlreturn _((LVAL name, LVAL val));
extern VOID xlthrow _((LVAL tag, LVAL val));
extern VOID xlsignal _((char FAR *emsg, LVAL arg));
extern VOID xltoplevel _((void));
extern VOID xlbrklevel _((void));
extern VOID xlcleanup _((void));
extern VOID xlcontinue _((void));

/* for xllist */
#ifdef HASHFCNS
extern VOID xlsetgethash _((LVAL key, LVAL table, LVAL value));
#endif

/* for xlsubr */
extern int xlgetkeyarg _((LVAL key, LVAL *pval));
extern int xlgkfixnum _((LVAL key, LVAL *pval));
extern VOID xltest _((LVAL *pfcn, int *ptresult));
extern int needsextension _((char *name));
extern int eql _((LVAL arg1, LVAL arg2));
extern int equal _((LVAL arg, LVAL arg2));
#ifdef KEYARG
extern LVAL xlkey _((void));
extern LVAL xlapp1 _((LVAL fun, LVAL arg));
extern int dotest1 _((LVAL arg1, LVAL fun, LVAL kfun));
extern int dotest2 _((LVAL arg1, LVAL arg2, LVAL fun, LVAL kfun));
extern int dotest2s _((LVAL arg1, LVAL arg2, LVAL fun, LVAL kfun));
#else
extern int dotest1 _((LVAL arg1, LVAL fun));
extern int dotest2 _((LVAL arg1, LVAL arg2, LVAL fun));
#endif
#ifdef COMPLX
extern FLOTYPE makefloat _((LVAL arg));
#endif

/* for xlobj */
extern int xlobsetvalue _((LVAL pair, LVAL sym, LVAL val));
extern int xlobgetvalue _((LVAL pair, LVAL sym, LVAL *pval));
extern VOID putobj _((LVAL fptr, LVAL obj));

/* for xlread */
extern LVAL tentry _((int ch));
extern int xlload _((char *fname, int vflag, int pflag));
extern int xlread _((LVAL fptr, LVAL *pval));
extern int isnumber _((char *str, LVAL *pval));

/* for xlstruct */
extern LVAL xlrdstruct _((LVAL list));
extern VOID xlprstruct _((LVAL fptr, LVAL vptr, FIXTYPE plevel, int flag));

/* save/restore functions */
#ifdef SAVERESTORE
extern int xlirestore _((char *fname));
extern int xlisave _((char *fname));
#endif

/* external procedure declarations */
extern VOID obsymbols _((void));    /* initialize oop symbols */
extern VOID ossymbols _((void));    /* initialize os symbols */
extern VOID xlsymbols _((void));    /* initialize interpreter symbols */
extern VOID xloinit _((void));      /* initialize object functions */
extern VOID xlsinit _((void));      /* initialize xlsym.c */
extern VOID xlrinit _((void));      /* initialize xlread.c */
extern VOID xlminit _((void));      /* init xldmem */
extern VOID xldinit _((void));      /* initilaixe debugger */
extern  int xlinit _((char *resfile));  /* xlisp initialization routine */
extern LVAL xleval _((LVAL expr));  /* evaluate an expression */
extern LVAL xlapply _((int argc));  /* apply a function to arguments */
extern LVAL xlsubr _((char *sname, int type, LVAL (*fcn)(void),int offset));
                                /* enter a subr/fsubr */
extern LVAL xlenter _((char *name));/* enter a symbol */
extern LVAL xlmakesym _((char *name));  /* make an uninterned symbol */
extern LVAL xlgetvalue _((LVAL sym));   /* get value of a symbol (checked) */
extern VOID xlsetvalue _((LVAL sym, LVAL val)); /* set the value of symbol */
extern LVAL xlxgetvalue _((LVAL sym));  /* get value of a symbol */
extern LVAL xlgetfunction _((LVAL sym));/* get functional value of a symbol */
extern LVAL xlxgetfunction _((LVAL sym));
                            /* get functional value of a symbol (checked) */
extern VOID xlsetfunction _((LVAL sym, LVAL val));  /* set the functional value */
extern LVAL xlexpandmacros _((LVAL form));      /* expand macros in a form */
extern LVAL xlgetprop _((LVAL sym, LVAL prp));  /* get the value of a property */
extern VOID xlputprop _((LVAL sym, LVAL val, LVAL prp)); /*set value of property*/
extern VOID xlremprop _((LVAL sym, LVAL prp));  /* remove a property */
extern LVAL xlclose _((LVAL name, LVAL type, LVAL fargs, LVAL body, LVAL env, LVAL fenv));
                                /* create a function closure */
extern int hash _((char FAR *str, int len));    /* Hash the string */
extern int xlhash _((LVAL obj, int len));   /* Hash anything */

#ifdef RANDOM
extern LVAL newrandom _((long));            /* create a random-state */
#endif

/* argument list parsing functions */
extern LVAL xlgetfile _((int outflag));     /* get a file/stream argument */
extern LVAL xlgetfname _((void));   /* get a filename argument */

/* error reporting functions  (don't *really* return at all) */
extern LVAL xltoofew _((void));     /* report "too few arguments" error */
extern VOID xltoomany _((void));    /* report "too many arguments" error */
extern VOID xltoolong _((void));    /* too long to process error */
extern LVAL xlbadtype _((LVAL arg));/* report "bad argument type" error */
extern LVAL xlerror _((char FAR *emsg, LVAL arg));  /* report arbitrary error */
extern VOID xlcerror _((char FAR *cmsg, char FAR *emsg, LVAL arg)); /*recoverable error*/
extern VOID xlerrprint _((char *hdr,char FAR *cmsg, char FAR *emsg, LVAL arg));
extern VOID xlbaktrace _((int n));  /* do a backtrace */
extern VOID xlabort _((char *emsg));    /* serious error handler */
extern VOID xlfail _((char *emsg));     /* xlisp error handler */
extern VOID xlbreak _((char FAR *emsg, LVAL arg));  /* enter break look */
extern VOID xlnoassign _((LVAL arg));   /* report assignment to constant error */
extern int xlcvttype _((LVAL arg));

#ifdef SERVER
extern int initXlisp _((char *resfile));    /* Initialize, return error code */
extern int execXlisp _((char *cmd, int restype, 
        char FAR * FAR *resstr, LVAL * resval)); /* execute expression */
extern VOID wrapupXlisp _((void));          /* relinquish memory, quit */
#endif

extern int checkfeatures _((LVAL arg, int which));  /* features featuure */

extern int redirectin, redirectout; /* input/output redirection */
extern char buf[];              /* temporary character buffer */

extern struct node isnil;
#define NIL (&isnil)

#include "xlftab.h"

/* Should be last in file: */
/* $putpatch.c$: "MODULE_XLISP_H_GLOBALS" */
