; initialization file for XLISP-PLUS 2.1e

(princ "XLISP-PLUS contains contributed code by:
Tom Almy, Mikael Pettersson, Neal Holtz, Johnny Greenblatt, Ken Whedbee,
Blake McBride, and Pete Yadlowsky.
Portions Copyright (c) 1988, Luke Tierney.\n")

(defun strcat (&rest str)	;; Backwards compatibility
       (apply #'concatenate 'string str))


; (fmakunbound sym) - make a symbol function be unbound
(defun fmakunbound (sym) (setf (symbol-function sym) '*unbound*) sym)

; (mapcan fun list [ list ]...)
; (defmacro mapcan (&rest args) `(apply #'nconc (mapcar ,@args)))

; (mapcon fun list [ list ]...)
; (defmacro mapcon (&rest args) `(apply #'nconc (maplist ,@args)))

; (set-macro-character ch fun [ tflag ])
(defun set-macro-character (ch fun &optional tflag)
    (setf (aref *readtable* (char-int ch))
          (cons (if tflag :tmacro :nmacro) fun))
    t)

; (get-macro-character ch)
(defun get-macro-character (ch)
  (if (consp (aref *readtable* (char-int ch)))
    (cdr (aref *readtable* (char-int ch)))
    nil))

; (savefun fun) - save a function definition to a file
(defmacro savefun (fun)
  `(let* ((fname (strcat (symbol-name ',fun) ".lsp"))
          (fval (get-lambda-expression (symbol-function ',fun)))
          (fp (open fname :direction :output)))
     (cond (fp (print (cons (if (eq (car fval) 'lambda)
                                'defun
                                'defmacro)
                            (cons ',fun (cdr fval))) fp)
               (close fp)
               fname)
           (t nil))))

; (debug) - enable debug breaks
(defun debug ()
       (setq *breakenable* t))

; (nodebug) - disable debug breaks
(defun nodebug ()
       (setq *breakenable* nil))

; initialize to enable breaks but no trace back
(setq *breakenable* t *tracenable* nil)


; macros get displaced with expansion
; Good feature, but commented out to avoid shock.
; (setq *displace-macros* t)

;; Select one of these three choices
;; Other modes will not read in other standard lsp files


; print in upper case, case insensitive input
(setq *print-case* :upcase *readtable-case* :upcase)

; print in lower case
; (setq *print-case* :downcase *readtable-case* :upcase)

; case sensitive, lowercase and uppercase swapped (favors lower case)
; (setq *print-case* :downcase *readtable-case* :invert)


;; Define Class and Object to be class and object when in case sensitive
;; mode

(when (eq *readtable-case* :invert)
      (defconstant Class class)
      (defconstant Object object))

;; Set this up however you want it
(setq *features* (list :xlisp))
;; Differences in various implementations, needed by example programs
(when (fboundp 'get-internal-run-time) 
      (setq *features* (cons :times *features*)))
(when (fboundp 'generic) 
      (setq *features* (cons :generic *features*)))
(when (fboundp 'find-if)
      (setq *features* (cons :posfcns *features*)))
(when (fboundp 'log)
      (setq *features* (cons :math *features*)))
